/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.lar;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.cal.TZSRecurrence;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import com.liferay.portlet.calendar.service.persistence.CalEventUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletPreferences;

public class CalendarPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "calendar";
    private static final PortletDataHandlerBoolean _events = new PortletDataHandlerBoolean("calendar", "events", true, true);

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            if (!context.addPrimaryKey(CalendarPortletDataHandlerImpl.class, "deleteData")) {
                CalEventLocalServiceUtil.deleteEvents((long)context.getGroupId());
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("calendar-data");
            root.addAttribute("group-id", String.valueOf(context.getGroupId()));
            List events = CalEventUtil.findByGroupId((long)context.getGroupId());
            for (CalEvent event : events) {
                this.exportEvent(context, root, event);
            }
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_events};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_events};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List eventsEl = root.elements("event");
            for (Element eventEl : eventsEl) {
                String path = eventEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                CalEvent event = (CalEvent)context.getZipEntryAsObject(path);
                this.importEvent(context, event);
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    protected void exportEvent(PortletDataContext context, Element root, CalEvent event) throws SystemException {
        if (!context.isWithinDateRange(event.getModifiedDate())) {
            return;
        }
        String path = this.getEventPath(context, event);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element eventEl = root.addElement("event");
        eventEl.addAttribute("path", path);
        event.setUserUuid(event.getUserUuid());
        context.addZipEntry(path, (Object)event);
    }

    protected String getEventPath(PortletDataContext context, CalEvent event) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("8"));
        sb.append("/events/");
        sb.append(event.getEventId());
        sb.append(".xml");
        return sb.toString();
    }

    protected void importEvent(PortletDataContext context, CalEvent event) throws Exception {
        long userId = context.getUserId(event.getUserUuid());
        Date startDate = event.getStartDate();
        int startDateMonth = 0;
        int startDateDay = 0;
        int startDateYear = 0;
        int startDateHour = 0;
        int startDateMinute = 0;
        if (startDate != null) {
            Calendar startCal = CalendarFactoryUtil.getCalendar();
            startCal.setTime(startDate);
            startDateMonth = startCal.get(2);
            startDateDay = startCal.get(5);
            startDateYear = startCal.get(1);
            startDateHour = startCal.get(10);
            startDateMinute = startCal.get(12);
            if (startCal.get(9) == 1) {
                startDateHour += 12;
            }
        }
        Date endDate = event.getEndDate();
        int endDateMonth = 0;
        int endDateDay = 0;
        int endDateYear = 0;
        if (endDate != null) {
            Calendar endCal = CalendarFactoryUtil.getCalendar();
            endCal.setTime(endDate);
            endDateMonth = endCal.get(2);
            endDateDay = endCal.get(5);
            endDateYear = endCal.get(1);
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(context.getGroupId());
        CalEvent existingEvent = null;
        if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
            existingEvent = CalEventUtil.fetchByUUID_G((String)event.getUuid(), (long)context.getGroupId());
            if (existingEvent == null) {
                CalEventLocalServiceUtil.addEvent((String)event.getUuid(), (long)userId, (String)event.getTitle(), (String)event.getDescription(), (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)event.getDurationHour(), (int)event.getDurationMinute(), (boolean)event.getAllDay(), (boolean)event.getTimeZoneSensitive(), (String)event.getType(), (boolean)event.getRepeating(), (TZSRecurrence)event.getRecurrenceObj(), (int)event.getRemindBy(), (int)event.getFirstReminder(), (int)event.getSecondReminder(), (ServiceContext)serviceContext);
            } else {
                CalEventLocalServiceUtil.updateEvent((long)userId, (long)existingEvent.getEventId(), (String)event.getTitle(), (String)event.getDescription(), (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)event.getDurationHour(), (int)event.getDurationMinute(), (boolean)event.getAllDay(), (boolean)event.getTimeZoneSensitive(), (String)event.getType(), (boolean)event.getRepeating(), (TZSRecurrence)event.getRecurrenceObj(), (int)event.getRemindBy(), (int)event.getFirstReminder(), (int)event.getSecondReminder(), (ServiceContext)serviceContext);
            }
        } else {
            CalEventLocalServiceUtil.addEvent((long)userId, (String)event.getTitle(), (String)event.getDescription(), (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)event.getDurationHour(), (int)event.getDurationMinute(), (boolean)event.getAllDay(), (boolean)event.getTimeZoneSensitive(), (String)event.getType(), (boolean)event.getRepeating(), (TZSRecurrence)event.getRecurrenceObj(), (int)event.getRemindBy(), (int)event.getFirstReminder(), (int)event.getSecondReminder(), (ServiceContext)serviceContext);
        }
    }
}

