/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.service.impl;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portlet.calendar.model.CalEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalEventLocalUtil {
    public static final String CACHE_NAME = CalEventLocalUtil.class.getName();
    private static PortalCache _cache = MultiVMPoolUtil.getCache((String)CACHE_NAME);

    protected static void clearEventsPool(long groupId) {
        String key = CalEventLocalUtil._encodeKey(groupId);
        _cache.remove(key);
    }

    protected static Map<String, List<CalEvent>> getEventsPool(long groupId) {
        String key = CalEventLocalUtil._encodeKey(groupId);
        ConcurrentHashMap eventsPool = (ConcurrentHashMap)_cache.get(key);
        if (eventsPool == null) {
            eventsPool = new ConcurrentHashMap();
            _cache.put(key, eventsPool);
        }
        return eventsPool;
    }

    private static String _encodeKey(long groupId) {
        StringBuilder sb = new StringBuilder();
        sb.append(CACHE_NAME);
        sb.append("#");
        sb.append(groupId);
        return sb.toString();
    }
}

