/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.cal.TZSRecurrence;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.base.CalEventServiceBaseImpl;
import com.liferay.portlet.calendar.service.permission.CalEventPermission;
import com.liferay.portlet.calendar.service.permission.CalendarPermission;
import java.io.File;

public class CalEventServiceImpl
extends CalEventServiceBaseImpl {
    public CalEvent addEvent(String title, String description, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int durationHour, int durationMinute, boolean allDay, boolean timeZoneSensitive, String type, boolean repeating, TZSRecurrence recurrence, int remindBy, int firstReminder, int secondReminder, ServiceContext serviceContext) throws PortalException, SystemException {
        CalendarPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_EVENT");
        return this.calEventLocalService.addEvent(this.getUserId(), title, description, startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, endDateMonth, endDateDay, endDateYear, durationHour, durationMinute, allDay, timeZoneSensitive, type, repeating, recurrence, remindBy, firstReminder, secondReminder, serviceContext);
    }

    public void deleteEvent(long eventId) throws PortalException, SystemException {
        CalEventPermission.check(this.getPermissionChecker(), eventId, "DELETE");
        this.calEventLocalService.deleteEvent(eventId);
    }

    public File exportEvent(long eventId) throws PortalException, SystemException {
        CalEventPermission.check(this.getPermissionChecker(), eventId, "VIEW");
        return this.calEventLocalService.exportEvent(this.getGuestOrUserId(), eventId);
    }

    public File exportGroupEvents(long groupId, String fileName) throws PortalException, SystemException {
        CalendarPermission.check(this.getPermissionChecker(), groupId, "EXPORT_ALL_EVENTS");
        return this.calEventLocalService.exportGroupEvents(this.getUserId(), groupId, fileName);
    }

    public CalEvent getEvent(long eventId) throws PortalException, SystemException {
        CalEventPermission.check(this.getPermissionChecker(), eventId, "VIEW");
        return this.calEventLocalService.getEvent(eventId);
    }

    public void importICal4j(long groupId, File file) throws PortalException, SystemException {
        CalendarPermission.check(this.getPermissionChecker(), groupId, "ADD_EVENT");
        this.calEventLocalService.importICal4j(this.getUserId(), groupId, file);
    }

    public CalEvent updateEvent(long eventId, String title, String description, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int durationHour, int durationMinute, boolean allDay, boolean timeZoneSensitive, String type, boolean repeating, TZSRecurrence recurrence, int remindBy, int firstReminder, int secondReminder, ServiceContext serviceContext) throws PortalException, SystemException {
        CalEventPermission.check(this.getPermissionChecker(), eventId, "UPDATE");
        return this.calEventLocalService.updateEvent(this.getUserId(), eventId, title, description, startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, endDateMonth, endDateDay, endDateYear, durationHour, durationMinute, allDay, timeZoneSensitive, type, repeating, recurrence, remindBy, firstReminder, secondReminder, serviceContext);
    }
}

