/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.social;

import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import com.liferay.portlet.calendar.service.permission.CalEventPermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;

public class CalendarActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{CalEvent.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ThemeDisplay themeDisplay) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!CalEventPermission.contains(permissionChecker, activity.getClassPK(), "VIEW")) {
            return null;
        }
        String groupName = "";
        if (activity.getGroupId() != themeDisplay.getScopeGroupId()) {
            groupName = this.getGroupName(activity.getGroupId(), themeDisplay);
        }
        String creatorUserName = this.getUserName(activity.getUserId(), themeDisplay);
        int activityType = activity.getType();
        CalEvent event = CalEventLocalServiceUtil.getEvent((long)activity.getClassPK());
        String link = themeDisplay.getPortalURL() + themeDisplay.getPathMain() + "/calendar/find_event?redirect=" + themeDisplay.getURLCurrent() + "&eventId=" + activity.getClassPK();
        String titlePattern = null;
        if (activityType == 1) {
            titlePattern = "activity-calendar-add-event";
        } else if (activityType == 2) {
            titlePattern = "activity-calendar-update-event";
        }
        if (Validator.isNotNull((String)groupName)) {
            titlePattern = titlePattern + "-in";
        }
        String eventTitle = this.wrapLink(link, HtmlUtil.escape((String)this.cleanContent(event.getTitle())));
        Object[] titleArguments = new Object[]{groupName, creatorUserName, eventTitle};
        String title = themeDisplay.translate(titlePattern, titleArguments);
        String body = "";
        return new SocialActivityFeedEntry(link, title, body);
    }
}

