/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.DocumentSummary;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import java.util.Date;
import javax.portlet.PortletURL;

public class Indexer
implements com.liferay.portal.kernel.search.Indexer {
    public static final String PORTLET_ID = "8";
    private static final String[] _CLASS_NAMES = new String[]{CalEvent.class.getName()};

    public static void addEvent(long companyId, long groupId, long userId, String userName, long eventId, String title, String description, Date displayDate, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getEventDocument(companyId, groupId, userId, userName, eventId, title, description, displayDate, tagsEntries, expandoBridge);
        SearchEngineUtil.addDocument((long)companyId, (Document)doc);
    }

    public static void deleteEvent(long companyId, long eventId) throws SearchException {
        SearchEngineUtil.deleteDocument((long)companyId, (String)Indexer.getEventUID(eventId));
    }

    public static Document getEventDocument(long companyId, long groupId, long userId, String userName, long eventId, String title, String description, Date displayDate, String[] tagsEntries, ExpandoBridge expandoBridge) {
        long scopeGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                groupId = group.getParentGroupId();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        userName = PortalUtil.getUserName((long)userId, (String)userName);
        description = HtmlUtil.extractText((String)description);
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, eventId);
        doc.addModifiedDate(displayDate);
        doc.addKeyword("companyId", companyId);
        doc.addKeyword("portletId", PORTLET_ID);
        doc.addKeyword("groupId", groupId);
        doc.addKeyword("scopeGroupId", scopeGroupId);
        doc.addKeyword("userId", userId);
        doc.addText("userName", userName);
        doc.addText("title", title);
        doc.addText("description", description);
        doc.addKeyword("tagsEntries", tagsEntries);
        doc.addKeyword("entryClassName", CalEvent.class.getName());
        doc.addKeyword("entryClassPK", eventId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)doc, (ExpandoBridge)expandoBridge);
        return doc;
    }

    public static String getEventUID(long eventId) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, eventId);
        return doc.get("uid");
    }

    public static void updateEvent(long companyId, long groupId, long userId, String userName, long eventId, String title, String description, Date displayDate, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getEventDocument(companyId, groupId, userId, userName, eventId, title, description, displayDate, tagsEntries, expandoBridge);
        SearchEngineUtil.updateDocument((long)companyId, (String)doc.get("uid"), (Document)doc);
    }

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    public DocumentSummary getDocumentSummary(Document doc, String snippet, PortletURL portletURL) {
        String title = doc.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)doc.get("description"), (int)200);
        }
        String eventId = doc.get("entryClassPK");
        portletURL.setParameter("struts_action", "/calendar/view_event");
        portletURL.setParameter("eventId", eventId);
        return new DocumentSummary(title, content, portletURL);
    }

    public void reIndex(String className, long classPK) throws SearchException {
        try {
            CalEventLocalServiceUtil.reIndex((long)classPK);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void reIndex(String[] ids) throws SearchException {
        try {
            CalEventLocalServiceUtil.reIndex((String[])ids);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }
}

