/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.action;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.communities.util.CommunitiesUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class UpdatePageAction
extends JSONAction {
    public String getJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"plid");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutId");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"parentLayoutId");
        Layout layout = null;
        if (plid > 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
        } else if (layoutId > 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        } else if (parentLayoutId > 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId);
        }
        if (layout != null ? !LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE") : !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"MANAGE_LAYOUTS")) {
            return null;
        }
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        JSONObject jsonObj = JSONFactoryUtil.createJSONObject();
        if (cmd.equals("add")) {
            String[] array = this.addPage(themeDisplay, request, response);
            jsonObj.put("layoutId", array[0]);
            jsonObj.put("url", array[1]);
        } else if (cmd.equals("delete")) {
            CommunitiesUtil.deleteLayout(request, response);
        } else if (cmd.equals("display_order")) {
            this.updateDisplayOrder(request);
        } else if (cmd.equals("name")) {
            this.updateName(request);
        } else if (cmd.equals("parent_layout_id")) {
            this.updateParentLayoutId(request);
        } else if (cmd.equals("priority")) {
            this.updatePriority(request);
        }
        return jsonObj.toString();
    }

    protected String[] addPage(ThemeDisplay themeDisplay, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String doAsUserId = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserId");
        String doAsUserLanguageId = ParamUtil.getString((HttpServletRequest)request, (String)"doAsUserLanguageId");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"parentLayoutId");
        String name = ParamUtil.getString((HttpServletRequest)request, (String)"name", (String)"New Page");
        String title = "";
        String description = "";
        String type = "portlet";
        boolean hidden = false;
        String friendlyURL = "";
        Layout layout = LayoutServiceUtil.addLayout((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)name, (String)title, (String)description, (String)type, (boolean)hidden, (String)friendlyURL);
        String[] eventClasses = StringUtil.split((String)PropsUtil.get("layout.configuration.action.update", new Filter(layout.getType())));
        EventsProcessorUtil.process("layout.configuration.action.update", eventClasses, request, response);
        String layoutURL = PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
        if (Validator.isNotNull((String)doAsUserId)) {
            layoutURL = HttpUtil.addParameter((String)layoutURL, (String)"doAsUserId", (String)themeDisplay.getDoAsUserId());
        }
        if (Validator.isNotNull((String)doAsUserLanguageId)) {
            layoutURL = HttpUtil.addParameter((String)layoutURL, (String)"doAsUserLanguageId", (String)themeDisplay.getDoAsUserLanguageId());
        }
        return new String[]{String.valueOf(layout.getLayoutId()), layoutURL};
    }

    protected void updateDisplayOrder(HttpServletRequest request) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"parentLayoutId");
        long[] layoutIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)request, (String)"layoutIds"), (long)0L);
        LayoutServiceUtil.setLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (long[])layoutIds);
    }

    protected void updateName(HttpServletRequest request) throws Exception {
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"plid");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutId");
        String name = ParamUtil.getString((HttpServletRequest)request, (String)"name");
        String languageId = ParamUtil.getString((HttpServletRequest)request, (String)"languageId");
        if (plid <= 0L) {
            LayoutServiceUtil.updateName((long)groupId, (boolean)privateLayout, (long)layoutId, (String)name, (String)languageId);
        } else {
            LayoutServiceUtil.updateName((long)plid, (String)name, (String)languageId);
        }
    }

    protected void updateParentLayoutId(HttpServletRequest request) throws Exception {
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"plid");
        long parentPlid = ParamUtil.getLong((HttpServletRequest)request, (String)"parentPlid");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutId");
        long parentLayoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"parentLayoutId", (long)0L);
        if (plid <= 0L) {
            LayoutServiceUtil.updateParentLayoutId((long)groupId, (boolean)privateLayout, (long)layoutId, (long)parentLayoutId);
        } else {
            LayoutServiceUtil.updateParentLayoutId((long)plid, (long)parentPlid);
        }
    }

    protected void updatePriority(HttpServletRequest request) throws Exception {
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"plid");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutId");
        int priority = ParamUtil.getInteger((HttpServletRequest)request, (String)"priority");
        if (plid <= 0L) {
            LayoutServiceUtil.updatePriority((long)groupId, (boolean)privateLayout, (long)layoutId, (int)priority);
        } else {
            LayoutServiceUtil.updatePriority((long)plid, (int)priority);
        }
    }
}

