/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.messaging;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.communities.messaging.LayoutsRemotePublisherRequest;
import com.liferay.portlet.communities.util.StagingUtil;
import java.util.Date;
import java.util.Map;

public class LayoutsRemotePublisherMessageListener
extends BaseMessageListener {
    public LayoutsRemotePublisherMessageListener() {
    }

    public LayoutsRemotePublisherMessageListener(SingleDestinationMessageSender statusSender, MessageSender responseSender) {
        super(statusSender, responseSender);
    }

    protected void doReceive(Message message, MessageStatus messageStatus) throws Exception {
        int last;
        LayoutsRemotePublisherRequest publisherRequest = (LayoutsRemotePublisherRequest)JSONFactoryUtil.deserialize((String)((String)message.getPayload()));
        messageStatus.setPayload((Object)publisherRequest);
        long userId = publisherRequest.getUserId();
        long sourceGroupId = publisherRequest.getSourceGroupId();
        boolean privateLayout = publisherRequest.isPrivateLayout();
        Map<Long, Boolean> layoutIdMap = publisherRequest.getLayoutIdMap();
        Map<String, String[]> parameterMap = publisherRequest.getParameterMap();
        String remoteAddress = publisherRequest.getRemoteAddress();
        int remotePort = publisherRequest.getRemotePort();
        boolean secureConnection = publisherRequest.isSecureConnection();
        long remoteGroupId = publisherRequest.getRemoteGroupId();
        boolean remotePrivateLayout = publisherRequest.isRemotePrivateLayout();
        Date startDate = publisherRequest.getStartDate();
        Date endDate = publisherRequest.getEndDate();
        String range = MapUtil.getString(parameterMap, (String)"range");
        if (range.equals("last") && (last = MapUtil.getInteger(parameterMap, (String)"last")) > 0) {
            Date scheduledFireTime = publisherRequest.getScheduledFireTime();
            startDate = new Date(scheduledFireTime.getTime() - (long)last * 3600000L);
            endDate = scheduledFireTime;
        }
        PrincipalThreadLocal.setName((long)userId);
        User user = UserLocalServiceUtil.getUserById((long)userId);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)false);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        StagingUtil.copyRemoteLayouts(sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, secureConnection, remoteGroupId, remotePrivateLayout, parameterMap, startDate, endDate);
    }
}

