/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.model;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommunityTemplateModelListener
extends BaseModelListener<LayoutSet> {
    private static final String _DEFAULT_TEMPLATE_COMMUNITY_NAME = "DEFAULT_TEMPLATE";
    private static final String _OPEN_TEMPLATE_COMMUNITY_NAME = "OPEN_TEMPLATE";
    private static final String _PRIVATE_TEMPLATE_COMMUNITY_NAME = "PRIVATE_TEMPLATE";
    private static final String _RESTRICTED_TEMPLATE_COMMUNITY_NAME = "RESTRICTED_TEMPLATE";
    private static final String _TEMPLATE_POSTFIX = "_TEMPLATE";
    private static Log _log = LogFactoryUtil.getLog(CommunityTemplateModelListener.class);
    private Map<String, String[]> _templateParameters = this.getTemplateParameters();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAfterCreate(LayoutSet layoutSet) {
        File file = null;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)layoutSet.getGroupId());
            if (!group.isCommunity() || group.getName().contains(_TEMPLATE_POSTFIX)) {
                return;
            }
            Group templateGroup = this.getTemplateGroup(group);
            if (templateGroup == null) {
                return;
            }
            Group templateStagingGroup = templateGroup.getStagingGroup();
            if (templateStagingGroup == null) {
                return;
            }
            file = LayoutLocalServiceUtil.exportLayoutsAsFile((long)templateStagingGroup.getGroupId(), (boolean)layoutSet.isPrivateLayout(), null, this._templateParameters, null, null);
            LayoutLocalServiceUtil.importLayouts((long)group.getCreatorUserId(), (long)group.getGroupId(), (boolean)layoutSet.isPrivateLayout(), this._templateParameters, (File)file);
        }
        catch (Exception e) {
            _log.error((Object)("Unble to import layouts for group " + layoutSet.getGroupId()), (Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    protected Group getTemplateGroup(Group group) throws PortalException, SystemException {
        String templateCommunityName = null;
        int type = group.getType();
        if (type == 1) {
            templateCommunityName = _OPEN_TEMPLATE_COMMUNITY_NAME;
        } else if (type == 3) {
            templateCommunityName = _PRIVATE_TEMPLATE_COMMUNITY_NAME;
        } else if (type == 2) {
            templateCommunityName = _RESTRICTED_TEMPLATE_COMMUNITY_NAME;
        } else {
            throw new IllegalArgumentException("Invalid community type " + group.getType());
        }
        Group templateGroup = null;
        try {
            templateGroup = GroupLocalServiceUtil.getGroup((long)group.getCompanyId(), (String)templateCommunityName);
        }
        catch (NoSuchGroupException nsge1) {
            try {
                templateGroup = GroupLocalServiceUtil.getGroup((long)group.getCompanyId(), (String)_DEFAULT_TEMPLATE_COMMUNITY_NAME);
            }
            catch (NoSuchGroupException nsge2) {
                // empty catch block
            }
        }
        return templateGroup;
    }

    protected Map<String, String[]> getTemplateParameters() {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("CATEGORIES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LAYOUTS_IMPORT_MODE", new String[]{"MERGE_BY_LAYOUT_NAME"});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_USER_PREFERENCES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLETS_MERGE_MODE", new String[]{"ADD_TO_BOTTOM"});
        parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        parameterMap.put("USER_PERMISSIONS", new String[]{Boolean.FALSE.toString()});
        return parameterMap;
    }
}

