/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.util;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommunitiesUtil {
    public static void deleteLayout(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        CommunitiesUtil.deleteLayout(request, response);
    }

    public static void deleteLayout(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)renderResponse);
        CommunitiesUtil.deleteLayout(request, response);
    }

    public static void deleteLayout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"plid");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((HttpServletRequest)request, (String)"layoutId");
        Layout layout = null;
        if (plid <= 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        } else {
            layout = LayoutLocalServiceUtil.getLayout((long)plid);
            groupId = layout.getGroupId();
            privateLayout = layout.isPrivateLayout();
            layoutId = layout.getLayoutId();
        }
        Group group = layout.getGroup();
        if (group.isStagingGroup() && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"MANAGE_STAGING") && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"PUBLISH_STAGING")) {
            throw new PrincipalException();
        }
        if (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"DELETE")) {
            String[] eventClasses = StringUtil.split((String)PropsUtil.get("layout.configuration.action.delete", new Filter(layout.getType())));
            EventsProcessorUtil.process("layout.configuration.action.delete", eventClasses, request, response);
        }
        LayoutServiceUtil.deleteLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
    }
}

