/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.util;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.PortalException;
import com.liferay.portal.RemoteExportException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Duration;
import com.liferay.portal.kernel.cal.Recurrence;
import com.liferay.portal.kernel.cal.RecurrenceSerializer;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.http.GroupServiceHttp;
import com.liferay.portal.service.http.LayoutServiceHttp;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.communities.messaging.LayoutsLocalPublisherRequest;
import com.liferay.portlet.communities.messaging.LayoutsRemotePublisherRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StagingUtil {
    public static void copyFromLive(ActionRequest actionRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = StagingUtil.getStagingParameters(actionRequest);
        StagingUtil._publishLayouts(actionRequest, liveGroupId, stagingGroupId, parameterMap, false);
    }

    public static void copyFromLive(ActionRequest actionRequest, Portlet portlet) throws Exception {
        long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
        Layout targetLayout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group stagingGroup = targetLayout.getGroup();
        Group liveGroup = stagingGroup.getLiveGroup();
        Layout sourceLayout = LayoutLocalServiceUtil.getLayout((long)liveGroup.getGroupId(), (boolean)targetLayout.isPrivateLayout(), (long)targetLayout.getLayoutId());
        StagingUtil.copyPortlet(actionRequest, liveGroup.getGroupId(), stagingGroup.getGroupId(), sourceLayout.getPlid(), targetLayout.getPlid(), portlet.getPortletId());
    }

    public static void copyPortlet(ActionRequest actionRequest, long sourceGroupId, long targetGroupId, long sourcePlid, long targetPlid, String portletId) throws Exception {
        Map<String, String[]> parameterMap = StagingUtil.getStagingParameters(actionRequest);
        File file = LayoutLocalServiceUtil.exportPortletInfoAsFile((long)sourcePlid, (long)sourceGroupId, (String)portletId, parameterMap, null, null);
        LayoutServiceUtil.importPortletInfo((long)targetPlid, (long)targetGroupId, (String)portletId, parameterMap, (File)file);
    }

    public static void copyRemoteLayouts(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> exportParameterMap, String remoteAddress, int remotePort, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Map<String, String[]> importParameterMap, Date startDate, Date endDate) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = UserLocalServiceUtil.getUser((long)permissionChecker.getUserId());
        StringBuilder sb = new StringBuilder();
        if (secureConnection) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(remoteAddress);
        sb.append(":");
        sb.append(remotePort);
        String url = sb.toString();
        HttpPrincipal httpPrincipal = new HttpPrincipal(url, user.getEmailAddress(), user.getPassword(), user.getPasswordEncrypted());
        try {
            GroupServiceHttp.getGroup(httpPrincipal, remoteGroupId);
        }
        catch (NoSuchGroupException nsge) {
            RemoteExportException ree = new RemoteExportException(2);
            ree.setGroupId(remoteGroupId);
            throw ree;
        }
        catch (SystemException se) {
            RemoteExportException ree = new RemoteExportException(1);
            ree.setURL(url);
            throw ree;
        }
        byte[] bytes = null;
        if (layoutIdMap == null) {
            bytes = LayoutServiceUtil.exportLayouts((long)sourceGroupId, (boolean)privateLayout, exportParameterMap, (Date)startDate, (Date)endDate);
        } else {
            ArrayList<Layout> layouts = new ArrayList<Layout>();
            for (Map.Entry<Long, Boolean> entry : layoutIdMap.entrySet()) {
                long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
                boolean includeChildren = entry.getValue();
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                if (!layouts.contains(layout)) {
                    layouts.add(layout);
                }
                for (Layout parentLayout : StagingUtil.getMissingParents(layout, sourceGroupId)) {
                    if (layouts.contains(parentLayout)) continue;
                    layouts.add(parentLayout);
                }
                if (!includeChildren) continue;
                for (Layout childLayout : layout.getAllChildren()) {
                    if (layouts.contains(childLayout)) continue;
                    layouts.add(childLayout);
                }
            }
            long[] layoutIds = new long[layouts.size()];
            for (int i = 0; i < layouts.size(); ++i) {
                Layout curLayout = (Layout)layouts.get(i);
                layoutIds[i] = curLayout.getLayoutId();
            }
            if (layoutIds.length <= 0) {
                throw new RemoteExportException(3);
            }
            bytes = LayoutServiceUtil.exportLayouts((long)sourceGroupId, (boolean)privateLayout, (long[])layoutIds, exportParameterMap, (Date)startDate, (Date)endDate);
        }
        LayoutServiceHttp.importLayouts(httpPrincipal, remoteGroupId, remotePrivateLayout, importParameterMap, bytes);
    }

    public static List<Layout> getMissingParents(Layout layout, long liveGroupId) throws PortalException, SystemException {
        ArrayList<Layout> missingParents = new ArrayList<Layout>();
        long parentLayoutId = layout.getParentLayoutId();
        while (parentLayoutId > 0L) {
            try {
                LayoutLocalServiceUtil.getLayout((long)liveGroupId, (boolean)layout.isPrivateLayout(), (long)parentLayoutId);
                break;
            }
            catch (NoSuchLayoutException nsle) {
                Layout parent = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId);
                missingParents.add(parent);
                parentLayoutId = parent.getParentLayoutId();
            }
        }
        return missingParents;
    }

    public static String getSchedulerGroupName(String destinationName, long groupId) {
        StringBuilder sb = new StringBuilder();
        sb.append(destinationName);
        sb.append("/");
        sb.append(groupId);
        return sb.toString();
    }

    public static Map<String, String[]> getStagingParameters() {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("CATEGORIES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_USER_PREFERENCES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        parameterMap.put("USER_PERMISSIONS", new String[]{Boolean.FALSE.toString()});
        return parameterMap;
    }

    public static Map<String, String[]> getStagingParameters(ActionRequest actionRequest) {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>(actionRequest.getParameterMap());
        if (!parameterMap.containsKey("DATA_STRATEGY")) {
            parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        }
        if (!parameterMap.containsKey("DELETE_MISSING_LAYOUTS")) {
            parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.TRUE.toString()});
        }
        if (!parameterMap.containsKey("DELETE_PORTLET_DATA")) {
            parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_DATA")) {
            parameterMap.put("PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_DATA_ALL")) {
            Boolean portletDataAll = Boolean.FALSE;
            if (MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA")) {
                portletDataAll = Boolean.TRUE;
            }
            parameterMap.put("PORTLET_DATA_ALL", new String[]{portletDataAll.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_SETUP")) {
            parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        }
        if (!parameterMap.containsKey("PORTLET_USER_PREFERENCES")) {
            parameterMap.put("PORTLET_USER_PREFERENCES", new String[]{Boolean.TRUE.toString()});
        }
        if (!parameterMap.containsKey("THEME")) {
            parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        }
        if (!parameterMap.containsKey("USER_ID_STRATEGY")) {
            parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        }
        return parameterMap;
    }

    public static void publishLayout(long plid, long liveGroupId, boolean includeChildren) throws Exception {
        Map<String, String[]> parameterMap = StagingUtil.getStagingParameters();
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        layouts.add(layout);
        layouts.addAll(StagingUtil.getMissingParents(layout, liveGroupId));
        if (includeChildren) {
            layouts.addAll(layout.getAllChildren());
        }
        Iterator itr = layouts.iterator();
        long[] layoutIds = new long[layouts.size()];
        int i = 0;
        while (itr.hasNext()) {
            Layout curLayout = (Layout)itr.next();
            layoutIds[i] = curLayout.getLayoutId();
            ++i;
        }
        StagingUtil.publishLayouts(layout.getGroupId(), liveGroupId, layout.isPrivateLayout(), layoutIds, parameterMap, null, null);
    }

    public static void publishLayouts(long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        File file = LayoutLocalServiceUtil.exportLayoutsAsFile((long)sourceGroupId, (boolean)privateLayout, (long[])layoutIds, parameterMap, (Date)startDate, (Date)endDate);
        LayoutServiceUtil.importLayouts((long)targetGroupId, (boolean)privateLayout, parameterMap, (File)file);
    }

    public static void publishLayouts(long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (Map.Entry<Long, Boolean> entry : layoutIdMap.entrySet()) {
            long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
            boolean includeChildren = entry.getValue();
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            if (!layouts.contains(layout)) {
                layouts.add(layout);
            }
            for (Layout parentLayout : StagingUtil.getMissingParents(layout, targetGroupId)) {
                if (layouts.contains(parentLayout)) continue;
                layouts.add(parentLayout);
            }
            if (!includeChildren) continue;
            for (Layout childLayout : layout.getAllChildren()) {
                if (layouts.contains(childLayout)) continue;
                layouts.add(childLayout);
            }
        }
        long[] layoutIds = new long[layouts.size()];
        for (int i = 0; i < layouts.size(); ++i) {
            Layout curLayout = (Layout)layouts.get(i);
            layoutIds[i] = curLayout.getLayoutId();
        }
        StagingUtil.publishLayouts(sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    public static void publishLayouts(long sourceGroupId, long targetGroupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        StagingUtil.publishLayouts(sourceGroupId, targetGroupId, privateLayout, (long[])null, parameterMap, startDate, endDate);
    }

    public static void publishToLive(ActionRequest actionRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = StagingUtil.getStagingParameters(actionRequest);
        StagingUtil._publishLayouts(actionRequest, stagingGroupId, liveGroupId, parameterMap, false);
    }

    public static void publishToLive(ActionRequest actionRequest, Portlet portlet) throws Exception {
        long plid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"plid");
        Layout sourceLayout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group stagingGroup = sourceLayout.getGroup();
        Group liveGroup = stagingGroup.getLiveGroup();
        Layout targetLayout = LayoutLocalServiceUtil.getLayout((long)liveGroup.getGroupId(), (boolean)sourceLayout.isPrivateLayout(), (long)sourceLayout.getLayoutId());
        StagingUtil.copyPortlet(actionRequest, stagingGroup.getGroupId(), liveGroup.getGroupId(), sourceLayout.getPlid(), targetLayout.getPlid(), portlet.getPortletId());
    }

    public static void publishToRemote(ActionRequest actionRequest) throws Exception {
        StagingUtil._publishToRemote(actionRequest, false);
    }

    public static void scheduleCopyFromLive(ActionRequest actionRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = StagingUtil.getStagingParameters(actionRequest);
        StagingUtil._publishLayouts(actionRequest, liveGroupId, stagingGroupId, parameterMap, true);
    }

    public static void schedulePublishToLive(ActionRequest actionRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        Map<String, String[]> parameterMap = StagingUtil.getStagingParameters(actionRequest);
        StagingUtil._publishLayouts(actionRequest, stagingGroupId, liveGroupId, parameterMap, true);
    }

    public static void schedulePublishToRemote(ActionRequest actionRequest) throws Exception {
        StagingUtil._publishToRemote(actionRequest, true);
    }

    public static void unscheduleCopyFromLive(ActionRequest actionRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        String jobName = ParamUtil.getString((PortletRequest)actionRequest, (String)"jobName");
        String groupName = StagingUtil.getSchedulerGroupName("liferay/layouts_local_publisher", stagingGroupId);
        LayoutServiceUtil.unschedulePublishToLive((long)stagingGroupId, (String)jobName, (String)groupName);
    }

    public static void unschedulePublishToLive(ActionRequest actionRequest) throws Exception {
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        Group stagingGroup = GroupLocalServiceUtil.getGroup((long)stagingGroupId);
        long liveGroupId = stagingGroup.getLiveGroupId();
        String jobName = ParamUtil.getString((PortletRequest)actionRequest, (String)"jobName");
        String groupName = StagingUtil.getSchedulerGroupName("liferay/layouts_local_publisher", liveGroupId);
        LayoutServiceUtil.unschedulePublishToLive((long)liveGroupId, (String)jobName, (String)groupName);
    }

    public static void unschedulePublishToRemote(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String jobName = ParamUtil.getString((PortletRequest)actionRequest, (String)"jobName");
        String groupName = StagingUtil.getSchedulerGroupName("liferay/layouts_remote_publisher", groupId);
        LayoutServiceUtil.unschedulePublishToRemote((long)groupId, (String)jobName, (String)groupName);
    }

    public static void updateStaging(ActionRequest actionRequest) throws Exception {
        long liveGroupId;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)(liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId")), (String)"MANAGE_STAGING")) {
            throw new PrincipalException();
        }
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        boolean stagingEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"stagingEnabled");
        if (stagingGroupId > 0L && !stagingEnabled) {
            GroupServiceUtil.deleteGroup((long)stagingGroupId);
            GroupServiceUtil.updateWorkflow((long)liveGroupId, (boolean)false, (int)0, null);
        } else if (stagingGroupId == 0L && stagingEnabled) {
            Map<String, String[]> parameterMap;
            Group liveGroup = GroupServiceUtil.getGroup((long)liveGroupId);
            Group stagingGroup = GroupServiceUtil.addGroup((long)liveGroup.getGroupId(), (String)(liveGroup.getDescriptiveName() + " (Staging)"), (String)liveGroup.getDescription(), (int)3, null, (boolean)liveGroup.isActive(), null);
            if (liveGroup.hasPrivateLayouts()) {
                parameterMap = StagingUtil.getStagingParameters();
                StagingUtil.publishLayouts(liveGroup.getGroupId(), stagingGroup.getGroupId(), true, parameterMap, null, null);
            }
            if (liveGroup.hasPublicLayouts()) {
                parameterMap = StagingUtil.getStagingParameters();
                StagingUtil.publishLayouts(liveGroup.getGroupId(), stagingGroup.getGroupId(), false, parameterMap, null, null);
            }
        }
    }

    private static void _addWeeklyDayPos(ActionRequest actionRequest, List<DayAndPosition> list, int day) {
        if (ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("weeklyDayPos" + day))) {
            list.add(new DayAndPosition(day, 0));
        }
    }

    private static String _getCronText(ActionRequest actionRequest, Calendar startDate, boolean timeZoneSensitive, int recurrenceType) throws Exception {
        Calendar startCal = null;
        if (timeZoneSensitive) {
            startCal = CalendarFactoryUtil.getCalendar();
            startCal.setTime(startDate.getTime());
        } else {
            startCal = (Calendar)startDate.clone();
        }
        Recurrence recurrence = new Recurrence(startCal, new Duration(1, 0, 0, 0), recurrenceType);
        recurrence.setWeekStart(1);
        if (recurrenceType == 3) {
            int dailyType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dailyType");
            if (dailyType == 0) {
                int dailyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"dailyInterval", (int)1);
                recurrence.setInterval(dailyInterval);
            } else {
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(2, 0), new DayAndPosition(3, 0), new DayAndPosition(4, 0), new DayAndPosition(5, 0), new DayAndPosition(6, 0)};
                recurrence.setByDay(dayPos);
            }
        } else if (recurrenceType == 4) {
            int weeklyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"weeklyInterval", (int)1);
            recurrence.setInterval(weeklyInterval);
            ArrayList<DayAndPosition> dayPos = new ArrayList<DayAndPosition>();
            StagingUtil._addWeeklyDayPos(actionRequest, dayPos, 1);
            StagingUtil._addWeeklyDayPos(actionRequest, dayPos, 2);
            StagingUtil._addWeeklyDayPos(actionRequest, dayPos, 3);
            StagingUtil._addWeeklyDayPos(actionRequest, dayPos, 4);
            StagingUtil._addWeeklyDayPos(actionRequest, dayPos, 5);
            StagingUtil._addWeeklyDayPos(actionRequest, dayPos, 6);
            StagingUtil._addWeeklyDayPos(actionRequest, dayPos, 7);
            if (dayPos.size() == 0) {
                dayPos.add(new DayAndPosition(2, 0));
            }
            recurrence.setByDay(dayPos.toArray(new DayAndPosition[0]));
        } else if (recurrenceType == 5) {
            int monthlyType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyType");
            if (monthlyType == 0) {
                int monthlyDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyDay0", (int)1);
                recurrence.setByMonthDay(new int[]{monthlyDay});
                int monthlyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyInterval0", (int)1);
                recurrence.setInterval(monthlyInterval);
            } else {
                int monthlyPos = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyPos");
                int monthlyDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyDay1");
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(monthlyDay, monthlyPos)};
                recurrence.setByDay(dayPos);
                int monthlyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"monthlyInterval1", (int)1);
                recurrence.setInterval(monthlyInterval);
            }
        } else if (recurrenceType == 6) {
            int yearlyType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyType");
            if (yearlyType == 0) {
                int yearlyMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyMonth0");
                int yearlyDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyDay0", (int)1);
                recurrence.setByMonth(new int[]{yearlyMonth});
                recurrence.setByMonthDay(new int[]{yearlyDay});
                int yearlyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyInterval0", (int)1);
                recurrence.setInterval(yearlyInterval);
            } else {
                int yearlyPos = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyPos");
                int yearlyDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyDay1");
                int yearlyMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyMonth1");
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(yearlyDay, yearlyPos)};
                recurrence.setByDay(dayPos);
                recurrence.setByMonth(new int[]{yearlyMonth});
                int yearlyInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"yearlyInterval1", (int)1);
                recurrence.setInterval(yearlyInterval);
            }
        }
        return RecurrenceSerializer.toCronText((Recurrence)recurrence);
    }

    private static Calendar _getDate(ActionRequest actionRequest, String paramPrefix, boolean timeZoneSensitive) throws Exception {
        int dateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)(paramPrefix + "Month"));
        int dateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)(paramPrefix + "Day"));
        int dateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)(paramPrefix + "Year"));
        int dateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)(paramPrefix + "Hour"));
        int dateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)(paramPrefix + "Minute"));
        int dateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)(paramPrefix + "AmPm"));
        if (dateAmPm == 1) {
            dateHour += 12;
        }
        Locale locale = null;
        TimeZone timeZone = null;
        if (timeZoneSensitive) {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
            locale = themeDisplay.getLocale();
            timeZone = themeDisplay.getTimeZone();
        } else {
            locale = LocaleUtil.getDefault();
            timeZone = TimeZoneUtil.getDefault();
        }
        Calendar cal = CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale);
        cal.set(2, dateMonth);
        cal.set(5, dateDay);
        cal.set(1, dateYear);
        cal.set(11, dateHour);
        cal.set(12, dateMinute);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    private static void _publishLayouts(ActionRequest actionRequest, long sourceGroupId, long targetGroupId, Map<String, String[]> parameterMap, boolean schedule) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String tabs1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs1");
        boolean privateLayout = true;
        if (tabs1.equals("public-pages")) {
            privateLayout = false;
        }
        String scope = ParamUtil.getString((PortletRequest)actionRequest, (String)"scope");
        LinkedHashMap<Long, Boolean> layoutIdMap = new LinkedHashMap<Long, Boolean>();
        if (scope.equals("selected-pages")) {
            long[] rowIds;
            for (long selPlid : rowIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds")) {
                boolean includeChildren = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("includeChildren_" + selPlid));
                layoutIdMap.put(selPlid, includeChildren);
            }
        }
        String range = ParamUtil.getString((PortletRequest)actionRequest, (String)"range");
        Date startDate = null;
        Date endDate = null;
        if (range.equals("dateRange")) {
            startDate = StagingUtil._getDate(actionRequest, "startDate", true).getTime();
            endDate = StagingUtil._getDate(actionRequest, "endDate", true).getTime();
        } else if (range.equals("last")) {
            int rangeLast = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"last");
            Date now = new Date();
            startDate = new Date(now.getTime() - (long)rangeLast * 3600000L);
            endDate = now;
        }
        if (schedule) {
            String groupName = StagingUtil.getSchedulerGroupName("liferay/layouts_local_publisher", targetGroupId);
            int recurrenceType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"recurrenceType");
            Calendar startCal = StagingUtil._getDate(actionRequest, "schedulerStartDate", true);
            String cronText = StagingUtil._getCronText(actionRequest, startCal, true, recurrenceType);
            Date schedulerEndDate = null;
            int endDateType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateType");
            if (endDateType == 1) {
                Calendar endCal = StagingUtil._getDate(actionRequest, "schedulerEndDate", true);
                schedulerEndDate = endCal.getTime();
            }
            String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
            LayoutServiceUtil.schedulePublishToLive((long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, layoutIdMap, parameterMap, (String)scope, (Date)startDate, (Date)endDate, (String)groupName, (String)cronText, (Date)startCal.getTime(), (Date)schedulerEndDate, (String)description);
        } else {
            MessageStatus messageStatus = new MessageStatus();
            messageStatus.startTimer();
            String command = "SELECTED_PAGES";
            try {
                if (scope.equals("all-pages")) {
                    command = "ALL_PAGES";
                    StagingUtil.publishLayouts(sourceGroupId, targetGroupId, privateLayout, parameterMap, startDate, endDate);
                } else {
                    StagingUtil.publishLayouts(sourceGroupId, targetGroupId, privateLayout, layoutIdMap, parameterMap, startDate, endDate);
                }
            }
            catch (Exception e) {
                messageStatus.setException(e);
                throw e;
            }
            finally {
                messageStatus.stopTimer();
                LayoutsLocalPublisherRequest publisherRequest = new LayoutsLocalPublisherRequest(command, themeDisplay.getUserId(), sourceGroupId, targetGroupId, privateLayout, layoutIdMap, parameterMap, startDate, endDate);
                messageStatus.setPayload((Object)publisherRequest);
                MessageBusUtil.sendMessage((String)"liferay/message_bus/message_status", (Object)messageStatus);
            }
        }
    }

    private static void _publishToRemote(ActionRequest actionRequest, boolean schedule) throws Exception {
        String scope;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String tabs1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"tabs1");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = true;
        if (tabs1.equals("public-pages")) {
            privateLayout = false;
        }
        if (Validator.isNull((String)(scope = ParamUtil.getString((PortletRequest)actionRequest, (String)"scope")))) {
            scope = "all-pages";
        }
        LinkedHashMap<Long, Boolean> layoutIdMap = null;
        Map parameterMap = actionRequest.getParameterMap();
        if (scope.equals("selected-pages")) {
            long[] rowIds;
            layoutIdMap = new LinkedHashMap<Long, Boolean>();
            for (long selPlid : rowIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds")) {
                boolean includeChildren = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("includeChildren_" + selPlid));
                layoutIdMap.put(selPlid, includeChildren);
            }
        }
        String remoteAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"remoteAddress");
        int remotePort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"remotePort");
        boolean secureConnection = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"secureConnection");
        long remoteGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"remoteGroupId");
        boolean remotePrivateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"remotePrivateLayout");
        String range = ParamUtil.getString((PortletRequest)actionRequest, (String)"range");
        Date startDate = null;
        Date endDate = null;
        if (range.equals("dateRange")) {
            startDate = StagingUtil._getDate(actionRequest, "startDate", true).getTime();
            endDate = StagingUtil._getDate(actionRequest, "endDate", true).getTime();
        } else if (range.equals("last")) {
            int rangeLast = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"last");
            Date now = new Date();
            startDate = new Date(now.getTime() - (long)rangeLast * 3600000L);
            endDate = now;
        }
        if (schedule) {
            String groupName = StagingUtil.getSchedulerGroupName("liferay/layouts_remote_publisher", groupId);
            int recurrenceType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"recurrenceType");
            Calendar startCal = StagingUtil._getDate(actionRequest, "schedulerStartDate", true);
            String cronText = StagingUtil._getCronText(actionRequest, startCal, true, recurrenceType);
            Date schedulerEndDate = null;
            int endDateType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateType");
            if (endDateType == 1) {
                Calendar endCal = StagingUtil._getDate(actionRequest, "schedulerEndDate", true);
                schedulerEndDate = endCal.getTime();
            }
            String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
            LayoutServiceUtil.schedulePublishToRemote((long)groupId, (boolean)privateLayout, layoutIdMap, StagingUtil.getStagingParameters(actionRequest), (String)remoteAddress, (int)remotePort, (boolean)secureConnection, (long)remoteGroupId, (boolean)remotePrivateLayout, (Date)startDate, (Date)endDate, (String)groupName, (String)cronText, (Date)startCal.getTime(), (Date)schedulerEndDate, (String)description);
        } else {
            MessageStatus messageStatus = new MessageStatus();
            messageStatus.startTimer();
            try {
                StagingUtil.copyRemoteLayouts(groupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, secureConnection, remoteGroupId, remotePrivateLayout, StagingUtil.getStagingParameters(actionRequest), startDate, endDate);
            }
            catch (Exception e) {
                messageStatus.setException(e);
                throw e;
            }
            finally {
                messageStatus.stopTimer();
                LayoutsRemotePublisherRequest publisherRequest = new LayoutsRemotePublisherRequest(themeDisplay.getUserId(), groupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, secureConnection, remoteGroupId, remotePrivateLayout, startDate, endDate);
                messageStatus.setPayload((Object)publisherRequest);
                MessageBusUtil.sendMessage((String)"liferay/message_bus/message_status", (Object)messageStatus);
            }
        }
    }
}

