/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.currencyconverter.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portlet.currencyconverter.model.Currency;
import com.liferay.portlet.currencyconverter.util.CurrencyWebCacheItem;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrencyUtil {
    private static CurrencyUtil _instance = new CurrencyUtil();
    private static Map<String, Map<String, String>> _symbolsPool = new ConcurrentHashMap<String, Map<String, String>>();
    private Set<String> _currencyIds = new HashSet<String>();

    public static Map<String, String> getAllSymbols(PageContext pageContext) {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        Locale locale = request.getLocale();
        String key = locale.toString();
        Map<String, String> symbols = _symbolsPool.get(key);
        if (symbols != null) {
            return symbols;
        }
        symbols = new TreeMap<String, String>();
        for (String symbol : CurrencyUtil._instance._currencyIds) {
            symbols.put(LanguageUtil.get((PageContext)pageContext, (String)symbol), symbol);
        }
        _symbolsPool.put(key, symbols);
        return symbols;
    }

    public static Currency getCurrency(String symbol) {
        CurrencyWebCacheItem wci = new CurrencyWebCacheItem(symbol);
        return (Currency)WebCachePoolUtil.get((String)(CurrencyUtil.class.getName() + "." + symbol), (WebCacheItem)wci);
    }

    public static boolean isCurrency(String symbol) {
        return CurrencyUtil._instance._currencyIds.contains(symbol);
    }

    private CurrencyUtil() {
        this._currencyIds.add("ALL");
        this._currencyIds.add("DZD");
        this._currencyIds.add("XAL");
        this._currencyIds.add("ARS");
        this._currencyIds.add("AWG");
        this._currencyIds.add("AUD");
        this._currencyIds.add("BSD");
        this._currencyIds.add("BHD");
        this._currencyIds.add("BDT");
        this._currencyIds.add("BBD");
        this._currencyIds.add("BYR");
        this._currencyIds.add("BZD");
        this._currencyIds.add("BMD");
        this._currencyIds.add("BTN");
        this._currencyIds.add("BOB");
        this._currencyIds.add("BRL");
        this._currencyIds.add("GBP");
        this._currencyIds.add("BND");
        this._currencyIds.add("BGN");
        this._currencyIds.add("BIF");
        this._currencyIds.add("KHR");
        this._currencyIds.add("CAD");
        this._currencyIds.add("KYD");
        this._currencyIds.add("XOF");
        this._currencyIds.add("XAF");
        this._currencyIds.add("CLP");
        this._currencyIds.add("CNY");
        this._currencyIds.add("COP");
        this._currencyIds.add("KMF");
        this._currencyIds.add("XCP");
        this._currencyIds.add("CRC");
        this._currencyIds.add("HRK");
        this._currencyIds.add("CUP");
        this._currencyIds.add("CYP");
        this._currencyIds.add("CZK");
        this._currencyIds.add("DKK");
        this._currencyIds.add("DJF");
        this._currencyIds.add("DOP");
        this._currencyIds.add("XCD");
        this._currencyIds.add("ECS");
        this._currencyIds.add("EGP");
        this._currencyIds.add("SVC");
        this._currencyIds.add("ERN");
        this._currencyIds.add("EEK");
        this._currencyIds.add("ETB");
        this._currencyIds.add("EUR");
        this._currencyIds.add("FKP");
        this._currencyIds.add("GMD");
        this._currencyIds.add("GHC");
        this._currencyIds.add("GIP");
        this._currencyIds.add("XAU");
        this._currencyIds.add("GTQ");
        this._currencyIds.add("GNF");
        this._currencyIds.add("HTG");
        this._currencyIds.add("HNL");
        this._currencyIds.add("HKD");
        this._currencyIds.add("HUF");
        this._currencyIds.add("ISK");
        this._currencyIds.add("INR");
        this._currencyIds.add("IDR");
        this._currencyIds.add("IRR");
        this._currencyIds.add("ILS");
        this._currencyIds.add("JMD");
        this._currencyIds.add("JPY");
        this._currencyIds.add("JOD");
        this._currencyIds.add("KZT");
        this._currencyIds.add("KES");
        this._currencyIds.add("KRW");
        this._currencyIds.add("KWD");
        this._currencyIds.add("LAK");
        this._currencyIds.add("LVL");
        this._currencyIds.add("LBP");
        this._currencyIds.add("LSL");
        this._currencyIds.add("LYD");
        this._currencyIds.add("LTL");
        this._currencyIds.add("MOP");
        this._currencyIds.add("MKD");
        this._currencyIds.add("MGF");
        this._currencyIds.add("MWK");
        this._currencyIds.add("MYR");
        this._currencyIds.add("MVR");
        this._currencyIds.add("MTL");
        this._currencyIds.add("MRO");
        this._currencyIds.add("MUR");
        this._currencyIds.add("MXN");
        this._currencyIds.add("MDL");
        this._currencyIds.add("MNT");
        this._currencyIds.add("MAD");
        this._currencyIds.add("MZM");
        this._currencyIds.add("NAD");
        this._currencyIds.add("NPR");
        this._currencyIds.add("ANG");
        this._currencyIds.add("TRY");
        this._currencyIds.add("NZD");
        this._currencyIds.add("NIO");
        this._currencyIds.add("NGN");
        this._currencyIds.add("NOK");
        this._currencyIds.add("OMR");
        this._currencyIds.add("XPF");
        this._currencyIds.add("PKR");
        this._currencyIds.add("XPD");
        this._currencyIds.add("PAB");
        this._currencyIds.add("PGK");
        this._currencyIds.add("PYG");
        this._currencyIds.add("PEN");
        this._currencyIds.add("PHP");
        this._currencyIds.add("XPT");
        this._currencyIds.add("PLN");
        this._currencyIds.add("QAR");
        this._currencyIds.add("ROL");
        this._currencyIds.add("RON");
        this._currencyIds.add("RUB");
        this._currencyIds.add("RWF");
        this._currencyIds.add("WST");
        this._currencyIds.add("STD");
        this._currencyIds.add("SAR");
        this._currencyIds.add("SCR");
        this._currencyIds.add("SLL");
        this._currencyIds.add("XAG");
        this._currencyIds.add("SGD");
        this._currencyIds.add("SKK");
        this._currencyIds.add("SIT");
        this._currencyIds.add("SOS");
        this._currencyIds.add("ZAR");
        this._currencyIds.add("LKR");
        this._currencyIds.add("SHP");
        this._currencyIds.add("SDD");
        this._currencyIds.add("SRG");
        this._currencyIds.add("SZL");
        this._currencyIds.add("SEK");
        this._currencyIds.add("CHF");
        this._currencyIds.add("SYP");
        this._currencyIds.add("TWD");
        this._currencyIds.add("TZS");
        this._currencyIds.add("THB");
        this._currencyIds.add("TOP");
        this._currencyIds.add("TTD");
        this._currencyIds.add("TND");
        this._currencyIds.add("USD");
        this._currencyIds.add("AED");
        this._currencyIds.add("UGX");
        this._currencyIds.add("UAH");
        this._currencyIds.add("UYU");
        this._currencyIds.add("VUV");
        this._currencyIds.add("VEB");
        this._currencyIds.add("VND");
        this._currencyIds.add("YER");
        this._currencyIds.add("ZMK");
        this._currencyIds.add("ZWD");
    }
}

