/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.directory.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.User;
import com.liferay.portal.search.BaseOpenSearchImpl;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.comparator.UserLastNameComparator;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class DirectoryOpenSearchImpl
extends BaseOpenSearchImpl {
    public static final String SEARCH_PATH = "/c/directory/open_search";
    private static Log _log = LogFactoryUtil.getLog(DirectoryOpenSearchImpl.class);

    public String search(HttpServletRequest request, long groupId, long userId, String keywords, int startPage, int itemsPerPage, String format) throws SearchException {
        try {
            return this._search(request, keywords, startPage, itemsPerPage, format);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    private String _search(HttpServletRequest request, String keywords, int startPage, int itemsPerPage, String format) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        int start = startPage * itemsPerPage - itemsPerPage;
        int end = startPage * itemsPerPage;
        List results = UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)keywords, (Boolean)Boolean.TRUE, null, (int)start, (int)end, (OrderByComparator)new UserLastNameComparator(true));
        String[] queryTerms = StringUtil.split((String)keywords, (String)" ");
        int total = UserLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (String)keywords, (Boolean)Boolean.TRUE, null);
        Object[] values = this.addSearchResults(queryTerms, keywords, startPage, itemsPerPage, total, start, "Liferay Directory Search: " + keywords, SEARCH_PATH, format, themeDisplay);
        Document doc = (Document)values[0];
        Element root = (Element)values[1];
        for (User user : results) {
            String portletId = "11";
            PortletURL portletURL = this.getPortletURL(request, portletId, themeDisplay.getScopeGroupId());
            portletURL.setParameter("struts_action", "/directory/view_user");
            portletURL.setParameter("p_u_i_d", String.valueOf(user.getUserId()));
            String title = user.getFullName();
            String url = portletURL.toString();
            Date modifedDate = user.getModifiedDate();
            String content = user.getFullName() + " &lt;" + user.getEmailAddress() + "&gt;";
            double score = 1.0;
            this.addSearchResult(root, title, url, modifedDate, content, score, format);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Return\n" + doc.asXML()));
        }
        return doc.asXML();
    }
}

