/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.DiffUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CompareVersionsAction
extends PortletAction {
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            this.compareVersions(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)renderRequest, "portlet.document_library.error");
            }
            throw e;
        }
        return mapping.findForward("portlet.document_library.compare_versions");
    }

    protected void compareVersions(RenderRequest renderRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        long companyId = themeDisplay.getCompanyId();
        long userId = themeDisplay.getUserId();
        long fileEntryId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"fileEntryId");
        long folderId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"folderId");
        String name = ParamUtil.getString((PortletRequest)renderRequest, (String)"name");
        DLFileEntryPermission.check(themeDisplay.getPermissionChecker(), folderId, name, "VIEW");
        String extension = FileUtil.getExtension((String)name);
        String titleWithExtension = ParamUtil.getString((PortletRequest)renderRequest, (String)"titleWithExtension");
        double sourceVersion = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"sourceVersion");
        double targetVersion = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"targetVersion");
        InputStream sourceIs = DLFileEntryLocalServiceUtil.getFileAsStream((long)companyId, (long)userId, (long)folderId, (String)name, (double)sourceVersion);
        InputStream targetIs = DLFileEntryLocalServiceUtil.getFileAsStream((long)companyId, (long)userId, (long)folderId, (String)name, (double)targetVersion);
        if (extension.equals("htm") || extension.equals("html") || extension.equals("xml")) {
            String escapedSource = HtmlUtil.escape((String)StringUtil.read((InputStream)sourceIs));
            String escapedTarget = HtmlUtil.escape((String)StringUtil.read((InputStream)targetIs));
            sourceIs = new UnsyncByteArrayInputStream(escapedSource.getBytes("UTF-8"));
            targetIs = new UnsyncByteArrayInputStream(escapedTarget.getBytes("UTF-8"));
        }
        if (PrefsPropsUtil.getBoolean("openoffice.server.enabled", PropsValues.OPENOFFICE_SERVER_ENABLED) && this.isConvertBeforeCompare(extension)) {
            String sourceTempFileId = DocumentConversionUtil.getTempFileId(fileEntryId, sourceVersion);
            String targetTempFileId = DocumentConversionUtil.getTempFileId(fileEntryId, targetVersion);
            sourceIs = DocumentConversionUtil.convert(sourceTempFileId, sourceIs, extension, "txt");
            targetIs = DocumentConversionUtil.convert(targetTempFileId, targetIs, extension, "txt");
        }
        List[] diffResults = DiffUtil.diff((Reader)new InputStreamReader(sourceIs), (Reader)new InputStreamReader(targetIs));
        renderRequest.setAttribute("SOURCE_NAME", (Object)(titleWithExtension + " " + sourceVersion));
        renderRequest.setAttribute("TARGET_NAME", (Object)(titleWithExtension + " " + targetVersion));
        renderRequest.setAttribute("DIFF_RESULTS", (Object)diffResults);
    }

    protected boolean isConvertBeforeCompare(String extension) {
        if (extension.equals("txt")) {
            return false;
        }
        String[] conversions = DocumentConversionUtil.getConversions(extension);
        for (int i = 0; i < conversions.length; ++i) {
            if (!conversions[i].equals("txt")) continue;
            return true;
        }
        return false;
    }
}

