/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.FileShortcutPermissionException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileShortcutException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLFileShortcutServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFileShortcutAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFileShortcut(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFileShortcut(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileShortcutException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e instanceof FileShortcutPermissionException || e instanceof NoSuchFileEntryException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFileShortcut(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileShortcutException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.document_library.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.document_library.edit_file_shortcut"));
    }

    protected void deleteFileShortcut(ActionRequest actionRequest) throws Exception {
        long fileShortcutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileShortcutId");
        DLFileShortcutServiceUtil.deleteFileShortcut((long)fileShortcutId);
    }

    protected void updateFileShortcut(ActionRequest actionRequest) throws Exception {
        long fileShortcutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileShortcutId");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long toFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"toFolderId");
        String toName = HtmlUtil.unescape((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"toName"));
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileShortcut.class.getName(), (PortletRequest)actionRequest);
        if (fileShortcutId <= 0L) {
            DLFileShortcut fileShortcut = DLFileShortcutServiceUtil.addFileShortcut((long)folderId, (long)toFolderId, (String)toName, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection(actionRequest, DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), -1);
        } else {
            DLFileShortcutServiceUtil.updateFileShortcut((long)fileShortcutId, (long)folderId, (long)toFolderId, (String)toName, (ServiceContext)serviceContext);
            AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, DLFileShortcut.class.getName(), folderId);
        }
    }
}

