/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileShortcutServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class GetFileAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    public ActionForward strutsExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            long folderId = ParamUtil.getLong((HttpServletRequest)request, (String)"folderId");
            String name = ParamUtil.getString((HttpServletRequest)request, (String)"name");
            double version = ParamUtil.getDouble((HttpServletRequest)request, (String)"version");
            long fileShortcutId = ParamUtil.getLong((HttpServletRequest)request, (String)"fileShortcutId");
            String uuid = ParamUtil.getString((HttpServletRequest)request, (String)"uuid");
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            String targetExtension = ParamUtil.getString((HttpServletRequest)request, (String)"targetExtension");
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            this.getFile(folderId, name, version, fileShortcutId, uuid, groupId, targetExtension, themeDisplay, request, response);
            return null;
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
            String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
            double version = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"version");
            long fileShortcutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileShortcutId");
            String uuid = ParamUtil.getString((PortletRequest)actionRequest, (String)"uuid");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            String targetExtension = ParamUtil.getString((PortletRequest)actionRequest, (String)"targetExtension");
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            this.getFile(folderId, name, version, fileShortcutId, uuid, groupId, targetExtension, themeDisplay, request, response);
            this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
        }
        catch (NoSuchFileEntryException nsfee) {
            PortalUtil.sendError((int)404, (Exception)((Object)nsfee), (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    protected void getFile(long folderId, String name, double version, long fileShortcutId, String uuid, long groupId, String targetExtension, ThemeDisplay themeDisplay, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String sourceExtension;
        String id;
        InputStream convertedIS;
        long companyId = themeDisplay.getCompanyId();
        long userId = themeDisplay.getUserId();
        DLFileEntry fileEntry = null;
        if (Validator.isNotNull((String)uuid) && groupId > 0L) {
            try {
                fileEntry = DLFileEntryLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                folderId = fileEntry.getFolderId();
                name = fileEntry.getName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (fileShortcutId <= 0L) {
            DLFileEntryPermission.check(themeDisplay.getPermissionChecker(), folderId, name, "VIEW");
        } else {
            DLFileShortcut fileShortcut = DLFileShortcutServiceUtil.getFileShortcut((long)fileShortcutId);
            folderId = fileShortcut.getToFolderId();
            name = fileShortcut.getToName();
        }
        if (fileEntry == null) {
            fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)folderId, (String)name);
        }
        if (version == 0.0) {
            if (fileEntry.getVersion() > 0.0) {
                version = fileEntry.getVersion();
            } else {
                throw new NoSuchFileEntryException();
            }
        }
        InputStream is = DLFileEntryLocalServiceUtil.getFileAsStream((long)companyId, (long)userId, (long)folderId, (String)name, (double)version);
        boolean converted = false;
        String fileName = fileEntry.getTitleWithExtension();
        if (Validator.isNotNull((String)targetExtension) && (convertedIS = DocumentConversionUtil.convert(id = DocumentConversionUtil.getTempFileId(fileEntry.getFileEntryId(), version), is, sourceExtension = FileUtil.getExtension((String)name), targetExtension)) != null && convertedIS != is) {
            StringBuilder sb = new StringBuilder();
            sb.append(fileEntry.getTitle());
            sb.append(".");
            sb.append(targetExtension);
            fileName = sb.toString();
            is = convertedIS;
            converted = true;
        }
        int contentLength = 0;
        if (!converted) {
            if (version >= fileEntry.getVersion()) {
                contentLength = fileEntry.getSize();
            } else {
                DLFileVersion fileVersion = DLFileVersionLocalServiceUtil.getFileVersion((long)folderId, (String)name, (double)version);
                contentLength = fileVersion.getSize();
            }
        }
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        ServletResponseUtil.sendFile((HttpServletResponse)response, (String)fileName, (InputStream)is, (int)contentLength, (String)contentType);
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }
}

