/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portlet.documentlibrary.lar.DLPortletDataHandlerImpl;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DLDisplayPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "document_library";
    private static final PortletDataHandlerBoolean _foldersAndDocuments = new PortletDataHandlerBoolean("document_library", "folders-and-documents", true, true);
    private static final PortletDataHandlerBoolean _ranks = new PortletDataHandlerBoolean("document_library", "ranks");
    private static final PortletDataHandlerBoolean _shortcuts = new PortletDataHandlerBoolean("document_library", "shortcuts");
    private static final PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("document_library", "comments");
    private static final PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("document_library", "ratings");
    private static final PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("document_library", "tags");

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            preferences.setValue("rootFolderId", "");
            preferences.setValue("showBreadcrumbs", "");
            preferences.setValue("showFoldersSearch", "");
            preferences.setValue("showSubfolders", "");
            preferences.setValue("foldersPerPage", "");
            preferences.setValue("folderColumns", "");
            preferences.setValue("showFileEntriesSearch", "");
            preferences.setValue("fileEntriesPerPage", "");
            preferences.setValue("fileEntryColumns", "");
            preferences.setValue("enable-comment-ratings", "");
            return preferences;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            long rootFolderId = GetterUtil.getLong((String)preferences.getValue("rootFolderId", null));
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("documentlibrary-display-data");
            Element foldersEl = root.addElement("folders");
            Element fileEntriesEl = root.addElement("file-entries");
            Element fileShortcutsEl = root.addElement("file-shortcuts");
            Element fileRanksEl = root.addElement("file-ranks");
            if (rootFolderId == 0L) {
                List folders = DLFolderUtil.findByGroupId((long)context.getGroupId());
                for (DLFolder folder : folders) {
                    DLPortletDataHandlerImpl.exportFolder(context, foldersEl, fileEntriesEl, fileShortcutsEl, fileRanksEl, folder);
                }
            } else {
                DLFolder folder = DLFolderUtil.findByPrimaryKey((long)rootFolderId);
                root.addAttribute("root-folder-id", String.valueOf(folder.getFolderId()));
                DLPortletDataHandlerImpl.exportFolder(context, foldersEl, fileEntriesEl, fileShortcutsEl, fileRanksEl, folder);
            }
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _ranks, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _ranks, _comments, _ratings, _tags};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            long rootFolderId;
            String path;
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List folderEls = root.element("folders").elements("folder");
            Map folderPKs = context.getNewPrimaryKeysMap(DLFolder.class);
            for (Element folderEl : folderEls) {
                String path2 = folderEl.attributeValue("path");
                if (!context.isPathNotProcessed(path2)) continue;
                DLFolder folder = (DLFolder)context.getZipEntryAsObject(path2);
                DLPortletDataHandlerImpl.importFolder(context, folderPKs, folder);
            }
            List fileEntryEls = root.element("file-entries").elements("file-entry");
            Map fileEntryNames = context.getNewPrimaryKeysMap(DLFileEntry.class);
            for (Element fileEntryEl : fileEntryEls) {
                String path3 = fileEntryEl.attributeValue("path");
                if (!context.isPathNotProcessed(path3)) continue;
                DLFileEntry fileEntry = (DLFileEntry)context.getZipEntryAsObject(path3);
                String binPath = fileEntryEl.attributeValue("bin-path");
                DLPortletDataHandlerImpl.importFileEntry(context, folderPKs, fileEntryNames, fileEntry, binPath);
            }
            if (context.getBooleanParameter(_NAMESPACE, "shortcuts")) {
                List fileShortcutEls = root.element("file-shortcuts").elements("file-shortcut");
                for (Element fileShortcutEl : fileShortcutEls) {
                    path = fileShortcutEl.attributeValue("path");
                    if (!context.isPathNotProcessed(path)) continue;
                    DLFileShortcut fileShortcut = (DLFileShortcut)context.getZipEntryAsObject(path);
                    DLPortletDataHandlerImpl.importFileShortcut(context, folderPKs, fileEntryNames, fileShortcut);
                }
            }
            if (context.getBooleanParameter(_NAMESPACE, "ranks")) {
                List fileRankEls = root.element("file-ranks").elements("file-rank");
                for (Element fileRankEl : fileRankEls) {
                    path = fileRankEl.attributeValue("path");
                    if (!context.isPathNotProcessed(path)) continue;
                    DLFileRank fileRank = (DLFileRank)context.getZipEntryAsObject(path);
                    DLPortletDataHandlerImpl.importFileRank(context, folderPKs, fileEntryNames, fileRank);
                }
            }
            if (Validator.isNotNull((Long)(rootFolderId = GetterUtil.getLong((String)root.attributeValue("root-folder-id"))))) {
                rootFolderId = MapUtil.getLong((Map)folderPKs, (long)rootFolderId, (long)rootFolderId);
                preferences.setValue("rootFolderId", String.valueOf(rootFolderId));
            }
            return preferences;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }
}

