/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.documentlibrary.service.DLLocalServiceUtil;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileShortcutException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileRankLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileShortcutLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileRankUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileShortcutUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "document_library";
    private static final PortletDataHandlerBoolean _foldersAndDocuments = new PortletDataHandlerBoolean("document_library", "folders-and-documents", true, true);
    private static final PortletDataHandlerBoolean _ranks = new PortletDataHandlerBoolean("document_library", "ranks");
    private static final PortletDataHandlerBoolean _shortcuts = new PortletDataHandlerBoolean("document_library", "shortcuts");
    private static final PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("document_library", "categories");
    private static final PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("document_library", "comments");
    private static final PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("document_library", "ratings");
    private static final PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("document_library", "tags");
    private static Log _log = LogFactoryUtil.getLog(DLPortletDataHandlerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFileEntry(PortletDataContext context, Element foldersEl, Element fileEntriesEl, Element fileRanksEl, DLFileEntry fileEntry) throws PortalException, SystemException {
        if (!context.isWithinDateRange(fileEntry.getModifiedDate())) {
            return;
        }
        DLPortletDataHandlerImpl.exportParentFolder(context, foldersEl, fileEntry.getFolderId());
        String path = DLPortletDataHandlerImpl.getFileEntryPath(context, fileEntry);
        if (context.isPathNotProcessed(path)) {
            InputStream is;
            Element fileEntryEl = fileEntriesEl.addElement("file-entry");
            fileEntryEl.addAttribute("path", path);
            String binPath = DLPortletDataHandlerImpl.getFileEntryBinPath(context, fileEntry);
            fileEntryEl.addAttribute("bin-path", binPath);
            fileEntry.setUserUuid(fileEntry.getUserUuid());
            if (context.getBooleanParameter(_NAMESPACE, "categories")) {
                context.addTagsCategories(DLFileEntry.class, fileEntry.getFileEntryId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "comments")) {
                context.addComments(DLFileEntry.class, fileEntry.getFileEntryId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
                context.addRatingsEntries(DLFileEntry.class, fileEntry.getFileEntryId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "tags")) {
                context.addTagsEntries(DLFileEntry.class, fileEntry.getFileEntryId());
            }
            if ((is = DLLocalServiceUtil.getFileAsStream((long)fileEntry.getCompanyId(), (long)fileEntry.getFolderId(), (String)fileEntry.getName(), (double)fileEntry.getVersion())) == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No file found for file entry " + fileEntry.getFileEntryId()));
                }
                fileEntryEl.detach();
                return;
            }
            try {
                context.addZipEntry(DLPortletDataHandlerImpl.getFileEntryBinPath(context, fileEntry), is);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    _log.error((Object)ioe, (Throwable)ioe);
                }
            }
            context.addZipEntry(path, (Object)fileEntry);
            if (context.getBooleanParameter(_NAMESPACE, "ranks")) {
                List fileRanks = DLFileRankUtil.findByF_N((long)fileEntry.getFolderId(), (String)fileEntry.getName());
                for (DLFileRank fileRank : fileRanks) {
                    DLPortletDataHandlerImpl.exportFileRank(context, fileRanksEl, fileRank);
                }
            }
        }
    }

    public static void exportFolder(PortletDataContext context, Element foldersEl, Element fileEntriesEl, Element fileShortcutsEl, Element fileRanksEl, DLFolder folder) throws PortalException, SystemException {
        if (context.isWithinDateRange(folder.getModifiedDate())) {
            DLPortletDataHandlerImpl.exportParentFolder(context, foldersEl, folder.getParentFolderId());
            String path = DLPortletDataHandlerImpl.getFolderPath(context, folder);
            if (context.isPathNotProcessed(path)) {
                Element folderEl = foldersEl.addElement("folder");
                folderEl.addAttribute("path", path);
                folder.setUserUuid(folder.getUserUuid());
                context.addZipEntry(path, (Object)folder);
            }
        }
        List fileEntries = DLFileEntryUtil.findByFolderId((long)folder.getFolderId());
        for (DLFileEntry fileEntry : fileEntries) {
            DLPortletDataHandlerImpl.exportFileEntry(context, foldersEl, fileEntriesEl, fileRanksEl, fileEntry);
        }
        if (context.getBooleanParameter(_NAMESPACE, "shortcuts")) {
            List fileShortcuts = DLFileShortcutUtil.findByFolderId((long)folder.getFolderId());
            for (DLFileShortcut fileShortcut : fileShortcuts) {
                DLPortletDataHandlerImpl.exportFileShortcut(context, foldersEl, fileShortcutsEl, fileShortcut);
            }
        }
    }

    public static void importFileEntry(PortletDataContext context, Map<Long, Long> folderPKs, Map<String, String> fileEntryNames, DLFileEntry fileEntry, String binPath) throws Exception {
        long userId = context.getUserId(fileEntry.getUserUuid());
        long groupId = context.getGroupId();
        long folderId = MapUtil.getLong(folderPKs, (long)fileEntry.getFolderId(), (long)fileEntry.getFolderId());
        String[] tagsCategories = null;
        String[] tagsEntries = null;
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            tagsCategories = context.getTagsCategories(DLFileEntry.class, fileEntry.getFileEntryId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            tagsEntries = context.getTagsEntries(DLFileEntry.class, fileEntry.getFileEntryId());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setTagsCategories(tagsCategories);
        serviceContext.setTagsEntries(tagsEntries);
        InputStream is = context.getZipEntryAsInputStream(binPath);
        if (folderId != 0L && folderId == fileEntry.getFolderId()) {
            String path = DLPortletDataHandlerImpl.getImportFolderPath(context, folderId);
            DLFolder folder = (DLFolder)context.getZipEntryAsObject(path);
            DLPortletDataHandlerImpl.importFolder(context, folderPKs, folder);
            folderId = MapUtil.getLong(folderPKs, (long)fileEntry.getFolderId(), (long)fileEntry.getFolderId());
        }
        DLFileEntry existingFileEntry = null;
        try {
            DLFolderUtil.findByPrimaryKey((long)folderId);
            if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
                try {
                    existingFileEntry = DLFileEntryUtil.findByUUID_G((String)fileEntry.getUuid(), (long)context.getGroupId());
                    existingFileEntry = DLFileEntryLocalServiceUtil.updateFileEntry((long)userId, (long)existingFileEntry.getFolderId(), (long)folderId, (String)existingFileEntry.getName(), (String)fileEntry.getName(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), (String)fileEntry.getExtraSettings(), (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
                }
                catch (NoSuchFileEntryException nsfee) {
                    existingFileEntry = DLFileEntryLocalServiceUtil.addFileEntry((String)fileEntry.getUuid(), (long)userId, (long)folderId, (String)fileEntry.getName(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), (String)fileEntry.getExtraSettings(), (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
                }
            } else {
                existingFileEntry = DLFileEntryLocalServiceUtil.addFileEntry((long)userId, (long)folderId, (String)fileEntry.getName(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), (String)fileEntry.getExtraSettings(), (InputStream)is, (int)fileEntry.getSize(), (ServiceContext)serviceContext);
            }
            fileEntryNames.put(fileEntry.getName(), existingFileEntry.getName());
            if (context.getBooleanParameter(_NAMESPACE, "comments")) {
                context.importComments(DLFileEntry.class, fileEntry.getFileEntryId(), existingFileEntry.getFileEntryId(), context.getGroupId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
                context.importRatingsEntries(DLFileEntry.class, fileEntry.getFileEntryId(), existingFileEntry.getFileEntryId());
            }
        }
        catch (NoSuchFolderException nsfe) {
            _log.error((Object)("Could not find the parent folder for entry " + fileEntry.getFileEntryId()));
        }
    }

    public static void importFileRank(PortletDataContext context, Map<Long, Long> folderPKs, Map<String, String> fileEntryNames, DLFileRank rank) throws Exception {
        long userId = context.getUserId(rank.getUserUuid());
        long folderId = MapUtil.getLong(folderPKs, (long)rank.getFolderId(), (long)rank.getFolderId());
        String name = fileEntryNames.get(rank.getName());
        if (name == null) {
            name = rank.getName();
        }
        if (folderId != 0L && folderId == rank.getFolderId()) {
            String path = DLPortletDataHandlerImpl.getImportFolderPath(context, folderId);
            DLFolder folder = (DLFolder)context.getZipEntryAsObject(path);
            DLPortletDataHandlerImpl.importFolder(context, folderPKs, folder);
            folderId = MapUtil.getLong(folderPKs, (long)rank.getFolderId(), (long)rank.getFolderId());
        }
        try {
            DLFolderUtil.findByPrimaryKey((long)folderId);
            DLFileRankLocalServiceUtil.updateFileRank((long)context.getGroupId(), (long)context.getCompanyId(), (long)userId, (long)folderId, (String)name);
        }
        catch (NoSuchFolderException nsfe) {
            _log.error((Object)("Could not find the folder for rank " + rank.getFileRankId()));
        }
    }

    public static void importFolder(PortletDataContext context, Map<Long, Long> folderPKs, DLFolder folder) throws Exception {
        long userId = context.getUserId(folder.getUserUuid());
        long groupId = context.getGroupId();
        long parentFolderId = MapUtil.getLong(folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        if (parentFolderId != 0L && parentFolderId == folder.getParentFolderId()) {
            String path = DLPortletDataHandlerImpl.getImportFolderPath(context, parentFolderId);
            DLFolder parentFolder = (DLFolder)context.getZipEntryAsObject(path);
            DLPortletDataHandlerImpl.importFolder(context, folderPKs, parentFolder);
            parentFolderId = MapUtil.getLong(folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        }
        DLFolder existingFolder = null;
        try {
            String name;
            if (parentFolderId != 0L) {
                DLFolderUtil.findByPrimaryKey((long)parentFolderId);
            }
            if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
                existingFolder = DLFolderUtil.fetchByUUID_G((String)folder.getUuid(), (long)context.getGroupId());
                if (existingFolder == null) {
                    name = DLPortletDataHandlerImpl.getFolderName(context.getCompanyId(), context.getGroupId(), parentFolderId, folder.getName(), 2);
                    existingFolder = DLFolderLocalServiceUtil.addFolder((String)folder.getUuid(), (long)userId, (long)groupId, (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
                } else {
                    existingFolder = DLFolderLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
                }
            } else {
                name = DLPortletDataHandlerImpl.getFolderName(context.getCompanyId(), context.getGroupId(), parentFolderId, folder.getName(), 2);
                existingFolder = DLFolderLocalServiceUtil.addFolder((long)userId, (long)groupId, (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            }
            folderPKs.put(folder.getFolderId(), existingFolder.getFolderId());
        }
        catch (NoSuchFolderException nsfe) {
            _log.error((Object)("Could not find the parent folder for folder " + folder.getFolderId()));
        }
    }

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            if (!context.addPrimaryKey(DLPortletDataHandlerImpl.class, "deleteData")) {
                DLFolderLocalServiceUtil.deleteFolders((long)context.getGroupId());
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("documentlibrary-data");
            root.addAttribute("group-id", String.valueOf(context.getGroupId()));
            Element foldersEl = root.addElement("folders");
            Element fileEntriesEl = root.addElement("file-entries");
            Element fileShortcutsEl = root.addElement("file-shortcuts");
            Element fileRanksEl = root.addElement("file-ranks");
            List folders = DLFolderUtil.findByGroupId((long)context.getGroupId());
            for (DLFolder folder : folders) {
                DLPortletDataHandlerImpl.exportFolder(context, foldersEl, fileEntriesEl, fileShortcutsEl, fileRanksEl, folder);
            }
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _ranks, _categories, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _ranks, _categories, _comments, _ratings, _tags};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            String path;
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List folderEls = root.element("folders").elements("folder");
            Map folderPKs = context.getNewPrimaryKeysMap(DLFolder.class);
            for (Element folderEl : folderEls) {
                String path2 = folderEl.attributeValue("path");
                if (!context.isPathNotProcessed(path2)) continue;
                DLFolder folder = (DLFolder)context.getZipEntryAsObject(path2);
                DLPortletDataHandlerImpl.importFolder(context, folderPKs, folder);
            }
            List fileEntryEls = root.element("file-entries").elements("file-entry");
            Map fileEntryNames = context.getNewPrimaryKeysMap(DLFileEntry.class);
            for (Element fileEntryEl : fileEntryEls) {
                String path3 = fileEntryEl.attributeValue("path");
                if (!context.isPathNotProcessed(path3)) continue;
                DLFileEntry fileEntry = (DLFileEntry)context.getZipEntryAsObject(path3);
                String binPath = fileEntryEl.attributeValue("bin-path");
                DLPortletDataHandlerImpl.importFileEntry(context, folderPKs, fileEntryNames, fileEntry, binPath);
            }
            if (context.getBooleanParameter(_NAMESPACE, "shortcuts")) {
                List fileShortcutEls = root.element("file-shortcuts").elements("file-shortcut");
                for (Element fileShortcutEl : fileShortcutEls) {
                    path = fileShortcutEl.attributeValue("path");
                    if (!context.isPathNotProcessed(path)) continue;
                    DLFileShortcut fileShortcut = (DLFileShortcut)context.getZipEntryAsObject(path);
                    DLPortletDataHandlerImpl.importFileShortcut(context, folderPKs, fileEntryNames, fileShortcut);
                }
            }
            if (context.getBooleanParameter(_NAMESPACE, "ranks")) {
                List fileRankEls = root.element("file-ranks").elements("file-rank");
                for (Element fileRankEl : fileRankEls) {
                    path = fileRankEl.attributeValue("path");
                    if (!context.isPathNotProcessed(path)) continue;
                    DLFileRank fileRank = (DLFileRank)context.getZipEntryAsObject(path);
                    DLPortletDataHandlerImpl.importFileRank(context, folderPKs, fileEntryNames, fileRank);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    protected static void exportFileRank(PortletDataContext context, Element fileRanksEl, DLFileRank fileRank) throws SystemException {
        String path = DLPortletDataHandlerImpl.getFileRankPath(context, fileRank);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element fileRankEl = fileRanksEl.addElement("file-rank");
        fileRankEl.addAttribute("path", path);
        fileRank.setUserUuid(fileRank.getUserUuid());
        context.addZipEntry(path, (Object)fileRank);
    }

    protected static void exportFileShortcut(PortletDataContext context, Element foldersEl, Element fileShortcutsEl, DLFileShortcut fileShortcut) throws PortalException, SystemException {
        DLPortletDataHandlerImpl.exportParentFolder(context, foldersEl, fileShortcut.getFolderId());
        String path = DLPortletDataHandlerImpl.getFileShortcutPath(context, fileShortcut);
        if (context.isPathNotProcessed(path)) {
            Element fileShortcutEl = fileShortcutsEl.addElement("file-shortcut");
            fileShortcutEl.addAttribute("path", path);
            fileShortcut.setUserUuid(fileShortcut.getUserUuid());
            context.addZipEntry(path, (Object)fileShortcut);
        }
    }

    protected static void exportParentFolder(PortletDataContext context, Element foldersEl, long folderId) throws PortalException, SystemException {
        if (folderId == 0L) {
            return;
        }
        DLFolder folder = DLFolderUtil.findByPrimaryKey((long)folderId);
        DLPortletDataHandlerImpl.exportParentFolder(context, foldersEl, folder.getParentFolderId());
        String path = DLPortletDataHandlerImpl.getFolderPath(context, folder);
        if (context.isPathNotProcessed(path)) {
            Element folderEl = foldersEl.addElement("folder");
            folderEl.addAttribute("path", path);
            folder.setUserUuid(folder.getUserUuid());
            context.addZipEntry(path, (Object)folder);
        }
    }

    protected static String getFileEntryBinPath(PortletDataContext context, DLFileEntry fileEntry) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("20"));
        sb.append("/bin/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(fileEntry.getVersion());
        sb.append("/");
        sb.append(fileEntry.getTitleWithExtension());
        return sb.toString();
    }

    protected static String getFileEntryPath(PortletDataContext context, DLFileEntry fileEntry) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("20"));
        sb.append("/file-entries/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(fileEntry.getVersion());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFolderName(long companyId, long groupId, long parentFolderId, String name, int count) throws SystemException {
        DLFolder folder = DLFolderUtil.fetchByG_P_N((long)groupId, (long)parentFolderId, (String)name);
        if (folder == null) {
            return name;
        }
        if (Pattern.matches(".* \\(\\d+\\)", name)) {
            int pos = name.lastIndexOf(" (");
            name = name.substring(0, pos);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(" ");
        sb.append("(");
        sb.append(count);
        sb.append(")");
        name = sb.toString();
        return DLPortletDataHandlerImpl.getFolderName(companyId, groupId, parentFolderId, name, ++count);
    }

    protected static String getFolderPath(PortletDataContext context, DLFolder folder) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("20"));
        sb.append("/folders/");
        sb.append(folder.getFolderId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFileRankPath(PortletDataContext context, DLFileRank fileRank) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("20"));
        sb.append("/ranks/");
        sb.append(fileRank.getFileRankId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFileShortcutPath(PortletDataContext context, DLFileShortcut fileShortcut) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("20"));
        sb.append("/shortcuts/");
        sb.append(fileShortcut.getFileShortcutId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getImportFolderPath(PortletDataContext context, long folderId) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getSourcePortletPath("20"));
        sb.append("/folders/");
        sb.append(folderId);
        sb.append(".xml");
        return sb.toString();
    }

    protected static void importFileShortcut(PortletDataContext context, Map<Long, Long> folderPKs, Map<String, String> fileEntryNames, DLFileShortcut fileShortcut) throws Exception {
        long userId = context.getUserId(fileShortcut.getUserUuid());
        long folderId = MapUtil.getLong(folderPKs, (long)fileShortcut.getFolderId(), (long)fileShortcut.getFolderId());
        long toFolderId = MapUtil.getLong(folderPKs, (long)fileShortcut.getToFolderId(), (long)fileShortcut.getToFolderId());
        String toName = MapUtil.getString(fileEntryNames, (String)fileShortcut.getToName(), (String)fileShortcut.getToName());
        try {
            DLFolderUtil.findByPrimaryKey((long)folderId);
            DLFolderUtil.findByPrimaryKey((long)toFolderId);
            DLFileEntry fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)toFolderId, (String)toName);
            String[] tagsCategories = null;
            String[] tagsEntries = null;
            if (context.getBooleanParameter(_NAMESPACE, "categories")) {
                tagsCategories = context.getTagsCategories(DLFileEntry.class, fileEntry.getFileEntryId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "tags")) {
                tagsEntries = context.getTagsEntries(DLFileEntry.class, fileEntry.getFileEntryId());
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddCommunityPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setScopeGroupId(context.getGroupId());
            serviceContext.setTagsCategories(tagsCategories);
            serviceContext.setTagsEntries(tagsEntries);
            if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
                try {
                    DLFileShortcut existingFileShortcut = DLFileShortcutUtil.findByUUID_G((String)fileShortcut.getUuid(), (long)context.getGroupId());
                    DLFileShortcutLocalServiceUtil.updateFileShortcut((long)userId, (long)existingFileShortcut.getFileShortcutId(), (long)folderId, (long)toFolderId, (String)toName, (ServiceContext)serviceContext);
                }
                catch (NoSuchFileShortcutException nsfse) {
                    DLFileShortcutLocalServiceUtil.addFileShortcut((String)fileShortcut.getUuid(), (long)userId, (long)folderId, (long)toFolderId, (String)toName, (ServiceContext)serviceContext);
                }
            } else {
                DLFileShortcutLocalServiceUtil.addFileShortcut((long)userId, (long)folderId, (long)toFolderId, (String)toName, (ServiceContext)serviceContext);
            }
        }
        catch (NoSuchFolderException nsfe) {
            _log.error((Object)("Could not find the folder for shortcut " + fileShortcut.getFileShortcutId()));
        }
    }
}

