/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SafeProperties;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryModelImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class DLFileEntryImpl
extends DLFileEntryModelImpl
implements DLFileEntry {
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryImpl.class);
    private Properties _extraSettingsProperties = null;

    public static String stripExtension(String name, String title) {
        String extension = FileUtil.getExtension((String)name);
        if (extension == null) {
            return title;
        }
        int pos = title.toLowerCase().lastIndexOf("." + extension);
        if (pos > 0) {
            title = title.substring(0, pos);
        }
        return title;
    }

    public String getExtraSettings() {
        if (this._extraSettingsProperties == null) {
            return super.getExtraSettings();
        }
        return PropertiesUtil.toString((Properties)this._extraSettingsProperties);
    }

    public Properties getExtraSettingsProperties() {
        if (this._extraSettingsProperties == null) {
            this._extraSettingsProperties = new SafeProperties();
            try {
                PropertiesUtil.load((Properties)this._extraSettingsProperties, (String)super.getExtraSettings());
            }
            catch (IOException ioe) {
                _log.error((Throwable)ioe);
            }
        }
        return this._extraSettingsProperties;
    }

    public DLFolder getFolder() {
        DLFolder folder = null;
        try {
            folder = DLFolderLocalServiceUtil.getFolder((long)this.getFolderId());
        }
        catch (Exception e) {
            folder = new DLFolderImpl();
            _log.error((Throwable)e);
        }
        return folder;
    }

    public Lock getLock() {
        try {
            String lockId = DLUtil.getLockId(this.getFolderId(), this.getName());
            return LockLocalServiceUtil.getLock((String)DLFileEntry.class.getName(), (String)lockId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLuceneProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTitle());
        sb.append(" ");
        sb.append(this.getDescription());
        sb.append(" ");
        Properties extraSettingsProps = this.getExtraSettingsProperties();
        for (Map.Entry<Object, Object> entry : extraSettingsProps.entrySet()) {
            String value = GetterUtil.getString((String)((String)entry.getValue()));
            sb.append(value);
        }
        return sb.toString();
    }

    public String getTitleWithExtension() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTitle());
        sb.append(".");
        sb.append(FileUtil.getExtension((String)this.getName()));
        return sb.toString();
    }

    public boolean hasLock(long userId) {
        try {
            String lockId = DLUtil.getLockId(this.getFolderId(), this.getName());
            return LockLocalServiceUtil.hasLock((long)userId, (String)DLFileEntry.class.getName(), (String)lockId);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isLocked() {
        try {
            String lockId = DLUtil.getLockId(this.getFolderId(), this.getName());
            return LockLocalServiceUtil.isLocked((String)DLFileEntry.class.getName(), (String)lockId);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setExtraSettings(String extraSettings) {
        this._extraSettingsProperties = null;
        super.setExtraSettings(extraSettings);
    }

    public void setExtraSettingsProperties(Properties extraSettingsProperties) {
        this._extraSettingsProperties = extraSettingsProperties;
        super.setExtraSettings(PropertiesUtil.toString((Properties)this._extraSettingsProperties));
    }
}

