/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.FileSizeException;
import com.liferay.documentlibrary.NoSuchFileException;
import com.liferay.documentlibrary.util.DLIndexerUtil;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.comparator.FileEntryModifiedDateComparator;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.portlet.ratings.model.RatingsStats;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryLocalServiceImpl
extends DLFileEntryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryLocalServiceImpl.class);

    public DLFileEntry addFileEntry(long userId, long folderId, String name, String title, String description, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addFileEntry(null, userId, folderId, name, title, description, extraSettings, bytes, serviceContext);
    }

    public DLFileEntry addFileEntry(long userId, long folderId, String name, String title, String description, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addFileEntry(null, userId, folderId, name, title, description, extraSettings, file, serviceContext);
    }

    public DLFileEntry addFileEntry(long userId, long folderId, String name, String title, String description, String extraSettings, InputStream is, int size, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addFileEntry(null, userId, folderId, name, title, description, extraSettings, is, size, serviceContext);
    }

    public DLFileEntry addFileEntry(String uuid, long userId, long folderId, String name, String title, String description, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!(PropsValues.WEBDAV_LITMUS || bytes != null && bytes.length != 0)) {
            throw new FileSizeException();
        }
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(bytes);
        return this.addFileEntry(uuid, userId, folderId, name, title, description, extraSettings, (InputStream)is, bytes.length, serviceContext);
    }

    public DLFileEntry addFileEntry(String uuid, long userId, long folderId, String name, String title, String description, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!PropsValues.WEBDAV_LITMUS && file == null) {
            throw new FileSizeException();
        }
        try {
            UnsyncBufferedInputStream is = new UnsyncBufferedInputStream((InputStream)new FileInputStream(file));
            return this.addFileEntry(uuid, userId, folderId, name, title, description, extraSettings, (InputStream)is, file.length(), serviceContext);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileSizeException();
        }
    }

    public DLFileEntry addFileEntry(String uuid, long userId, long folderId, String name, String title, String description, String extraSettings, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        folderId = this.getFolderId(user.getCompanyId(), folderId);
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        Date now = new Date();
        if (Validator.isNull((String)title)) {
            title = name;
        }
        name = this.getName(name);
        title = DLFileEntryImpl.stripExtension(name, title);
        this.validate(folder.getGroupId(), folderId, name, title, is);
        long fileEntryId = this.counterLocalService.increment();
        DLFileEntry fileEntry = this.dlFileEntryPersistence.create(fileEntryId);
        fileEntry.setUuid(uuid);
        fileEntry.setGroupId(folder.getGroupId());
        fileEntry.setCompanyId(user.getCompanyId());
        fileEntry.setUserId(user.getUserId());
        fileEntry.setUserName(user.getFullName());
        fileEntry.setVersionUserId(user.getUserId());
        fileEntry.setVersionUserName(user.getFullName());
        fileEntry.setCreateDate(now);
        fileEntry.setModifiedDate(now);
        fileEntry.setFolderId(folderId);
        fileEntry.setName(name);
        fileEntry.setTitle(title);
        fileEntry.setDescription(description);
        fileEntry.setVersion(1.0);
        fileEntry.setSize((int)size);
        fileEntry.setReadCount(0);
        fileEntry.setExtraSettings(extraSettings);
        fileEntry.setExpandoBridgeAttributes(serviceContext);
        this.dlFileEntryPersistence.update((BaseModel)fileEntry, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addFileEntryResources(fileEntry, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addFileEntryResources(fileEntry, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        folder.setLastPostDate(fileEntry.getModifiedDate());
        this.dlFolderPersistence.update((BaseModel)folder, false);
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, fileEntry.getUserName(), DLFileEntry.class.getName(), fileEntryId);
        }
        this.socialActivityLocalService.addActivity(userId, fileEntry.getGroupId(), DLFileEntry.class.getName(), fileEntryId, 1, "", 0L);
        this.updateTagsAsset(userId, fileEntry, serviceContext.getTagsCategories(), serviceContext.getTagsEntries());
        this.dlLocalService.addFile(user.getCompanyId(), "20", fileEntry.getGroupId(), folderId, name, fileEntryId, fileEntry.getLuceneProperties(), fileEntry.getModifiedDate(), serviceContext.getTagsCategories(), serviceContext.getTagsEntries(), is);
        return fileEntry;
    }

    public void addFileEntryResources(DLFileEntry fileEntry, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(fileEntry.getCompanyId(), fileEntry.getGroupId(), fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addFileEntryResources(DLFileEntry fileEntry, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(fileEntry.getCompanyId(), fileEntry.getGroupId(), fileEntry.getUserId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), communityPermissions, guestPermissions);
    }

    public void addFileEntryResources(long fileEntryId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        this.addFileEntryResources(fileEntry, addCommunityPermissions, addGuestPermissions);
    }

    public void addFileEntryResources(long fileEntryId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
        this.addFileEntryResources(fileEntry, communityPermissions, guestPermissions);
    }

    public DLFileEntry addOrOverwriteFileEntry(long userId, long folderId, String name, String sourceName, String title, String description, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean update = false;
        String extension = FileUtil.getExtension((String)name);
        List fileEntries = this.dlFileEntryPersistence.findByF_T(folderId, title);
        for (DLFileEntry fileEntry : fileEntries) {
            String curExtension = FileUtil.getExtension((String)fileEntry.getName());
            if (PropsValues.WEBDAV_LITMUS && Validator.isNull((String)extension)) {
                if (!Validator.isNull((String)curExtension)) continue;
                update = true;
                name = fileEntry.getName();
                break;
            }
            if (!extension.equals(curExtension)) continue;
            update = true;
            break;
        }
        if (update) {
            return this.updateFileEntry(userId, folderId, folderId, name, sourceName, title, description, extraSettings, file, serviceContext);
        }
        return this.addFileEntry(userId, folderId, name, title, description, extraSettings, file, serviceContext);
    }

    public void deleteFileEntries(long folderId) throws PortalException, SystemException {
        List fileEntries = this.dlFileEntryPersistence.findByFolderId(folderId);
        for (DLFileEntry fileEntry : fileEntries) {
            this.deleteFileEntry(fileEntry);
        }
    }

    public void deleteFileEntry(DLFileEntry fileEntry) throws PortalException, SystemException {
        block3: {
            this.dlFileEntryPersistence.remove((BaseModel)fileEntry);
            this.resourceLocalService.deleteResource(fileEntry.getCompanyId(), DLFileEntry.class.getName(), 4, fileEntry.getFileEntryId());
            this.webDAVPropsLocalService.deleteWebDAVProps(DLFileEntry.class.getName(), fileEntry.getPrimaryKey());
            this.dlFileRankLocalService.deleteFileRanks(fileEntry.getFolderId(), fileEntry.getName());
            this.dlFileShortcutLocalService.deleteFileShortcuts(fileEntry.getFolderId(), fileEntry.getName());
            List fileVersions = this.dlFileVersionPersistence.findByF_N(fileEntry.getFolderId(), fileEntry.getName());
            for (DLFileVersion fileVersion : fileVersions) {
                this.dlFileVersionPersistence.remove((BaseModel)fileVersion);
            }
            this.expandoValueLocalService.deleteValues(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            this.mbMessageLocalService.deleteDiscussionMessages(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            this.socialActivityLocalService.deleteActivities(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            this.ratingsStatsLocalService.deleteStats(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            this.tagsAssetLocalService.deleteAsset(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            try {
                this.dlService.deleteFile(fileEntry.getCompanyId(), "20", fileEntry.getFolderId(), fileEntry.getName());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    public void deleteFileEntry(long folderId, String name) throws PortalException, SystemException {
        this.deleteFileEntry(folderId, name, -1.0);
    }

    public void deleteFileEntry(long folderId, String name, double version) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByF_N(folderId, name);
        if (version > 0.0) {
            block4: {
                try {
                    this.dlService.deleteFile(fileEntry.getCompanyId(), "20", fileEntry.getFolderId(), fileEntry.getName(), version);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
            this.dlFileVersionPersistence.removeByF_N_V(folderId, name, version);
        } else {
            this.deleteFileEntry(fileEntry);
        }
    }

    public List<DLFileEntry> getCompanyFileEntries(long companyId, int start, int end) throws SystemException {
        return this.dlFileEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public List<DLFileEntry> getCompanyFileEntries(long companyId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFileEntryPersistence.findByCompanyId(companyId, start, end, obc);
    }

    public int getCompanyFileEntriesCount(long companyId) throws SystemException {
        return this.dlFileEntryPersistence.countByCompanyId(companyId);
    }

    public InputStream getFileAsStream(long companyId, long userId, long folderId, String name) throws PortalException, SystemException {
        return this.getFileAsStream(companyId, userId, folderId, name, 0.0);
    }

    public InputStream getFileAsStream(long companyId, long userId, long folderId, String name, double version) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByF_N(folderId, name);
        if (userId > 0L) {
            this.dlFileRankLocalService.updateFileRank(fileEntry.getGroupId(), companyId, userId, folderId, name);
        }
        fileEntry.setReadCount(fileEntry.getReadCount() + 1);
        this.dlFileEntryPersistence.update((BaseModel)fileEntry, false);
        this.tagsAssetLocalService.incrementViewCounter(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
        List fileShortcuts = this.dlFileShortcutPersistence.findByTF_TN(folderId, name);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this.tagsAssetLocalService.incrementViewCounter(DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId());
        }
        if (version > 0.0 && fileEntry.getVersion() != version) {
            return this.dlLocalService.getFileAsStream(companyId, folderId, name, version);
        }
        return this.dlLocalService.getFileAsStream(companyId, folderId, name, fileEntry.getVersion());
    }

    public List<DLFileEntry> getFileEntries(long folderId) throws SystemException {
        return this.dlFileEntryPersistence.findByFolderId(folderId);
    }

    public List<DLFileEntry> getFileEntries(long folderId, int start, int end) throws SystemException {
        return this.dlFileEntryPersistence.findByFolderId(folderId, start, end);
    }

    public List<DLFileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFileEntryPersistence.findByFolderId(folderId, start, end, obc);
    }

    public int getFileEntriesCount(long folderId) throws SystemException {
        return this.dlFileEntryPersistence.countByFolderId(folderId);
    }

    public DLFileEntry getFileEntry(long fileEntryId) throws PortalException, SystemException {
        return this.dlFileEntryPersistence.findByPrimaryKey(fileEntryId);
    }

    public DLFileEntry getFileEntry(long folderId, String name) throws PortalException, SystemException {
        return this.dlFileEntryPersistence.findByF_N(folderId, name);
    }

    public DLFileEntry getFileEntryByTitle(long folderId, String titleWithExtension) throws PortalException, SystemException {
        String title = DLFileEntryImpl.stripExtension(titleWithExtension, titleWithExtension);
        String extension = FileUtil.getExtension((String)titleWithExtension);
        List fileEntries = this.dlFileEntryPersistence.findByF_T(folderId, title);
        for (DLFileEntry fileEntry : fileEntries) {
            String curExtension = FileUtil.getExtension((String)fileEntry.getName());
            if (!(PropsValues.WEBDAV_LITMUS && Validator.isNull((String)extension) ? Validator.isNull((String)curExtension) : extension.equals(curExtension))) continue;
            return fileEntry;
        }
        throw new NoSuchFileEntryException();
    }

    public DLFileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException, SystemException {
        return this.dlFileEntryPersistence.findByUUID_G(uuid, groupId);
    }

    public int getFoldersFileEntriesCount(List<Long> folderIds) throws SystemException {
        return this.dlFileEntryFinder.countByFolderIds(folderIds);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, int start, int end) throws SystemException {
        return this.getGroupFileEntries(groupId, start, end, (OrderByComparator)new FileEntryModifiedDateComparator());
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFileEntryPersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end) throws SystemException {
        return this.getGroupFileEntries(groupId, userId, start, end, (OrderByComparator)new FileEntryModifiedDateComparator());
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, int start, int end, OrderByComparator obc) throws SystemException {
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.findByGroupId(groupId, start, end, obc);
        }
        return this.dlFileEntryPersistence.findByG_U(groupId, userId, start, end, obc);
    }

    public int getGroupFileEntriesCount(long groupId) throws SystemException {
        return this.dlFileEntryPersistence.countByGroupId(groupId);
    }

    public int getGroupFileEntriesCount(long groupId, long userId) throws SystemException {
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.countByGroupId(groupId);
        }
        return this.dlFileEntryPersistence.countByG_U(groupId, userId);
    }

    public List<DLFileEntry> getNoAssetFileEntries() throws SystemException {
        return this.dlFileEntryFinder.findByNoAssets();
    }

    public void reIndex(long fileEntryId) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        DLFileEntry fileEntry = this.dlFileEntryPersistence.fetchByPrimaryKey(fileEntryId);
        if (fileEntry == null) {
            return;
        }
        DLFolder folder = fileEntry.getFolder();
        long companyId = fileEntry.getCompanyId();
        String portletId = "20";
        long groupId = folder.getGroupId();
        long folderId = folder.getFolderId();
        String fileName = fileEntry.getName();
        String properties = fileEntry.getLuceneProperties();
        Date modifiedDate = fileEntry.getModifiedDate();
        String[] tagsCategories = this.tagsEntryLocalService.getEntryNames(DLFileEntry.class.getName(), fileEntryId, false);
        String[] tagsEntries = this.tagsEntryLocalService.getEntryNames(DLFileEntry.class.getName(), fileEntryId);
        try {
            DLIndexerUtil.updateFile((long)companyId, (String)portletId, (long)groupId, (long)folderId, (String)fileName, (long)fileEntryId, (String)properties, (Date)modifiedDate, (String[])tagsCategories, (String[])tagsEntries);
        }
        catch (SearchException se) {
            _log.error((Object)("Reindexing " + fileEntryId), (Throwable)se);
        }
    }

    public DLFileEntry updateFileEntry(long userId, long folderId, long newFolderId, String name, String sourceFileName, String title, String description, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        UnsyncByteArrayInputStream is = null;
        long size = 0L;
        if (bytes != null && bytes.length > 0) {
            is = new UnsyncByteArrayInputStream(bytes);
            size = bytes.length;
        }
        return this.updateFileEntry(userId, folderId, newFolderId, name, sourceFileName, title, description, extraSettings, (InputStream)is, size, serviceContext);
    }

    public DLFileEntry updateFileEntry(long userId, long folderId, long newFolderId, String name, String sourceFileName, String title, String description, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            UnsyncBufferedInputStream is = null;
            long size = 0L;
            if (file != null && file.length() > 0L) {
                is = new UnsyncBufferedInputStream((InputStream)new FileInputStream(file));
                size = file.length();
            }
            return this.updateFileEntry(userId, folderId, newFolderId, name, sourceFileName, title, description, extraSettings, (InputStream)is, size, serviceContext);
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException();
        }
    }

    public DLFileEntry updateFileEntry(long userId, long folderId, long newFolderId, String name, String sourceFileName, String title, String description, String extraSettings, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        if (Validator.isNull((String)title) && Validator.isNull((String)(title = sourceFileName))) {
            title = name;
        }
        title = DLFileEntryImpl.stripExtension(name, title);
        this.validate(folder.getGroupId(), folderId, newFolderId, name, title, sourceFileName, is);
        DLFileEntry fileEntry = this.dlFileEntryPersistence.findByF_N(folderId, name);
        fileEntry.setTitle(title);
        fileEntry.setDescription(description);
        fileEntry.setExtraSettings(extraSettings);
        fileEntry.setExpandoBridgeAttributes(serviceContext);
        this.dlFileEntryPersistence.update((BaseModel)fileEntry, false);
        if (newFolderId > 0L && folderId != newFolderId) {
            long oldFileEntryId = fileEntry.getFileEntryId();
            DLFolder newFolder = this.dlFolderPersistence.findByPrimaryKey(newFolderId);
            if (folder.getGroupId() != newFolder.getGroupId()) {
                throw new NoSuchFolderException();
            }
            if (this.dlLocalService.hasFile(user.getCompanyId(), newFolderId, name, 0.0)) {
                throw new DuplicateFileException(name);
            }
            long newFileEntryId = this.counterLocalService.increment();
            DLFileEntry newFileEntry = this.dlFileEntryPersistence.create(newFileEntryId);
            newFileEntry.setGroupId(fileEntry.getGroupId());
            newFileEntry.setCompanyId(fileEntry.getCompanyId());
            newFileEntry.setUserId(fileEntry.getUserId());
            newFileEntry.setUserName(fileEntry.getUserName());
            newFileEntry.setVersionUserId(fileEntry.getVersionUserId());
            newFileEntry.setVersionUserName(fileEntry.getVersionUserName());
            newFileEntry.setCreateDate(fileEntry.getCreateDate());
            newFileEntry.setModifiedDate(fileEntry.getModifiedDate());
            newFileEntry.setFolderId(newFolderId);
            newFileEntry.setName(name);
            newFileEntry.setTitle(fileEntry.getTitle());
            newFileEntry.setDescription(fileEntry.getDescription());
            newFileEntry.setVersion(fileEntry.getVersion());
            newFileEntry.setSize(fileEntry.getSize());
            newFileEntry.setReadCount(fileEntry.getReadCount());
            newFileEntry.setExtraSettings(extraSettings);
            this.dlFileEntryPersistence.update((BaseModel)newFileEntry, false);
            this.dlFileEntryPersistence.remove((BaseModel)fileEntry);
            List fileVersions = this.dlFileVersionPersistence.findByF_N(folderId, name);
            for (DLFileVersion fileVersion : fileVersions) {
                long newFileVersionId = this.counterLocalService.increment();
                DLFileVersion newFileVersion = this.dlFileVersionPersistence.create(newFileVersionId);
                newFileVersion.setGroupId(fileVersion.getGroupId());
                newFileVersion.setCompanyId(fileVersion.getCompanyId());
                newFileVersion.setUserId(fileVersion.getUserId());
                newFileVersion.setUserName(fileVersion.getUserName());
                newFileVersion.setCreateDate(fileVersion.getCreateDate());
                newFileVersion.setFolderId(newFolderId);
                newFileVersion.setName(name);
                newFileVersion.setVersion(fileVersion.getVersion());
                newFileVersion.setSize(fileVersion.getSize());
                this.dlFileVersionPersistence.update((BaseModel)newFileVersion, false);
                this.dlFileVersionPersistence.remove((BaseModel)fileVersion);
            }
            this.dlFileShortcutLocalService.updateFileShortcuts(folderId, name, newFolderId, name);
            Resource resource = this.resourceLocalService.getResource(fileEntry.getCompanyId(), DLFileEntry.class.getName(), 4, String.valueOf(fileEntry.getPrimaryKey()));
            resource.setPrimKey(String.valueOf(newFileEntryId));
            this.resourcePersistence.update((BaseModel)resource, false);
            this.expandoValueLocalService.deleteValues(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            RatingsStats stats = this.ratingsStatsLocalService.getStats(DLFileEntry.class.getName(), oldFileEntryId);
            stats.setClassPK(newFileEntryId);
            this.ratingsStatsPersistence.update((BaseModel)stats, false);
            long classNameId = PortalUtil.getClassNameId((String)DLFileEntry.class.getName());
            List entries = this.ratingsEntryPersistence.findByC_C(classNameId, oldFileEntryId);
            for (RatingsEntry entry : entries) {
                entry.setClassPK(newFileEntryId);
                this.ratingsEntryPersistence.update((BaseModel)entry, false);
            }
            MBDiscussion discussion = this.mbDiscussionPersistence.fetchByC_C(classNameId, oldFileEntryId);
            if (discussion != null) {
                discussion.setClassPK(newFileEntryId);
                this.mbDiscussionPersistence.update((BaseModel)discussion, false);
            }
            this.socialActivityLocalService.deleteActivities(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            this.tagsAssetLocalService.deleteAsset(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
            List fileShortcuts = this.dlFileShortcutPersistence.findByTF_TN(folderId, name);
            for (DLFileShortcut fileShortcut : fileShortcuts) {
                this.tagsAssetLocalService.deleteAsset(DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId());
            }
            this.dlService.updateFile(user.getCompanyId(), "20", newFileEntry.getGroupId(), folderId, newFolderId, name, newFileEntryId);
            folderId = newFolderId;
            folder = newFolder;
            fileEntry = newFileEntry;
        }
        this.socialActivityLocalService.addActivity(userId, fileEntry.getGroupId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), 2, "", 0L);
        this.updateTagsAsset(userId, fileEntry, serviceContext.getTagsCategories(), serviceContext.getTagsEntries());
        double oldVersion = fileEntry.getVersion();
        double newVersion = MathUtil.format((double)(oldVersion + 0.1), (int)1, (int)1);
        if (is == null) {
            fileEntry.setVersion(newVersion);
            this.dlFileEntryPersistence.update((BaseModel)fileEntry, false);
            is = this.dlLocalService.getFileAsStream(user.getCompanyId(), folderId, name);
            this.dlLocalService.updateFile(user.getCompanyId(), "20", fileEntry.getGroupId(), folderId, name, newVersion, name, fileEntry.getFileEntryId(), fileEntry.getLuceneProperties(), fileEntry.getModifiedDate(), serviceContext.getTagsCategories(), serviceContext.getTagsEntries(), is);
            return fileEntry;
        }
        this.addFileVersion(user, fileEntry, oldVersion);
        fileEntry.setVersionUserId(user.getUserId());
        fileEntry.setVersionUserName(user.getFullName());
        fileEntry.setModifiedDate(new Date());
        fileEntry.setVersion(newVersion);
        fileEntry.setSize((int)size);
        this.dlFileEntryPersistence.update((BaseModel)fileEntry, false);
        folder.setLastPostDate(fileEntry.getModifiedDate());
        this.dlFolderPersistence.update((BaseModel)folder, false);
        this.dlLocalService.updateFile(user.getCompanyId(), "20", fileEntry.getGroupId(), folderId, name, newVersion, sourceFileName, fileEntry.getFileEntryId(), fileEntry.getLuceneProperties(), fileEntry.getModifiedDate(), serviceContext.getTagsCategories(), serviceContext.getTagsEntries(), is);
        return fileEntry;
    }

    public void updateTagsAsset(long userId, DLFileEntry fileEntry, String[] tagsCategories, String[] tagsEntries) throws PortalException, SystemException {
        String mimeType = MimeTypesUtil.getContentType((String)fileEntry.getName());
        this.tagsAssetLocalService.updateAsset(userId, fileEntry.getGroupId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), tagsCategories, tagsEntries, true, null, null, null, null, mimeType, fileEntry.getTitle(), fileEntry.getDescription(), null, null, 0, 0, null, false);
        List fileShortcuts = this.dlFileShortcutPersistence.findByTF_TN(fileEntry.getFolderId(), fileEntry.getName());
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this.tagsAssetLocalService.updateAsset(userId, fileShortcut.getGroupId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), tagsCategories, tagsEntries, true, null, null, null, null, mimeType, fileEntry.getTitle(), fileEntry.getDescription(), null, null, 0, 0, null, false);
        }
    }

    protected void addFileVersion(User user, DLFileEntry fileEntry, double version) throws SystemException {
        long fileVersionId = this.counterLocalService.increment();
        DLFileVersion fileVersion = this.dlFileVersionPersistence.create(fileVersionId);
        long versionUserId = fileEntry.getVersionUserId();
        if (versionUserId <= 0L) {
            versionUserId = fileEntry.getUserId();
        }
        String versionUserName = GetterUtil.getString((String)fileEntry.getVersionUserName(), (String)fileEntry.getUserName());
        fileVersion.setGroupId(fileEntry.getGroupId());
        fileVersion.setCompanyId(fileEntry.getCompanyId());
        fileVersion.setUserId(versionUserId);
        fileVersion.setUserName(versionUserName);
        fileVersion.setCreateDate(fileEntry.getModifiedDate());
        fileVersion.setFolderId(fileEntry.getFolderId());
        fileVersion.setName(fileEntry.getName());
        fileVersion.setVersion(version);
        fileVersion.setSize(fileEntry.getSize());
        this.dlFileVersionPersistence.update((BaseModel)fileVersion, false);
    }

    protected long getFolderId(long companyId, long folderId) throws SystemException {
        DLFolder folder;
        if (folderId != 0L && ((folder = this.dlFolderPersistence.fetchByPrimaryKey(folderId)) == null || companyId != folder.getCompanyId())) {
            folderId = 0L;
        }
        return folderId;
    }

    protected String getName(String name) throws SystemException {
        String extension = "";
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            extension = name.substring(pos + 1, name.length()).toLowerCase();
        }
        name = String.valueOf(this.counterLocalService.increment(DLFileEntry.class.getName()));
        if (Validator.isNotNull((String)extension)) {
            name = "DLFE-" + name + "." + extension;
        }
        return name;
    }

    protected void validate(long groupId, long folderId, long newFolderId, String name, String title, String sourceFileName, InputStream is) throws PortalException, SystemException {
        if (Validator.isNotNull((String)sourceFileName)) {
            this.dlLocalService.validate(name, sourceFileName, is);
        }
        if (newFolderId > 0L && folderId != newFolderId) {
            folderId = newFolderId;
        }
        String extension = FileUtil.getExtension((String)name);
        try {
            String titleWithExtension = title;
            if (Validator.isNotNull((String)extension)) {
                titleWithExtension = titleWithExtension + "." + extension;
            }
            this.dlFolderLocalService.getFolder(groupId, folderId, titleWithExtension);
            throw new DuplicateFolderNameException();
        }
        catch (NoSuchFolderException nsfe) {
            List fileEntries = this.dlFileEntryPersistence.findByF_T(folderId, title);
            for (DLFileEntry fileEntry : fileEntries) {
                if (name.equals(fileEntry.getName())) continue;
                String curExtension = FileUtil.getExtension((String)fileEntry.getName());
                if (!(PropsValues.WEBDAV_LITMUS && Validator.isNull((String)extension) ? Validator.isNull((String)curExtension) : extension.equals(curExtension))) continue;
                throw new DuplicateFileException(fileEntry.getTitleWithExtension());
            }
            return;
        }
    }

    protected void validate(long groupId, long folderId, String name, String title, InputStream is) throws PortalException, SystemException {
        this.dlLocalService.validate(name, is);
        String extension = FileUtil.getExtension((String)name);
        try {
            String titleWithExtension = title;
            if (Validator.isNotNull((String)extension)) {
                titleWithExtension = titleWithExtension + "." + extension;
            }
            this.dlFolderLocalService.getFolder(groupId, folderId, titleWithExtension);
            throw new DuplicateFolderNameException();
        }
        catch (NoSuchFolderException nsfe) {
            List fileEntries = this.dlFileEntryPersistence.findByF_T(folderId, title);
            for (DLFileEntry fileEntry : fileEntries) {
                String curExtension = FileUtil.getExtension((String)fileEntry.getName());
                if (!(PropsValues.WEBDAV_LITMUS && Validator.isNull((String)extension) ? Validator.isNull((String)curExtension) : extension.equals(curExtension))) continue;
                throw new DuplicateFileException(fileEntry.getTitleWithExtension());
            }
            return;
        }
    }
}

