/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.ExpiredLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryServiceImpl
extends DLFileEntryServiceBaseImpl {
    public DLFileEntry addFileEntry(long folderId, String name, String title, String description, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), folderId, "ADD_DOCUMENT");
        return this.dlFileEntryLocalService.addFileEntry(this.getUserId(), folderId, name, title, description, extraSettings, bytes, serviceContext);
    }

    public DLFileEntry addFileEntry(long folderId, String name, String title, String description, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), folderId, "ADD_DOCUMENT");
        return this.dlFileEntryLocalService.addFileEntry(this.getUserId(), folderId, name, title, description, extraSettings, file, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFileEntry(long folderId, String name) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), folderId, name, "DELETE");
        boolean hasLock = this.hasFileEntryLock(folderId, name);
        if (!hasLock) {
            this.lockFileEntry(folderId, name);
        }
        try {
            this.dlFileEntryLocalService.deleteFileEntry(folderId, name);
        }
        finally {
            if (!hasLock) {
                this.unlockFileEntry(folderId, name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFileEntry(long folderId, String name, double version) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), folderId, name, "DELETE");
        boolean hasLock = this.hasFileEntryLock(folderId, name);
        if (!hasLock) {
            this.lockFileEntry(folderId, name);
        }
        try {
            this.dlFileEntryLocalService.deleteFileEntry(folderId, name, version);
        }
        finally {
            if (!hasLock) {
                this.unlockFileEntry(folderId, name);
            }
        }
    }

    public void deleteFileEntryByTitle(long folderId, String titleWithExtension) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.getFileEntryByTitle(folderId, titleWithExtension);
        this.deleteFileEntry(folderId, fileEntry.getName());
    }

    public List<DLFileEntry> getFileEntries(long folderId) throws PortalException, SystemException {
        List fileEntries = this.dlFileEntryLocalService.getFileEntries(folderId);
        fileEntries = ListUtil.copy((List)fileEntries);
        Iterator itr = fileEntries.iterator();
        while (itr.hasNext()) {
            DLFileEntry fileEntry = (DLFileEntry)itr.next();
            if (DLFileEntryPermission.contains(this.getPermissionChecker(), fileEntry, "VIEW")) continue;
            itr.remove();
        }
        return fileEntries;
    }

    public DLFileEntry getFileEntry(long folderId, String name) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), folderId, name, "VIEW");
        return this.dlFileEntryLocalService.getFileEntry(folderId, name);
    }

    public DLFileEntry getFileEntryByTitle(long folderId, String titleWithExtension) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntryByTitle(folderId, titleWithExtension);
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntry, "VIEW");
        return fileEntry;
    }

    public boolean hasFileEntryLock(long folderId, String name) throws PortalException, SystemException {
        String lockId = DLUtil.getLockId(folderId, name);
        boolean hasLock = this.lockLocalService.hasLock(this.getUserId(), DLFileEntry.class.getName(), lockId);
        if (!hasLock) {
            hasLock = this.dlFolderService.hasInheritableLock(folderId);
        }
        return hasLock;
    }

    public Lock lockFileEntry(long folderId, String name) throws PortalException, SystemException {
        return this.lockFileEntry(folderId, name, null, DLFileEntryImpl.LOCK_EXPIRATION_TIME);
    }

    public Lock lockFileEntry(long folderId, String name, String owner, long expirationTime) throws PortalException, SystemException {
        if (expirationTime <= 0L || expirationTime > DLFileEntryImpl.LOCK_EXPIRATION_TIME) {
            expirationTime = DLFileEntryImpl.LOCK_EXPIRATION_TIME;
        }
        String lockId = DLUtil.getLockId(folderId, name);
        return this.lockLocalService.lock(this.getUser().getUserId(), DLFileEntry.class.getName(), lockId, owner, false, System.currentTimeMillis() + expirationTime);
    }

    public Lock refreshFileEntryLock(String lockUuid, long expirationTime) throws PortalException, SystemException {
        return this.lockLocalService.refresh(lockUuid, expirationTime);
    }

    public void unlockFileEntry(long folderId, String name) throws SystemException {
        String lockId = DLUtil.getLockId(folderId, name);
        this.lockLocalService.unlock(DLFileEntry.class.getName(), lockId);
    }

    public void unlockFileEntry(long folderId, String name, String lockUuid) throws PortalException, SystemException {
        String lockId;
        block4: {
            lockId = DLUtil.getLockId(folderId, name);
            if (Validator.isNotNull((String)lockUuid)) {
                try {
                    Lock lock = this.lockLocalService.getLock(DLFileEntry.class.getName(), lockId);
                    if (!lock.getUuid().equals(lockUuid)) {
                        throw new InvalidLockException("UUIDs do not match");
                    }
                }
                catch (PortalException pe) {
                    if (pe instanceof ExpiredLockException || pe instanceof NoSuchLockException) break block4;
                    throw pe;
                }
            }
        }
        this.lockLocalService.unlock(DLFileEntry.class.getName(), lockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLFileEntry updateFileEntry(long folderId, long newFolderId, String name, String sourceFileName, String title, String description, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), folderId, name, "UPDATE");
        boolean hasLock = this.hasFileEntryLock(folderId, name);
        if (!hasLock) {
            this.lockFileEntry(folderId, name);
        }
        DLFileEntry fileEntry = null;
        try {
            fileEntry = this.dlFileEntryLocalService.updateFileEntry(this.getUserId(), folderId, newFolderId, name, sourceFileName, title, description, extraSettings, bytes, serviceContext);
        }
        finally {
            if (!hasLock) {
                this.unlockFileEntry(folderId, name);
            }
        }
        return fileEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLFileEntry updateFileEntry(long folderId, long newFolderId, String name, String sourceFileName, String title, String description, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), folderId, name, "UPDATE");
        boolean hasLock = this.hasFileEntryLock(folderId, name);
        if (!hasLock) {
            this.lockFileEntry(folderId, name);
        }
        DLFileEntry fileEntry = null;
        try {
            fileEntry = this.dlFileEntryLocalService.updateFileEntry(this.getUserId(), folderId, newFolderId, name, sourceFileName, title, description, extraSettings, file, serviceContext);
        }
        finally {
            if (!hasLock) {
                this.unlockFileEntry(folderId, name);
            }
        }
        return fileEntry;
    }

    public boolean verifyFileEntryLock(long folderId, String name, String lockUuid) throws PortalException, SystemException {
        boolean verified = false;
        try {
            String lockId = DLUtil.getLockId(folderId, name);
            Lock lock = this.lockLocalService.getLock(DLFileEntry.class.getName(), lockId);
            if (lock.getUuid().equals(lockUuid)) {
                verified = true;
            }
        }
        catch (PortalException pe) {
            if (pe instanceof ExpiredLockException || pe instanceof NoSuchLockException) {
                verified = this.dlFolderService.verifyInheritableLock(folderId, lockUuid);
            }
            throw pe;
        }
        return verified;
    }
}

