/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.base.DLFileShortcutLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class DLFileShortcutLocalServiceImpl
extends DLFileShortcutLocalServiceBaseImpl {
    public DLFileShortcut addFileShortcut(long userId, long folderId, long toFolderId, String toName, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        return this.addFileShortcut(null, userId, folderId, toFolderId, toName, addCommunityPermissions, addGuestPermissions, null, null);
    }

    public DLFileShortcut addFileShortcut(long userId, long folderId, long toFolderId, String toName, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addFileShortcut(null, userId, folderId, toFolderId, toName, serviceContext);
    }

    public DLFileShortcut addFileShortcut(long userId, long folderId, long toFolderId, String toName, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        return this.addFileShortcut(null, userId, folderId, toFolderId, toName, null, null, communityPermissions, guestPermissions);
    }

    public DLFileShortcut addFileShortcut(String uuid, long userId, long folderId, long toFolderId, String toName, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        return this.addFileShortcut(uuid, userId, folderId, toFolderId, toName, addCommunityPermissions, addGuestPermissions, null, null);
    }

    public DLFileShortcut addFileShortcut(String uuid, long userId, long folderId, long toFolderId, String toName, Boolean addCommunityPermissions, Boolean addGuestPermissions, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(addCommunityPermissions.booleanValue());
        serviceContext.setAddGuestPermissions(addGuestPermissions.booleanValue());
        serviceContext.setCommunityPermissions(communityPermissions);
        serviceContext.setGuestPermissions(guestPermissions);
        return this.addFileShortcut(uuid, userId, folderId, toFolderId, toName, serviceContext);
    }

    public DLFileShortcut addFileShortcut(String uuid, long userId, long folderId, long toFolderId, String toName, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        folderId = this.getFolderId(user.getCompanyId(), folderId);
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        Date now = new Date();
        this.validate(user, toFolderId, toName);
        long fileShortcutId = this.counterLocalService.increment();
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.create(fileShortcutId);
        fileShortcut.setUuid(uuid);
        fileShortcut.setGroupId(folder.getGroupId());
        fileShortcut.setCompanyId(user.getCompanyId());
        fileShortcut.setUserId(user.getUserId());
        fileShortcut.setUserName(user.getFullName());
        fileShortcut.setCreateDate(now);
        fileShortcut.setModifiedDate(now);
        fileShortcut.setFolderId(folderId);
        fileShortcut.setToFolderId(toFolderId);
        fileShortcut.setToName(toName);
        this.dlFileShortcutPersistence.update((BaseModel)fileShortcut, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addFileShortcutResources(fileShortcut, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addFileShortcutResources(fileShortcut, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        folder.setLastPostDate(fileShortcut.getModifiedDate());
        this.dlFolderPersistence.update((BaseModel)folder, false);
        DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntry(toFolderId, toName);
        this.copyTagEntries(fileEntry, serviceContext);
        this.updateTagsAsset(userId, fileShortcut, serviceContext.getTagsCategories(), serviceContext.getTagsEntries());
        return fileShortcut;
    }

    public void addFileShortcutResources(DLFileShortcut fileShortcut, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(fileShortcut.getCompanyId(), fileShortcut.getGroupId(), fileShortcut.getUserId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addFileShortcutResources(DLFileShortcut fileShortcut, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(fileShortcut.getCompanyId(), fileShortcut.getGroupId(), fileShortcut.getUserId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), communityPermissions, guestPermissions);
    }

    public void addFileShortcutResources(long fileShortcutId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.addFileShortcutResources(fileShortcut, addCommunityPermissions, addGuestPermissions);
    }

    public void addFileShortcutResources(long fileShortcutId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        this.addFileShortcutResources(fileShortcut, communityPermissions, guestPermissions);
    }

    public void deleteFileShortcut(DLFileShortcut fileShortcut) throws PortalException, SystemException {
        this.dlFileShortcutPersistence.remove((BaseModel)fileShortcut);
        this.resourceLocalService.deleteResource(fileShortcut.getCompanyId(), DLFileShortcut.class.getName(), 4, fileShortcut.getFileShortcutId());
        this.tagsAssetLocalService.deleteAsset(DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId());
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.dlFileShortcutLocalService.getDLFileShortcut(fileShortcutId);
        this.deleteFileShortcut(fileShortcut);
    }

    public void deleteFileShortcuts(long toFolderId, String toName) throws PortalException, SystemException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByTF_TN(toFolderId, toName);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            this.deleteFileShortcut(fileShortcut);
        }
    }

    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        return this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
    }

    public DLFileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFolderId, String toName) throws PortalException, SystemException {
        ServiceContext serviceContext = new ServiceContext();
        return this.updateFileShortcut(userId, fileShortcutId, folderId, toFolderId, toName, serviceContext);
    }

    public DLFileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFolderId, String toName, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.validate(user, toFolderId, toName);
        DLFileShortcut fileShortcut = this.dlFileShortcutPersistence.findByPrimaryKey(fileShortcutId);
        fileShortcut.setModifiedDate(new Date());
        fileShortcut.setFolderId(folderId);
        fileShortcut.setToFolderId(toFolderId);
        fileShortcut.setToName(toName);
        this.dlFileShortcutPersistence.update((BaseModel)fileShortcut, false);
        folder.setLastPostDate(fileShortcut.getModifiedDate());
        this.dlFolderPersistence.update((BaseModel)folder, false);
        DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntry(toFolderId, toName);
        this.copyTagEntries(fileEntry, serviceContext);
        this.updateTagsAsset(userId, fileShortcut, serviceContext.getTagsCategories(), serviceContext.getTagsEntries());
        return fileShortcut;
    }

    public void updateFileShortcuts(long oldToFolderId, String oldToName, long newToFolderId, String newToName) throws SystemException {
        List fileShortcuts = this.dlFileShortcutPersistence.findByTF_TN(oldToFolderId, oldToName);
        for (DLFileShortcut fileShortcut : fileShortcuts) {
            fileShortcut.setToFolderId(newToFolderId);
            fileShortcut.setToName(newToName);
            this.dlFileShortcutPersistence.update((BaseModel)fileShortcut, false);
        }
    }

    public void updateTagsAsset(long userId, DLFileShortcut fileShortcut, String[] tagsCategories, String[] tagsEntries) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntry(fileShortcut.getToFolderId(), fileShortcut.getToName());
        String mimeType = MimeTypesUtil.getContentType((String)fileEntry.getName());
        this.tagsAssetLocalService.updateAsset(userId, fileShortcut.getGroupId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), tagsCategories, tagsEntries, false, null, null, null, null, mimeType, fileEntry.getTitle(), fileEntry.getDescription(), null, null, 0, 0, null, false);
    }

    protected void copyTagEntries(DLFileEntry fileEntry, ServiceContext serviceContext) throws PortalException, SystemException {
        String[] tagsEntries = this.tagsEntryLocalService.getEntryNames(DLFileEntry.class.getName(), fileEntry.getFileEntryId());
        this.tagsEntryLocalService.checkEntries(serviceContext.getUserId(), serviceContext.getScopeGroupId(), tagsEntries);
        serviceContext.setTagsEntries(tagsEntries);
    }

    protected long getFolderId(long companyId, long folderId) throws SystemException {
        DLFolder folder;
        if (folderId != 0L && ((folder = this.dlFolderPersistence.fetchByPrimaryKey(folderId)) == null || companyId != folder.getCompanyId())) {
            folderId = 0L;
        }
        return folderId;
    }

    protected void validate(User user, long toFolderId, String toName) throws PortalException, SystemException {
        DLFileEntry fileEntry = this.dlFileEntryLocalService.getFileEntry(toFolderId, toName);
        if (user.getCompanyId() != fileEntry.getCompanyId()) {
            throw new NoSuchFileEntryException();
        }
    }
}

