/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.FileShortcutPermissionException;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.base.DLFileShortcutServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFileShortcutPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;

public class DLFileShortcutServiceImpl
extends DLFileShortcutServiceBaseImpl {
    public DLFileShortcut addFileShortcut(long folderId, long toFolderId, String toName, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), folderId, "ADD_SHORTCUT");
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), toFolderId, toName, "VIEW");
        }
        catch (PrincipalException pe) {
            throw new FileShortcutPermissionException();
        }
        return this.dlFileShortcutLocalService.addFileShortcut(this.getUserId(), folderId, toFolderId, toName, addCommunityPermissions, addGuestPermissions);
    }

    public DLFileShortcut addFileShortcut(long folderId, long toFolderId, String toName, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), folderId, "ADD_SHORTCUT");
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), toFolderId, toName, "VIEW");
        }
        catch (PrincipalException pe) {
            throw new FileShortcutPermissionException();
        }
        return this.dlFileShortcutLocalService.addFileShortcut(this.getUserId(), folderId, toFolderId, toName, serviceContext);
    }

    public DLFileShortcut addFileShortcut(long folderId, long toFolderId, String toName, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), folderId, "ADD_SHORTCUT");
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), toFolderId, toName, "VIEW");
        }
        catch (PrincipalException pe) {
            throw new FileShortcutPermissionException();
        }
        return this.dlFileShortcutLocalService.addFileShortcut(this.getUserId(), folderId, toFolderId, toName, communityPermissions, guestPermissions);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcutId, "DELETE");
        this.dlFileShortcutLocalService.deleteFileShortcut(fileShortcutId);
    }

    public DLFileShortcut getFileShortcut(long fileShortcutId) throws PortalException, SystemException {
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcutId, "VIEW");
        return this.dlFileShortcutLocalService.getFileShortcut(fileShortcutId);
    }

    public DLFileShortcut updateFileShortcut(long fileShortcutId, long folderId, long toFolderId, String toName) throws PortalException, SystemException {
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcutId, "UPDATE");
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), toFolderId, toName, "VIEW");
        }
        catch (PrincipalException pe) {
            throw new FileShortcutPermissionException();
        }
        return this.dlFileShortcutLocalService.updateFileShortcut(this.getUserId(), fileShortcutId, folderId, toFolderId, toName);
    }

    public DLFileShortcut updateFileShortcut(long fileShortcutId, long folderId, long toFolderId, String toName, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileShortcutPermission.check(this.getPermissionChecker(), fileShortcutId, "UPDATE");
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), toFolderId, toName, "VIEW");
        }
        catch (PrincipalException pe) {
            throw new FileShortcutPermissionException();
        }
        return this.dlFileShortcutLocalService.updateFileShortcut(this.getUserId(), fileShortcutId, folderId, toFolderId, toName, serviceContext);
    }
}

