/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.base.DLFolderLocalServiceBaseImpl;
import com.liferay.portlet.tags.util.TagsUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFolderLocalServiceImpl
extends DLFolderLocalServiceBaseImpl {
    public DLFolder addFolder(long userId, long groupId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addFolder(null, userId, groupId, parentFolderId, name, description, serviceContext);
    }

    public DLFolder addFolder(String uuid, long userId, long groupId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        Date now = new Date();
        this.validate(groupId, parentFolderId, name);
        long folderId = this.counterLocalService.increment();
        DLFolder folder = this.dlFolderPersistence.create(folderId);
        folder.setUuid(uuid);
        folder.setGroupId(groupId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setCreateDate(now);
        folder.setModifiedDate(now);
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.dlFolderPersistence.update((BaseModel)folder, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addFolderResources(folder, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addFolderResources(folder, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        if (PropsValues.DL_LAYOUTS_SYNC_ENABLED && parentFolderId != 0L) {
            String[] pathArray = folder.getPathArray();
            String layoutsSyncPrivateFolder = GetterUtil.getString((String)PropsUtil.get("dl.layouts.sync.private.folder"));
            String layoutsSyncPublicFolder = GetterUtil.getString((String)PropsUtil.get("dl.layouts.sync.public.folder"));
            if (pathArray[0].equals(layoutsSyncPrivateFolder) || pathArray[0].equals(layoutsSyncPublicFolder)) {
                boolean privateLayout = true;
                if (pathArray[0].equals(layoutsSyncPublicFolder)) {
                    privateLayout = false;
                }
                long parentLayoutId = 0L;
                String title = "";
                String layoutDescription = "";
                String type = "portlet";
                boolean hidden = false;
                String friendlyURL = "";
                Layout dlFolderLayout = null;
                try {
                    dlFolderLayout = this.layoutLocalService.getDLFolderLayout(folder.getParentFolderId());
                    parentLayoutId = dlFolderLayout.getLayoutId();
                }
                catch (NoSuchLayoutException nsle) {
                    // empty catch block
                }
                this.layoutLocalService.addLayout(userId, groupId, privateLayout, parentLayoutId, name, title, layoutDescription, type, hidden, friendlyURL, folder.getFolderId());
            }
        }
        if (parentFolderId != 0L) {
            DLFolder parentFolder = this.dlFolderPersistence.findByPrimaryKey(parentFolderId);
            parentFolder.setLastPostDate(now);
            this.dlFolderPersistence.update((BaseModel)parentFolder, false);
        }
        return folder;
    }

    public void addFolderResources(long folderId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(DLFolder folder, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), DLFolder.class.getName(), folder.getFolderId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(long folderId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, communityPermissions, guestPermissions);
    }

    public void addFolderResources(DLFolder folder, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), DLFolder.class.getName(), folder.getFolderId(), communityPermissions, guestPermissions);
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.deleteFolder(folder);
    }

    public void deleteFolder(DLFolder folder) throws PortalException, SystemException {
        this.dlFolderPersistence.remove((BaseModel)folder);
        this.resourceLocalService.deleteResource(folder.getCompanyId(), DLFolder.class.getName(), 4, folder.getFolderId());
        this.webDAVPropsLocalService.deleteWebDAVProps(DLFolder.class.getName(), folder.getPrimaryKey());
        this.dlFileEntryLocalService.deleteFileEntries(folder.getFolderId());
        List folders = this.dlFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId());
        for (DLFolder curFolder : folders) {
            this.deleteFolder(curFolder);
        }
        this.expandoValueLocalService.deleteValues(DLFolder.class.getName(), folder.getFolderId());
    }

    public void deleteFolders(long groupId) throws PortalException, SystemException {
        List folders = this.dlFolderPersistence.findByG_P(groupId, 0L);
        for (DLFolder folder : folders) {
            this.deleteFolder(folder);
        }
    }

    public List<Object> getFileEntriesAndFileShortcuts(long folderId, int start, int end) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFolderFinder.findFE_FS_ByFolderIds(folderIds, start, end);
    }

    public List<Object> getFileEntriesAndFileShortcuts(List<Long> folderIds, int start, int end) throws SystemException {
        return this.dlFolderFinder.findFE_FS_ByFolderIds(folderIds, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFolderFinder.countFE_FS_ByFolderIds(folderIds);
    }

    public int getFileEntriesAndFileShortcutsCount(List<Long> folderIds) throws SystemException {
        return this.dlFolderFinder.countFE_FS_ByFolderIds(folderIds);
    }

    public DLFolder getFolder(long folderId) throws PortalException, SystemException {
        return this.dlFolderPersistence.findByPrimaryKey(folderId);
    }

    public DLFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        return this.dlFolderPersistence.findByG_P_N(groupId, parentFolderId, name);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int start, int end) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFolderFinder.findF_FE_FS_ByFolderIds(folderIds, start, end);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(List<Long> folderIds, int start, int end) throws SystemException {
        return this.dlFolderFinder.findF_FE_FS_ByFolderIds(folderIds, start, end);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFolderFinder.countF_FE_FS_ByFolderIds(folderIds);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(List<Long> folderIds) throws SystemException {
        return this.dlFolderFinder.countF_FE_FS_ByFolderIds(folderIds);
    }

    public List<DLFolder> getFolders(long companyId) throws SystemException {
        return this.dlFolderPersistence.findByCompanyId(companyId);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.dlFolderPersistence.findByG_P(groupId, parentFolderId);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.dlFolderPersistence.findByG_P(groupId, parentFolderId, start, end);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.dlFolderPersistence.countByG_P(groupId, parentFolderId);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List folders = this.dlFolderPersistence.findByG_P(groupId, folderId);
        for (DLFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    public void reIndex(String[] ids) throws SystemException {
        long companyId = GetterUtil.getLong((String)ids[0]);
        try {
            List<DLFolder> folders = this.getFolders(companyId);
            for (DLFolder folder : folders) {
                String portletId = "20";
                long groupId = folder.getGroupId();
                long folderId = folder.getFolderId();
                String[] newIds = new String[]{String.valueOf(companyId), portletId, String.valueOf(groupId), String.valueOf(folderId)};
                this.dlService.reIndex(newIds);
            }
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Hits search(long companyId, long groupId, long userId, long[] folderIds, String keywords, int start, int end) throws SystemException {
        return this.dlLocalService.search(companyId, "20", groupId, userId, folderIds, keywords, start, end);
    }

    public DLFolder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolder folder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        this.validate(folder.getFolderId(), folder.getGroupId(), parentFolderId, name);
        folder.setModifiedDate(new Date());
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.dlFolderPersistence.update((BaseModel)folder, false);
        if (PropsValues.DL_LAYOUTS_SYNC_ENABLED) {
            String privateFolder = GetterUtil.getString((String)PropsUtil.get("dl.layouts.sync.private.folder"));
            boolean privateLayout = false;
            String[] path = folder.getPathArray();
            if (path[0].equals(privateFolder)) {
                privateLayout = true;
            }
            Layout layout = this.layoutLocalService.getDLFolderLayout(folder.getFolderId());
            layout.setName(folder.getName());
            this.layoutLocalService.updateName(folder.getGroupId(), privateLayout, layout.getLayoutId(), folder.getName(), LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
        }
        return folder;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) throws SystemException {
        DLFolder parentFolder;
        if (parentFolderId != 0L && ((parentFolder = this.dlFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected long getParentFolderId(DLFolder folder, long parentFolderId) throws SystemException {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (folder.getFolderId() == parentFolderId) {
            return folder.getParentFolderId();
        }
        DLFolder parentFolder = this.dlFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null || folder.getGroupId() != parentFolder.getGroupId()) {
            return folder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return folder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected void validate(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        long folderId = 0L;
        this.validate(folderId, groupId, parentFolderId, name);
    }

    protected void validate(long folderId, long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        if (!TagsUtil.isValidWord(name)) {
            throw new FolderNameException();
        }
        try {
            this.dlFileEntryLocalService.getFileEntryByTitle(parentFolderId, name);
            throw new DuplicateFileException();
        }
        catch (NoSuchFileEntryException nsfee) {
            DLFolder folder = this.dlFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
            if (folder != null && folder.getFolderId() != folderId) {
                throw new DuplicateFolderNameException();
            }
            return;
        }
    }
}

