/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.ExpiredLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFolderServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import java.io.File;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFolderServiceImpl
extends DLFolderServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFolderServiceImpl.class);

    public DLFolder addFolder(long groupId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, parentFolderId, "ADD_FOLDER");
        return this.dlFolderLocalService.addFolder(this.getUserId(), groupId, parentFolderId, name, description, serviceContext);
    }

    public DLFolder copyFolder(long groupId, long sourceFolderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, RemoteException, SystemException {
        DLFolder srcFolder = this.getFolder(sourceFolderId);
        DLFolder destFolder = this.addFolder(groupId, parentFolderId, name, description, serviceContext);
        this.copyFolder(srcFolder, destFolder, serviceContext);
        return destFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFolder(long folderId) throws PortalException, RemoteException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), folderId, "DELETE");
        boolean hasLock = this.lockLocalService.hasLock(this.getUserId(), DLFolder.class.getName(), folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(folderId);
        }
        try {
            this.dlFolderLocalService.deleteFolder(folderId);
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    public void deleteFolder(long groupId, long parentFolderId, String name) throws PortalException, RemoteException, SystemException {
        long folderId = this.getFolderId(groupId, parentFolderId, name);
        this.deleteFolder(folderId);
    }

    public DLFolder getFolder(long folderId) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), folderId, "VIEW");
        return this.dlFolderLocalService.getFolder(folderId);
    }

    public DLFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        DLFolder folder = this.dlFolderLocalService.getFolder(groupId, parentFolderId, name);
        DLFolderPermission.check(this.getPermissionChecker(), folder, "VIEW");
        return folder;
    }

    public long getFolderId(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        DLFolder folder = this.getFolder(groupId, parentFolderId, name);
        return folder.getFolderId();
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId) throws PortalException, SystemException {
        List folders = this.dlFolderLocalService.getFolders(groupId, parentFolderId);
        folders = ListUtil.copy((List)folders);
        Iterator itr = folders.iterator();
        while (itr.hasNext()) {
            DLFolder folder = (DLFolder)itr.next();
            if (DLFolderPermission.contains(this.getPermissionChecker(), folder.getFolderId(), "VIEW")) continue;
            itr.remove();
        }
        return folders;
    }

    public boolean hasInheritableLock(long folderId) throws PortalException, SystemException {
        boolean inheritable = false;
        try {
            Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
            inheritable = lock.isInheritable();
        }
        catch (ExpiredLockException ele) {
        }
        catch (NoSuchLockException nsle) {
            // empty catch block
        }
        return inheritable;
    }

    public Lock lockFolder(long folderId) throws PortalException, RemoteException, SystemException {
        return this.lockFolder(folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException, RemoteException, SystemException {
        if (expirationTime <= 0L || expirationTime > DLFolderImpl.LOCK_EXPIRATION_TIME) {
            expirationTime = DLFolderImpl.LOCK_EXPIRATION_TIME;
        }
        Lock lock = this.lockLocalService.lock(this.getUser().getUserId(), DLFolder.class.getName(), folderId, owner, inheritable, expirationTime);
        HashSet<String> fileNames = new HashSet<String>();
        try {
            List fileEntries = this.dlFileEntryService.getFileEntries(folderId);
            for (DLFileEntry fileEntry : fileEntries) {
                this.dlFileEntryService.lockFileEntry(folderId, fileEntry.getName(), owner, expirationTime);
                fileNames.add(fileEntry.getName());
            }
        }
        catch (Exception e) {
            for (String fileName : fileNames) {
                this.dlFileEntryService.unlockFileEntry(folderId, fileName);
            }
            this.unlockFolder(folderId, lock.getUuid());
            if (e instanceof PortalException) {
                throw (PortalException)((Object)e);
            }
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            if (e instanceof SystemException) {
                throw (SystemException)((Object)e);
            }
            throw new PortalException((Throwable)e);
        }
        return lock;
    }

    public Lock refreshFolderLock(String lockUuid, long expirationTime) throws PortalException, SystemException {
        return this.lockLocalService.refresh(lockUuid, expirationTime);
    }

    public void reIndexSearch(long companyId) throws PortalException, SystemException {
        if (!this.getPermissionChecker().isOmniadmin()) {
            throw new PrincipalException();
        }
        String[] ids = new String[]{String.valueOf(companyId)};
        this.dlFolderLocalService.reIndex(ids);
    }

    public void unlockFolder(long groupId, long parentFolderId, String name, String lockUuid) throws PortalException, SystemException {
        long folderId = this.getFolderId(groupId, parentFolderId, name);
        this.unlockFolder(folderId, lockUuid);
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException, SystemException {
        block7: {
            if (Validator.isNotNull((String)lockUuid)) {
                try {
                    Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
                    if (!lock.getUuid().equals(lockUuid)) {
                        throw new InvalidLockException("UUIDs do not match");
                    }
                }
                catch (PortalException pe) {
                    if (pe instanceof ExpiredLockException || pe instanceof NoSuchLockException) break block7;
                    throw pe;
                }
            }
        }
        this.lockLocalService.unlock(DLFolder.class.getName(), folderId);
        try {
            List fileEntries = this.dlFileEntryService.getFileEntries(folderId);
            for (DLFileEntry fileEntry : fileEntries) {
                this.dlFileEntryService.unlockFileEntry(folderId, fileEntry.getName());
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLFolder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, RemoteException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), folderId, "UPDATE");
        boolean hasLock = this.lockLocalService.hasLock(this.getUserId(), DLFolder.class.getName(), folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(folderId);
        }
        try {
            DLFolder dLFolder = this.dlFolderLocalService.updateFolder(folderId, parentFolderId, name, description, serviceContext);
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException, SystemException {
        boolean verified = false;
        try {
            Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
            if (!lock.isInheritable()) {
                throw new NoSuchLockException();
            }
            if (lock.getUuid().equals(lockUuid)) {
                verified = true;
            }
        }
        catch (ExpiredLockException ele) {
            throw new NoSuchLockException((Throwable)ele);
        }
        return verified;
    }

    protected void copyFolder(DLFolder srcFolder, DLFolder destFolder, ServiceContext serviceContext) throws PortalException, RemoteException, SystemException {
        String description;
        List srcFileEntries = this.dlFileEntryService.getFileEntries(srcFolder.getFolderId());
        for (DLFileEntry srcFileEntry : srcFileEntries) {
            String name = srcFileEntry.getName();
            String title = srcFileEntry.getTitleWithExtension();
            description = srcFileEntry.getDescription();
            String extraSettings = srcFileEntry.getExtraSettings();
            File file = null;
            try {
                file = FileUtil.createTempFile((String)FileUtil.getExtension((String)name));
                InputStream is = this.dlLocalService.getFileAsStream(srcFolder.getCompanyId(), srcFolder.getFolderId(), name);
                FileUtil.write((File)file, (InputStream)is);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                continue;
            }
            this.dlFileEntryService.addFileEntry(destFolder.getFolderId(), name, title, description, extraSettings, file, serviceContext);
            file.delete();
        }
        List<DLFolder> srcSubfolders = this.getFolders(srcFolder.getGroupId(), srcFolder.getFolderId());
        for (DLFolder srcSubfolder : srcSubfolders) {
            String name = srcSubfolder.getName();
            description = srcSubfolder.getDescription();
            DLFolder destSubfolder = this.addFolder(destFolder.getGroupId(), destFolder.getFolderId(), name, description, serviceContext);
            this.copyFolder(srcSubfolder, destSubfolder, serviceContext);
        }
    }
}

