/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;

public class DLFileEntryPermission {
    public static void check(PermissionChecker permissionChecker, long folderId, String name, String actionId) throws PortalException, SystemException {
        if (!DLFileEntryPermission.contains(permissionChecker, folderId, name, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, DLFileEntry fileEntry, String actionId) throws PortalException, SystemException {
        if (!DLFileEntryPermission.contains(permissionChecker, fileEntry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long folderId, String name, String actionId) throws PortalException, SystemException {
        DLFileEntry fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)folderId, (String)name);
        return DLFileEntryPermission.contains(permissionChecker, fileEntry, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, DLFileEntry fileEntry, String actionId) throws PortalException, SystemException {
        DLFolder folder = DLFolderLocalServiceUtil.getFolder((long)fileEntry.getFolderId());
        if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE && !DLFolderPermission.contains(permissionChecker, folder, "VIEW")) {
            return false;
        }
        if (permissionChecker.hasOwnerPermission(fileEntry.getCompanyId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), fileEntry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(fileEntry.getGroupId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), actionId);
    }
}

