/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLFileShortcutLocalServiceUtil;

public class DLFileShortcutPermission {
    public static void check(PermissionChecker permissionChecker, long fileShortcutId, String actionId) throws PortalException, SystemException {
        if (!DLFileShortcutPermission.contains(permissionChecker, fileShortcutId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, DLFileShortcut fileShortcut, String actionId) throws PortalException {
        if (!DLFileShortcutPermission.contains(permissionChecker, fileShortcut, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long fileShortcutId, String actionId) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = DLFileShortcutLocalServiceUtil.getFileShortcut((long)fileShortcutId);
        return DLFileShortcutPermission.contains(permissionChecker, fileShortcut, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, DLFileShortcut fileShortcut, String actionId) {
        if (permissionChecker.hasOwnerPermission(fileShortcut.getCompanyId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), fileShortcut.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(fileShortcut.getGroupId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), actionId);
    }
}

