/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;

public class DLFolderPermission {
    public static void check(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException, SystemException {
        if (!DLFolderPermission.contains(permissionChecker, groupId, folderId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long folderId, String actionId) throws PortalException, SystemException {
        if (!DLFolderPermission.contains(permissionChecker, folderId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, DLFolder folder, String actionId) throws PortalException, SystemException {
        if (!DLFolderPermission.contains(permissionChecker, folder, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException, SystemException {
        if (folderId == 0L) {
            return DLPermission.contains(permissionChecker, groupId, actionId);
        }
        return DLFolderPermission.contains(permissionChecker, folderId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long folderId, String actionId) throws PortalException, SystemException {
        DLFolder folder = DLFolderLocalServiceUtil.getFolder((long)folderId);
        return DLFolderPermission.contains(permissionChecker, folder, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, DLFolder folder, String actionId) throws PortalException, SystemException {
        if (actionId.equals("ADD_FOLDER")) {
            actionId = "ADD_SUBFOLDER";
        }
        long folderId = folder.getFolderId();
        if (actionId.equals("VIEW")) {
            while (folderId != 0L) {
                folder = DLFolderLocalServiceUtil.getFolder((long)folderId);
                folderId = folder.getParentFolderId();
                if (!permissionChecker.hasOwnerPermission(folder.getCompanyId(), DLFolder.class.getName(), folder.getFolderId(), folder.getUserId(), actionId) && !permissionChecker.hasPermission(folder.getGroupId(), DLFolder.class.getName(), folder.getFolderId(), actionId)) {
                    return false;
                }
                if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) continue;
            }
            return true;
        }
        while (folderId != 0L) {
            folder = DLFolderLocalServiceUtil.getFolder((long)folderId);
            folderId = folder.getParentFolderId();
            if (permissionChecker.hasOwnerPermission(folder.getCompanyId(), DLFolder.class.getName(), folder.getFolderId(), folder.getUserId(), actionId)) {
                return true;
            }
            if (!permissionChecker.hasPermission(folder.getGroupId(), DLFolder.class.getName(), folder.getFolderId(), actionId)) continue;
            return true;
        }
        return false;
    }
}

