/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.persistence;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileShortcutUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderFinder;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFolderFinderImpl
extends BasePersistenceImpl<DLFolder>
implements DLFolderFinder {
    public static String COUNT_FE_FS_BY_FOLDER_IDS = DLFolderFinder.class.getName() + ".countFE_FS_ByFolderIds";
    public static String COUNT_F_FE_FS_BY_FOLDER_IDS = DLFolderFinder.class.getName() + ".countF_FE_FS_ByFolderIds";
    public static String FIND_FE_FS_BY_FOLDER_IDS = DLFolderFinder.class.getName() + ".findFE_FS_ByFolderIds";
    public static String FIND_F_FE_FS_BY_FOLDER_IDS = DLFolderFinder.class.getName() + ".findF_FE_FS_ByFolderIds";

    public int countFE_FS_ByFolderIds(List<Long> folderIds) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_FE_FS_BY_FOLDER_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$FILE_ENTRY_FOLDER_ID$]", (String)this.getFolderIds(folderIds, "DLFileEntry"));
            sql = StringUtil.replace((String)sql, (String)"[$FILE_SHORTCUT_FOLDER_ID$]", (String)this.getFolderIds(folderIds, "DLFileShortcut"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            int count = 0;
            for (Long l : q.list()) {
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countF_FE_FS_ByFolderIds(List<Long> folderIds) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_F_FE_FS_BY_FOLDER_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$FOLDER_PARENT_FOLDER_ID$]", (String)this.getFolderIds(folderIds, "DLFolder"));
            sql = StringUtil.replace((String)sql, (String)"[$FILE_ENTRY_FOLDER_ID$]", (String)this.getFolderIds(folderIds, "DLFileEntry"));
            sql = StringUtil.replace((String)sql, (String)"[$FILE_SHORTCUT_FOLDER_ID$]", (String)this.getFolderIds(folderIds, "DLFileShortcut"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            int count = 0;
            for (Long l : q.list()) {
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findFE_FS_ByFolderIds(List<Long> folderIds, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_FE_FS_BY_FOLDER_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$FILE_ENTRY_FOLDER_ID$]", (String)this.getFolderIds(folderIds, "DLFileEntry"));
            sql = StringUtil.replace((String)sql, (String)"[$FILE_SHORTCUT_FOLDER_ID$]", (String)this.getFolderIds(folderIds, "DLFileShortcut"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("modelFolderId", Type.LONG);
            q.addScalar("name", Type.STRING);
            q.addScalar("title", Type.STRING);
            q.addScalar("fileShortcutId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            ArrayList<Object> models = new ArrayList<Object>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                Object[] array = (Object[])itr.next();
                long folderId = (Long)array[0];
                String name = (String)array[1];
                long fileShortcutId = (Long)array[3];
                Object obj = null;
                obj = fileShortcutId > 0L ? DLFileShortcutUtil.findByPrimaryKey((long)fileShortcutId) : DLFileEntryUtil.findByF_N((long)folderId, (String)name);
                models.add(obj);
            }
            ArrayList<Object> arrayList = models;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findF_FE_FS_ByFolderIds(List<Long> folderIds, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_F_FE_FS_BY_FOLDER_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$FOLDER_PARENT_FOLDER_ID$]", (String)this.getFolderIds(folderIds, "DLFolder"));
            sql = StringUtil.replace((String)sql, (String)"[$FILE_ENTRY_FOLDER_ID$]", (String)this.getFolderIds(folderIds, "DLFileEntry"));
            sql = StringUtil.replace((String)sql, (String)"[$FILE_SHORTCUT_FOLDER_ID$]", (String)this.getFolderIds(folderIds, "DLFileShortcut"));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("modelFolderId", Type.LONG);
            q.addScalar("name", Type.STRING);
            q.addScalar("title", Type.STRING);
            q.addScalar("fileShortcutId", Type.LONG);
            q.addScalar("modelFolder", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            for (Long folderId : folderIds) {
                qPos.add(folderId);
            }
            ArrayList<Object> models = new ArrayList<Object>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                Object[] array = (Object[])itr.next();
                long folderId = (Long)array[0];
                String name = (String)array[1];
                long fileShortcutId = (Long)array[3];
                long modelFolder = (Long)array[4];
                Object obj = null;
                obj = modelFolder == 1L ? DLFolderUtil.findByPrimaryKey((long)folderId) : (fileShortcutId > 0L ? DLFileShortcutUtil.findByPrimaryKey((long)fileShortcutId) : DLFileEntryUtil.findByF_N((long)folderId, (String)name));
                models.add(obj);
            }
            ArrayList<Object> arrayList = models;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getFolderIds(List<Long> folderIds, String table) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < folderIds.size(); ++i) {
            sb.append(table);
            sb.append(".");
            if (table.equals("DLFolder")) {
                sb.append("parentFolderId");
            } else {
                sb.append("folderId");
            }
            sb.append("= ? ");
            if (i + 1 == folderIds.size()) continue;
            sb.append("OR ");
        }
        return sb.toString();
    }
}

