/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.jsp.PageContext;

public class DLUtil {
    private static final String _DEFAULT_FILE_EXTENSION = "page";
    private static Log _log = LogFactoryUtil.getLog(DLUtil.class);
    private static DLUtil _instance = new DLUtil();
    private Set<String> _fileExtensions = new HashSet<String>();

    public static String getBreadcrumbs(long folderId, String name, long rootFolderId, PageContext pageContext, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        if (folderId > 0L && Validator.isNotNull((String)name)) {
            DLFileEntry fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)folderId, (String)name);
            return DLUtil.getBreadcrumbs(fileEntry.getFolder(), fileEntry, rootFolderId, pageContext, renderRequest, renderResponse);
        }
        DLFolder folder = null;
        try {
            folder = DLFolderLocalServiceUtil.getFolder((long)folderId);
        }
        catch (Exception e) {
            // empty catch block
        }
        return DLUtil.getBreadcrumbs(folder, null, rootFolderId, pageContext, renderRequest, renderResponse);
    }

    public static String getBreadcrumbs(DLFolder folder, DLFileEntry fileEntry, long rootFolderId, PageContext pageContext, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString((PortletRequest)renderRequest, (String)"struts_action");
        long groupId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"groupId");
        if (fileEntry != null && folder == null) {
            folder = fileEntry.getFolder();
        }
        PortletURL foldersURL = renderResponse.createRenderURL();
        WindowState windowState = renderRequest.getWindowState();
        if (windowState.equals((Object)LiferayWindowState.POP_UP)) {
            foldersURL.setWindowState(LiferayWindowState.POP_UP);
            foldersURL.setParameter("struts_action", strutsAction);
            foldersURL.setParameter("groupId", String.valueOf(groupId));
        } else {
            foldersURL.setParameter("struts_action", "/document_library/view");
        }
        String foldersLink = "<a href=\"" + foldersURL.toString() + "\">" + LanguageUtil.get((PageContext)pageContext, (String)"folders") + "</a>";
        if (folder == null) {
            return "<span class=\"first last\">" + foldersLink + "</span>";
        }
        String breadcrumbs = "";
        if (folder != null) {
            int i = 0;
            while (true) {
                folder = folder.toEscapedModel();
                PortletURL portletURL = renderResponse.createRenderURL();
                if (windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    portletURL.setWindowState(LiferayWindowState.POP_UP);
                    portletURL.setParameter("struts_action", strutsAction);
                    portletURL.setParameter("groupId", String.valueOf(groupId));
                    portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
                } else {
                    portletURL.setParameter("struts_action", "/document_library/view");
                    portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
                }
                String folderLink = "<a href=\"" + portletURL.toString() + "\">" + folder.getName() + "</a>";
                breadcrumbs = i == 0 ? (fileEntry != null ? breadcrumbs + folderLink : "<span class=\"last\">" + folderLink + "</span>") : folderLink + " &raquo; " + breadcrumbs;
                if (folder.isRoot() || folder.getFolderId() == rootFolderId) break;
                folder = DLFolderLocalServiceUtil.getFolder((long)folder.getParentFolderId());
                ++i;
            }
        }
        breadcrumbs = "<span class=\"first\">" + foldersLink + " &raquo; </span>" + breadcrumbs;
        if (fileEntry != null) {
            fileEntry = fileEntry.toEscapedModel();
            PortletURL fileEntryURL = renderResponse.createRenderURL();
            fileEntryURL.setParameter("struts_action", "/document_library/edit_file_entry");
            fileEntryURL.setParameter("folderId", String.valueOf(fileEntry.getFolderId()));
            fileEntryURL.setParameter("name", fileEntry.getName());
            String fileEntryLink = "<span class=\"last\"><a href=\"" + fileEntryURL.toString() + "\">" + fileEntry.getName() + "</a></span>";
            breadcrumbs = breadcrumbs + " &raquo; " + fileEntryLink;
        }
        return breadcrumbs;
    }

    public static String getFileExtension(String name) {
        return _instance._getFileExtension(name);
    }

    public static String getLockId(long folderId, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(folderId);
        sb.append("#");
        sb.append(name);
        return sb.toString();
    }

    private DLUtil() {
        String[] fileExtensions = null;
        try {
            fileExtensions = PrefsPropsUtil.getStringArray("dl.file.extensions", ",");
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            fileExtensions = new String[]{""};
        }
        for (int i = 0; i < fileExtensions.length; ++i) {
            if ("*".equals(fileExtensions[i])) continue;
            String extension = fileExtensions[i];
            extension = extension.substring(1, extension.length());
            this._fileExtensions.add(extension);
        }
    }

    private String _getFileExtension(String name) {
        String extension = "";
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            extension = name.substring(pos + 1, name.length()).toLowerCase();
        }
        if (!this._fileExtensions.contains(extension)) {
            extension = _DEFAULT_FILE_EXTENSION;
        }
        return extension;
    }
}

