/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.artofsolving.jodconverter.DefaultDocumentFormatRegistry;
import com.artofsolving.jodconverter.DocumentConverter;
import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.DocumentFormatRegistry;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.artofsolving.jodconverter.openoffice.converter.StreamOpenOfficeDocumentConverter;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.SystemProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DocumentConversionUtil {
    private static final String[] _DEFAULT_CONVERSIONS = new String[0];
    private static final String[] _DRAWING_CONVERSIONS = new String[]{"odg"};
    private static final String _LOCALHOST = "localhost";
    private static final String _LOCALHOST_IP = "127.0.0.1";
    private static final String[] _PRESENTATION_CONVERSIONS = new String[]{"odp", "pdf", "ppt", "swf", "sxi"};
    private static final String[] _SPREADSHEET_CONVERSIONS = new String[]{"csv", "ods", "pdf", "sxc", "tsv", "xls"};
    private static final String[] _TEXT_CONVERSIONS = new String[]{"doc", "odt", "pdf", "rtf", "sxw", "txt"};
    private static DocumentConversionUtil _instance = new DocumentConversionUtil();
    private Map<String, String[]> _conversionsMap = new HashMap<String, String[]>();
    private OpenOfficeConnection _connection;
    private DocumentConverter _converter;

    public static InputStream convert(String id, InputStream is, String sourceExtension, String targetExtension) throws IOException, SystemException {
        return _instance._convert(id, is, sourceExtension, targetExtension);
    }

    public static void disconnect() {
        _instance._disconnect();
    }

    public static String[] getConversions(String extension) {
        return _instance._getConversions(extension);
    }

    public static String getTempFileId(long id, double version) {
        StringBuilder sb = new StringBuilder();
        sb.append(id);
        sb.append(".");
        sb.append(version);
        return sb.toString();
    }

    private DocumentConversionUtil() {
        this._conversionsMap.put("svg", _DRAWING_CONVERSIONS);
        this._conversionsMap.put("swf", _DRAWING_CONVERSIONS);
        this._conversionsMap.put("odp", _PRESENTATION_CONVERSIONS);
        this._conversionsMap.put("ppt", _PRESENTATION_CONVERSIONS);
        this._conversionsMap.put("sxi", _PRESENTATION_CONVERSIONS);
        this._conversionsMap.put("csv", _SPREADSHEET_CONVERSIONS);
        this._conversionsMap.put("ods", _SPREADSHEET_CONVERSIONS);
        this._conversionsMap.put("sxc", _SPREADSHEET_CONVERSIONS);
        this._conversionsMap.put("tsv", _SPREADSHEET_CONVERSIONS);
        this._conversionsMap.put("xls", _SPREADSHEET_CONVERSIONS);
        this._conversionsMap.put("doc", _TEXT_CONVERSIONS);
        this._conversionsMap.put("htm", _TEXT_CONVERSIONS);
        this._conversionsMap.put("html", _TEXT_CONVERSIONS);
        this._conversionsMap.put("odt", _TEXT_CONVERSIONS);
        this._conversionsMap.put("rtf", _TEXT_CONVERSIONS);
        this._conversionsMap.put("sxw", _TEXT_CONVERSIONS);
        this._conversionsMap.put("txt", _TEXT_CONVERSIONS);
        this._conversionsMap.put("wpd", _TEXT_CONVERSIONS);
    }

    private InputStream _convert(String id, InputStream is, String sourceExtension, String targetExtension) throws IOException, SystemException {
        if (!PrefsPropsUtil.getBoolean("openoffice.server.enabled", PropsValues.OPENOFFICE_SERVER_ENABLED)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append("/liferay/document_conversion/");
        sb.append(id);
        sb.append(".");
        sb.append(targetExtension);
        String fileName = sb.toString();
        File file = new File(fileName);
        if (!PropsValues.OPENOFFICE_CACHE_ENABLED || !file.exists()) {
            DefaultDocumentFormatRegistry registry = new DefaultDocumentFormatRegistry();
            DocumentConverter converter = this._getConverter((DocumentFormatRegistry)registry);
            if (sourceExtension.equals("htm")) {
                sourceExtension = "html";
            }
            DocumentFormat inputFormat = registry.getFormatByFileExtension(sourceExtension);
            UnsyncByteArrayOutputStream ubaos = new UnsyncByteArrayOutputStream();
            DocumentFormat outputFormat = registry.getFormatByFileExtension(targetExtension);
            converter.convert(is, inputFormat, (OutputStream)ubaos, outputFormat);
            FileUtil.write((File)file, (byte[])ubaos.toByteArray());
        }
        return new FileInputStream(file);
    }

    private void _disconnect() {
        if (this._connection != null) {
            this._connection.disconnect();
        }
    }

    private String[] _getConversions(String extension) {
        Object[] conversions = this._conversionsMap.get(extension);
        if (conversions == null) {
            conversions = _DEFAULT_CONVERSIONS;
        } else if (ArrayUtil.contains((Object[])conversions, (Object)extension)) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < conversions.length; ++i) {
                Object conversion = conversions[i];
                if (((String)conversion).equals(extension)) continue;
                list.add(conversion);
            }
            conversions = list.toArray(new String[list.size()]);
        }
        return conversions;
    }

    private DocumentConverter _getConverter(DocumentFormatRegistry registry) throws SystemException {
        if (this._connection == null || this._converter == null) {
            String host = PrefsPropsUtil.getString("openoffice.server.host");
            int port = PrefsPropsUtil.getInteger("openoffice.server.port", PropsValues.OPENOFFICE_SERVER_PORT);
            if (this._isRemoteOpenOfficeHost(host)) {
                this._connection = new SocketOpenOfficeConnection(host, port);
                this._converter = new StreamOpenOfficeDocumentConverter(this._connection);
            } else {
                this._connection = new SocketOpenOfficeConnection(port);
                this._converter = new OpenOfficeDocumentConverter(this._connection);
            }
        }
        return this._converter;
    }

    private boolean _isRemoteOpenOfficeHost(String host) {
        return Validator.isNotNull((String)host) && !host.equals(_LOCALHOST_IP) && !host.startsWith(_LOCALHOST);
    }
}

