/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.webdav;

import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.webdav.BaseResourceImpl;
import com.liferay.portal.webdav.WebDAVException;
import com.liferay.portal.webdav.WebDAVRequest;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import java.io.InputStream;

public class DLFileEntryResourceImpl
extends BaseResourceImpl {
    private WebDAVRequest _webDavRequest;
    private DLFileEntry _fileEntry;

    public DLFileEntryResourceImpl(WebDAVRequest webDavRequest, DLFileEntry fileEntry, String parentPath, String name) {
        super(parentPath, name, fileEntry.getTitleWithExtension(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getSize());
        this.setModel(fileEntry);
        this.setClassName(DLFileEntry.class.getName());
        this.setPrimaryKey(fileEntry.getPrimaryKey());
        this._webDavRequest = webDavRequest;
        this._fileEntry = fileEntry;
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isLocked() {
        try {
            return DLFileEntryServiceUtil.hasFileEntryLock((long)this._fileEntry.getFolderId(), (String)this._fileEntry.getName());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getContentType() {
        return MimeTypesUtil.getContentType((String)this._fileEntry.getName());
    }

    public InputStream getContentAsStream() throws WebDAVException {
        try {
            return DLFileEntryLocalServiceUtil.getFileAsStream((long)this._webDavRequest.getCompanyId(), (long)this._webDavRequest.getUserId(), (long)this._fileEntry.getFolderId(), (String)this._fileEntry.getName());
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }
}

