/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.webdav;

import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Lock;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.webdav.BaseResourceImpl;
import com.liferay.portal.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.webdav.LockException;
import com.liferay.portal.webdav.Resource;
import com.liferay.portal.webdav.Status;
import com.liferay.portal.webdav.WebDAVException;
import com.liferay.portal.webdav.WebDAVRequest;
import com.liferay.portal.webdav.WebDAVUtil;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderServiceUtil;
import com.liferay.portlet.documentlibrary.webdav.DLFileEntryResourceImpl;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    private static Log _log = LogFactoryUtil.getLog(DLWebDAVStorageImpl.class);

    public int copyCollectionResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite, long depth) throws WebDAVException {
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            long parentFolderId = 0L;
            try {
                parentFolderId = this.getParentFolderId(destinationArray);
            }
            catch (NoSuchFolderException nsfe) {
                return 409;
            }
            DLFolder folder = (DLFolder)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((String)destination);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            ServiceContext serviceContext = new ServiceContext();
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (!group.isUser()) {
                serviceContext.setAddCommunityPermissions(true);
            }
            serviceContext.setAddGuestPermissions(true);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name, webDavRequest.getLockUuid())) {
                status = 204;
            }
            if (depth == 0L) {
                DLFolderServiceUtil.addFolder((long)groupId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            } else {
                DLFolderServiceUtil.copyFolder((long)groupId, (long)folder.getFolderId(), (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            }
            return status;
        }
        catch (DuplicateFolderNameException dfne) {
            return 412;
        }
        catch (PrincipalException pe) {
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int copySimpleResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        File file = null;
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            long parentFolderId = 0L;
            try {
                parentFolderId = this.getParentFolderId(destinationArray);
            }
            catch (NoSuchFolderException nsfe) {
                int n = 409;
                if (file != null) {
                    file.delete();
                }
                return n;
            }
            DLFileEntry fileEntry = (DLFileEntry)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((String)destination);
            long userId = webDavRequest.getUserId();
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String title = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = fileEntry.getDescription();
            String extraSettings = fileEntry.getExtraSettings();
            file = FileUtil.createTempFile((String)FileUtil.getExtension((String)fileEntry.getName()));
            InputStream is = DLFileEntryLocalServiceUtil.getFileAsStream((long)fileEntry.getCompanyId(), (long)userId, (long)fileEntry.getFolderId(), (String)fileEntry.getName());
            FileUtil.write((File)file, (InputStream)is);
            ServiceContext serviceContext = new ServiceContext();
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (!group.isUser()) {
                serviceContext.setAddCommunityPermissions(true);
            }
            serviceContext.setAddGuestPermissions(true);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, title, webDavRequest.getLockUuid())) {
                status = 204;
            }
            DLFileEntryServiceUtil.addFileEntry((long)parentFolderId, (String)name, (String)title, (String)description, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
            int n = status;
            return n;
        }
        catch (DuplicateFolderNameException dfne) {
            int n = 412;
            return n;
        }
        catch (DuplicateFileException dfe) {
            int n = 412;
            return n;
        }
        catch (LockException le) {
            int n = 423;
            return n;
        }
        catch (PrincipalException pe) {
            int n = 403;
            return n;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public int deleteResource(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            Resource resource = this.getResource(webDavRequest);
            if (resource == null) {
                return 404;
            }
            Object model = resource.getModel();
            if (model instanceof DLFolder) {
                DLFolder folder = (DLFolder)model;
                DLFolderServiceUtil.deleteFolder((long)folder.getFolderId());
            } else {
                DLFileEntry fileEntry = (DLFileEntry)model;
                if (this.isLocked(fileEntry, webDavRequest.getLockUuid())) {
                    return 423;
                }
                DLFileEntryServiceUtil.deleteFileEntry((long)fileEntry.getFolderId(), (String)fileEntry.getName());
            }
            return 204;
        }
        catch (PrincipalException pe) {
            return 403;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public Resource getResource(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            String[] pathArray = webDavRequest.getPathArray();
            long parentFolderId = this.getParentFolderId(pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            if (Validator.isNull((String)name)) {
                String path = this.getRootPath() + webDavRequest.getPath();
                return new BaseResourceImpl(path, "", this.getToken());
            }
            try {
                DLFolder folder = DLFolderServiceUtil.getFolder((long)webDavRequest.getGroupId(), (long)parentFolderId, (String)name);
                if (folder.getParentFolderId() != parentFolderId || webDavRequest.getGroupId() != folder.getGroupId()) {
                    throw new NoSuchFolderException();
                }
                return this.toResource(webDavRequest, folder, false);
            }
            catch (NoSuchFolderException nsfe) {
                try {
                    String titleWithExtension = name;
                    DLFileEntry fileEntry = DLFileEntryServiceUtil.getFileEntryByTitle((long)parentFolderId, (String)titleWithExtension);
                    return this.toResource(webDavRequest, fileEntry, false);
                }
                catch (NoSuchFileEntryException nsfee) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public List<Resource> getResources(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            long folderId = this.getFolderId(webDavRequest.getPathArray());
            List<Resource> folders = this.getFolders(webDavRequest, folderId);
            List<Resource> fileEntries = this.getFileEntries(webDavRequest, folderId);
            ArrayList<Resource> resources = new ArrayList<Resource>(folders.size() + fileEntries.size());
            resources.addAll(folders);
            resources.addAll(fileEntries);
            return resources;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public boolean isSupportsClassTwo() {
        return true;
    }

    public Status lockResource(WebDAVRequest webDavRequest, String owner, long timeout) throws WebDAVException {
        Resource resource = this.getResource(webDavRequest);
        Lock lock = null;
        int status = 200;
        try {
            if (resource == null) {
                String name;
                status = 201;
                String[] pathArray = webDavRequest.getPathArray();
                long groupId = webDavRequest.getGroupId();
                long parentFolderId = this.getParentFolderId(pathArray);
                String title = name = WebDAVUtil.getResourceName((String[])pathArray);
                String description = "";
                String extraSettings = "";
                File file = FileUtil.createTempFile((String)FileUtil.getExtension((String)name));
                file.createNewFile();
                ServiceContext serviceContext = new ServiceContext();
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                if (!group.isUser()) {
                    serviceContext.setAddCommunityPermissions(true);
                }
                serviceContext.setAddGuestPermissions(true);
                DLFileEntry fileEntry = DLFileEntryServiceUtil.addFileEntry((long)parentFolderId, (String)name, (String)title, (String)description, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
                resource = this.toResource(webDavRequest, fileEntry, false);
            }
            if (resource instanceof DLFileEntryResourceImpl) {
                DLFileEntry fileEntry = (DLFileEntry)resource.getModel();
                lock = DLFileEntryServiceUtil.lockFileEntry((long)fileEntry.getFolderId(), (String)fileEntry.getName(), (String)owner, (long)timeout);
            } else {
                boolean inheritable = false;
                long depth = WebDAVUtil.getDepth((HttpServletRequest)webDavRequest.getHttpServletRequest());
                if (depth != 0L) {
                    inheritable = true;
                }
                DLFolder folder = (DLFolder)resource.getModel();
                lock = DLFolderServiceUtil.lockFolder((long)folder.getFolderId(), (String)owner, (boolean)inheritable, (long)timeout);
            }
        }
        catch (Exception e) {
            if (!(e instanceof DuplicateLockException)) {
                throw new WebDAVException((Throwable)e);
            }
            status = 423;
        }
        return new Status(lock, status);
    }

    public Status makeCollection(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            HttpServletRequest request = webDavRequest.getHttpServletRequest();
            if (request.getContentLength() > 0) {
                return new Status(415);
            }
            Object[] pathArray = webDavRequest.getPathArray();
            long groupId = webDavRequest.getGroupId();
            long parentFolderId = this.getParentFolderId((String[])pathArray);
            String name = WebDAVUtil.getResourceName((String[])pathArray);
            String description = "";
            ServiceContext serviceContext = new ServiceContext();
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (!group.isUser()) {
                serviceContext.setAddCommunityPermissions(true);
            }
            serviceContext.setAddGuestPermissions(true);
            DLFolderServiceUtil.addFolder((long)groupId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            String location = StringUtil.merge((Object[])pathArray, (String)"/");
            return new Status((Object)location, 201);
        }
        catch (DuplicateFolderNameException dfne) {
            return new Status(405);
        }
        catch (NoSuchFolderException nsfe) {
            return new Status(409);
        }
        catch (PrincipalException pe) {
            return new Status(403);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int moveCollectionResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            DLFolder folder = (DLFolder)resource.getModel();
            long groupId = WebDAVUtil.getGroupId((String[])destinationArray);
            long folderId = folder.getFolderId();
            long parentFolderId = this.getParentFolderId(destinationArray);
            String name = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = folder.getDescription();
            ServiceContext serviceContext = new ServiceContext();
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, name, webDavRequest.getLockUuid())) {
                status = 204;
            }
            DLFolderServiceUtil.updateFolder((long)folderId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
            return status;
        }
        catch (PrincipalException pe) {
            return 403;
        }
        catch (DuplicateFolderNameException dfne) {
            return 412;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int moveSimpleResource(WebDAVRequest webDavRequest, Resource resource, String destination, boolean overwrite) throws WebDAVException {
        try {
            String[] destinationArray = WebDAVUtil.getPathArray((String)destination, (boolean)true);
            DLFileEntry fileEntry = (DLFileEntry)resource.getModel();
            if (this.isLocked(fileEntry, webDavRequest.getLockUuid())) {
                return 423;
            }
            long groupId = WebDAVUtil.getGroupId((String[])destinationArray);
            long userId = webDavRequest.getUserId();
            long parentFolderId = this.getParentFolderId(destinationArray);
            String name = fileEntry.getName();
            String sourceFileName = null;
            String title = WebDAVUtil.getResourceName((String[])destinationArray);
            String description = fileEntry.getDescription();
            String extraSettings = fileEntry.getExtraSettings();
            byte[] bytes = null;
            String[] tagsEntries = TagsEntryLocalServiceUtil.getEntryNames((String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setTagsEntries(tagsEntries);
            int status = 201;
            if (overwrite && this.deleteResource(groupId, parentFolderId, title, webDavRequest.getLockUuid())) {
                status = 204;
            }
            if (webDavRequest.isMac()) {
                try {
                    DLFileEntry destFileEntry = DLFileEntryServiceUtil.getFileEntryByTitle((long)parentFolderId, (String)title);
                    InputStream is = DLFileEntryLocalServiceUtil.getFileAsStream((long)fileEntry.getCompanyId(), (long)userId, (long)fileEntry.getFolderId(), (String)fileEntry.getName());
                    bytes = FileUtil.getBytes((InputStream)is);
                    DLFileEntryServiceUtil.updateFileEntry((long)parentFolderId, (long)parentFolderId, (String)destFileEntry.getName(), (String)destFileEntry.getTitle(), (String)destFileEntry.getTitle(), (String)destFileEntry.getDescription(), (String)destFileEntry.getExtraSettings(), (byte[])bytes, (ServiceContext)serviceContext);
                    DLFileEntryServiceUtil.deleteFileEntry((long)fileEntry.getFolderId(), (String)fileEntry.getName());
                    return status;
                }
                catch (NoSuchFileEntryException nsfee) {
                    // empty catch block
                }
            }
            DLFileEntryServiceUtil.updateFileEntry((long)fileEntry.getFolderId(), (long)parentFolderId, (String)name, sourceFileName, (String)title, (String)description, (String)extraSettings, bytes, (ServiceContext)serviceContext);
            return status;
        }
        catch (PrincipalException pe) {
            return 403;
        }
        catch (DuplicateFileException dfe) {
            return 412;
        }
        catch (DuplicateFolderNameException dfne) {
            return 412;
        }
        catch (LockException le) {
            return 423;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int putResource(WebDAVRequest webDavRequest) throws WebDAVException {
        File file = null;
        try {
            DLFileEntry entry;
            ServiceContext serviceContext;
            String extraSettings;
            String description;
            String title;
            String name;
            long parentFolderId;
            HttpServletRequest request;
            block16: {
                request = webDavRequest.getHttpServletRequest();
                String[] pathArray = webDavRequest.getPathArray();
                long groupId = webDavRequest.getGroupId();
                parentFolderId = this.getParentFolderId(pathArray);
                title = name = WebDAVUtil.getResourceName((String[])pathArray);
                description = "";
                extraSettings = "";
                serviceContext = new ServiceContext();
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                if (!group.isUser()) {
                    serviceContext.setAddCommunityPermissions(true);
                }
                serviceContext.setAddGuestPermissions(true);
                entry = DLFileEntryServiceUtil.getFileEntryByTitle((long)parentFolderId, (String)name);
                if (!this.isLocked(entry, webDavRequest.getLockUuid())) break block16;
                int n = 423;
                return n;
            }
            try {
                name = entry.getName();
                description = entry.getDescription();
                extraSettings = entry.getExtraSettings();
                String[] tagsEntries = TagsEntryLocalServiceUtil.getEntryNames((String)DLFileEntry.class.getName(), (long)entry.getFileEntryId());
                serviceContext.setTagsEntries(tagsEntries);
                file = FileUtil.createTempFile((String)FileUtil.getExtension((String)name));
                FileUtil.write((File)file, (InputStream)request.getInputStream());
                DLFileEntryServiceUtil.updateFileEntry((long)parentFolderId, (long)parentFolderId, (String)name, (String)title, (String)title, (String)description, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
            }
            catch (NoSuchFileEntryException nsfee) {
                file = FileUtil.createTempFile((String)FileUtil.getExtension((String)name));
                FileUtil.write((File)file, (InputStream)request.getInputStream());
                DLFileEntryServiceUtil.addFileEntry((long)parentFolderId, (String)name, (String)title, (String)description, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
            }
            int n = 201;
            return n;
        }
        catch (PrincipalException pe) {
            int n = 403;
            return n;
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)pe, (Throwable)pe);
            }
            int n = 409;
            return n;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public Lock refreshResourceLock(WebDAVRequest webDavRequest, String uuid, long timeout) throws WebDAVException {
        Resource resource = this.getResource(webDavRequest);
        Lock lock = null;
        try {
            lock = resource instanceof DLFileEntryResourceImpl ? DLFileEntryServiceUtil.refreshFileEntryLock((String)uuid, (long)timeout) : DLFolderServiceUtil.refreshFolderLock((String)uuid, (long)timeout);
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
        return lock;
    }

    public boolean unlockResource(WebDAVRequest webDavRequest, String token) throws WebDAVException {
        Resource resource = this.getResource(webDavRequest);
        try {
            if (resource instanceof DLFileEntryResourceImpl) {
                DLFileEntry fileEntry = (DLFileEntry)resource.getModel();
                DLFileEntryServiceUtil.unlockFileEntry((long)fileEntry.getFolderId(), (String)fileEntry.getName(), (String)token);
            } else {
                DLFolder folder = (DLFolder)resource.getModel();
                DLFolderServiceUtil.unlockFolder((long)folder.getGroupId(), (long)folder.getParentFolderId(), (String)folder.getName(), (String)token);
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof InvalidLockException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e.getMessage());
                }
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to unlock file entry", (Throwable)e);
            }
            return false;
        }
    }

    protected boolean deleteResource(long groupId, long parentFolderId, String name, String lockUuid) throws Exception {
        try {
            DLFolder folder = DLFolderServiceUtil.getFolder((long)groupId, (long)parentFolderId, (String)name);
            DLFolderServiceUtil.deleteFolder((long)folder.getFolderId());
            return true;
        }
        catch (NoSuchFolderException nsfe) {
            try {
                DLFileEntry fileEntry = DLFileEntryServiceUtil.getFileEntryByTitle((long)parentFolderId, (String)name);
                if (this.isLocked(fileEntry, lockUuid)) {
                    throw new LockException();
                }
                DLFileEntryServiceUtil.deleteFileEntryByTitle((long)parentFolderId, (String)name);
                return true;
            }
            catch (NoSuchFileEntryException nsfee) {
                return false;
            }
        }
    }

    protected List<Resource> getFileEntries(WebDAVRequest webDavRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List fileEntries = DLFileEntryServiceUtil.getFileEntries((long)parentFolderId);
        for (DLFileEntry fileEntry : fileEntries) {
            Resource resource = this.toResource(webDavRequest, fileEntry, true);
            resources.add(resource);
        }
        return resources;
    }

    protected long getFolderId(String[] pathArray) throws Exception {
        return this.getFolderId(pathArray, false);
    }

    protected long getFolderId(String[] pathArray, boolean parent) throws Exception {
        long folderId = 0L;
        if (pathArray.length <= 2) {
            return folderId;
        }
        long groupId = WebDAVUtil.getGroupId((String[])pathArray);
        int x = pathArray.length;
        if (parent) {
            --x;
        }
        for (int i = 3; i < x; ++i) {
            String name = pathArray[i];
            DLFolder folder = DLFolderServiceUtil.getFolder((long)groupId, (long)folderId, (String)name);
            if (groupId != folder.getGroupId()) continue;
            folderId = folder.getFolderId();
        }
        return folderId;
    }

    protected List<Resource> getFolders(WebDAVRequest webDavRequest, long parentFolderId) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        long groupId = webDavRequest.getGroupId();
        List folders = DLFolderServiceUtil.getFolders((long)groupId, (long)parentFolderId);
        for (DLFolder folder : folders) {
            Resource resource = this.toResource(webDavRequest, folder, true);
            resources.add(resource);
        }
        return resources;
    }

    protected long getParentFolderId(String[] pathArray) throws Exception {
        return this.getFolderId(pathArray, true);
    }

    protected boolean isLocked(DLFileEntry fileEntry, String lockUuid) throws Exception {
        long parentFolderId = fileEntry.getFolderId();
        String fileName = fileEntry.getName();
        if (Validator.isNull((String)lockUuid)) {
            return DLFileEntryServiceUtil.hasFileEntryLock((long)parentFolderId, (String)fileName);
        }
        try {
            boolean verified = DLFileEntryServiceUtil.verifyFileEntryLock((long)parentFolderId, (String)fileName, (String)lockUuid);
            return !verified;
        }
        catch (NoSuchLockException nsle) {
            return false;
        }
    }

    protected Resource toResource(WebDAVRequest webDavRequest, DLFileEntry fileEntry, boolean appendPath) {
        String parentPath = this.getRootPath() + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = fileEntry.getTitleWithExtension();
        }
        return new DLFileEntryResourceImpl(webDavRequest, fileEntry, parentPath, name);
    }

    protected Resource toResource(WebDAVRequest webDavRequest, DLFolder folder, boolean appendPath) {
        String parentPath = this.getRootPath() + webDavRequest.getPath();
        String name = "";
        if (appendPath) {
            name = folder.getName();
        }
        BaseResourceImpl resource = new BaseResourceImpl(parentPath, name, folder.getName(), folder.getCreateDate(), folder.getModifiedDate());
        resource.setModel((Object)folder);
        resource.setClassName(DLFolder.class.getName());
        resource.setPrimaryKey(folder.getPrimaryKey());
        return resource;
    }
}

