/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.action;

import com.liferay.portal.AccountNameException;
import com.liferay.portal.AddressCityException;
import com.liferay.portal.AddressStreetException;
import com.liferay.portal.AddressZipException;
import com.liferay.portal.CompanyMxException;
import com.liferay.portal.CompanyVirtualHostException;
import com.liferay.portal.CompanyWebIdException;
import com.liferay.portal.EmailAddressException;
import com.liferay.portal.NoSuchCountryException;
import com.liferay.portal.NoSuchListTypeException;
import com.liferay.portal.NoSuchRegionException;
import com.liferay.portal.PhoneNumberException;
import com.liferay.portal.WebsiteURLException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.CompanyServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class EditCompanyAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateCompany(actionRequest);
                this.updateDisplay(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.enterprise_admin.error");
            }
            if (e instanceof AddressCityException || e instanceof AccountNameException || e instanceof AddressStreetException || e instanceof AddressZipException || e instanceof CompanyMxException || e instanceof CompanyVirtualHostException || e instanceof CompanyWebIdException || e instanceof EmailAddressException || e instanceof NoSuchCountryException || e instanceof NoSuchListTypeException || e instanceof NoSuchRegionException || e instanceof PhoneNumberException || e instanceof WebsiteURLException) {
                if (e instanceof NoSuchListTypeException) {
                    NoSuchListTypeException nslte = (NoSuchListTypeException)((Object)e);
                    SessionErrors.add((PortletRequest)actionRequest, (String)(e.getClass().getName() + nslte.getType()));
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
                }
                this.setForward((PortletRequest)actionRequest, "portlet.enterprise_admin.view");
            }
            throw e;
        }
    }

    protected void updateCompany(ActionRequest actionRequest) throws Exception {
        long companyId = PortalUtil.getCompanyId((PortletRequest)actionRequest);
        String virtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"virtualHost");
        String mx = ParamUtil.getString((PortletRequest)actionRequest, (String)"mx");
        String homeURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"homeURL");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String legalName = ParamUtil.getString((PortletRequest)actionRequest, (String)"legalName");
        String legalId = ParamUtil.getString((PortletRequest)actionRequest, (String)"legalId");
        String legalType = ParamUtil.getString((PortletRequest)actionRequest, (String)"legalType");
        String sicCode = ParamUtil.getString((PortletRequest)actionRequest, (String)"sicCode");
        String tickerSymbol = ParamUtil.getString((PortletRequest)actionRequest, (String)"tickerSymbol");
        String industry = ParamUtil.getString((PortletRequest)actionRequest, (String)"industry");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        String size = ParamUtil.getString((PortletRequest)actionRequest, (String)"size");
        String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
        String timeZoneId = ParamUtil.getString((PortletRequest)actionRequest, (String)"timeZoneId");
        List<Address> addresses = EnterpriseAdminUtil.getAddresses(actionRequest);
        List<EmailAddress> emailAddresses = EnterpriseAdminUtil.getEmailAddresses(actionRequest);
        List<Phone> phones = EnterpriseAdminUtil.getPhones(actionRequest);
        List<Website> websites = EnterpriseAdminUtil.getWebsites(actionRequest);
        UnicodeProperties properties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"settings(");
        CompanyServiceUtil.updateCompany((long)companyId, (String)virtualHost, (String)mx, (String)homeURL, (String)name, (String)legalName, (String)legalId, (String)legalType, (String)sicCode, (String)tickerSymbol, (String)industry, (String)type, (String)size, (String)languageId, (String)timeZoneId, addresses, emailAddresses, phones, websites, (UnicodeProperties)properties);
    }

    protected void updateDisplay(ActionRequest actionRequest) throws Exception {
        Company company = PortalUtil.getCompany((PortletRequest)actionRequest);
        String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
        String timeZoneId = ParamUtil.getString((PortletRequest)actionRequest, (String)"timeZoneId");
        CompanyServiceUtil.updateDisplay((long)company.getCompanyId(), (String)languageId, (String)timeZoneId);
        boolean communityLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"settings(company.security.community.logo)");
        CompanyServiceUtil.updateSecurity((long)company.getCompanyId(), (String)company.getAuthType(), (boolean)company.isAutoLogin(), (boolean)company.isSendPassword(), (boolean)company.isStrangers(), (boolean)company.isStrangersWithMx(), (boolean)company.isStrangersVerify(), (boolean)communityLogo);
        boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
        if (deleteLogo) {
            CompanyServiceUtil.deleteLogo((long)company.getCompanyId());
        }
    }
}

