/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.action;

import com.liferay.portal.DuplicateRoleException;
import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.RequiredRoleException;
import com.liferay.portal.RoleNameException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.RoleServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.enterpriseadmin.action.ActionUtil;
import com.liferay.util.LocalizationUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditRoleAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateRole(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteRole(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.enterprise_admin.error");
            }
            if (e instanceof DuplicateRoleException || e instanceof NoSuchRoleException || e instanceof RequiredRoleException || e instanceof RoleNameException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                if (cmd.equals("delete")) {
                    actionResponse.sendRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                }
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getRole(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchRoleException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.enterprise_admin.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.enterprise_admin.edit_role"));
    }

    protected void deleteRole(ActionRequest actionRequest) throws Exception {
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        RoleServiceUtil.deleteRole((long)roleId);
    }

    protected void updateRole(ActionRequest actionRequest) throws Exception {
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        Map localeTitlesMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type", (int)1);
        String subtype = ParamUtil.getString((PortletRequest)actionRequest, (String)"subtype");
        if (roleId <= 0L) {
            RoleServiceUtil.addRole((String)name, (String)description, (int)type);
        } else {
            RoleServiceUtil.updateRole((long)roleId, (String)name, (Map)localeTitlesMap, (String)description, (String)subtype);
        }
    }
}

