/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.action;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.RolePermissionsException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.security.permission.comparator.ActionComparator;
import com.liferay.portal.service.PermissionServiceUtil;
import com.liferay.portal.service.ResourcePermissionServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.enterpriseadmin.action.ActionUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditRolePermissionsAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("actions")) {
                this.updateActions(actionRequest, actionResponse);
            } else if (cmd.equals("delete_permission")) {
                this.deletePermission(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchRoleException || e instanceof PrincipalException || e instanceof RolePermissionsException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.enterprise_admin.error");
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getRole(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchRoleException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.enterprise_admin.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.enterprise_admin.edit_role_permissions"));
    }

    protected void deletePermission(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        long permissionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"permissionId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        int scope = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"scope");
        String primKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"primKey");
        String actionId = ParamUtil.getString((PortletRequest)actionRequest, (String)"actionId");
        Role role = RoleLocalServiceUtil.getRole((long)roleId);
        if (role.getName().equals("Administrator") || role.getName().equals("Owner") || role.getName().equals("Community Administrator") || role.getName().equals("Community Owner") || role.getName().equals("Organization Administrator") || role.getName().equals("Organization Owner")) {
            throw new RolePermissionsException(role.getName());
        }
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            ResourcePermissionServiceUtil.removeResourcePermission((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getCompanyId(), (String)name, (int)scope, (String)primKey, (long)roleId, (String)actionId);
        } else {
            PermissionServiceUtil.unsetRolePermission((long)roleId, (long)themeDisplay.getScopeGroupId(), (long)permissionId);
        }
        SessionMessages.add((PortletRequest)actionRequest, (String)"permissionDeleted");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        actionResponse.sendRedirect(redirect);
    }

    protected void updateAction_1to5(ActionRequest actionRequest, Role role, long groupId, String selResource, String actionId) throws Exception {
        long roleId = role.getRoleId();
        int scope = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("scope" + selResource + actionId));
        if (scope == 1) {
            PermissionServiceUtil.setRolePermission((long)roleId, (long)groupId, (String)selResource, (int)scope, (String)String.valueOf(role.getCompanyId()), (String)actionId);
        } else if (scope == 2) {
            if (role.getType() == 2 || role.getType() == 3) {
                PermissionServiceUtil.setRolePermission((long)roleId, (long)groupId, (String)selResource, (int)3, (String)String.valueOf(0L), (String)actionId);
            } else {
                String[] groupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("groupIds" + selResource + actionId)));
                if (groupIds.length == 0) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)"missingGroupIdsForAction");
                    return;
                }
                groupIds = ArrayUtil.distinct((String[])groupIds);
                PermissionServiceUtil.unsetRolePermissions((long)roleId, (long)groupId, (String)selResource, (int)2, (String)actionId);
                for (String curGroupId : groupIds) {
                    PermissionServiceUtil.setRolePermission((long)roleId, (long)groupId, (String)selResource, (int)2, (String)curGroupId, (String)actionId);
                }
            }
        } else {
            PermissionServiceUtil.unsetRolePermissions((long)roleId, (long)groupId, (String)selResource, (int)1, (String)actionId);
            PermissionServiceUtil.unsetRolePermissions((long)roleId, (long)groupId, (String)selResource, (int)3, (String)actionId);
            PermissionServiceUtil.unsetRolePermissions((long)roleId, (long)groupId, (String)selResource, (int)2, (String)actionId);
        }
    }

    protected void updateAction_6(ActionRequest actionRequest, Role role, long groupId, String selResource, String actionId) throws Exception {
        long companyId = role.getCompanyId();
        long roleId = role.getRoleId();
        int scope = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("scope" + selResource + actionId));
        if (scope == 1) {
            ResourcePermissionServiceUtil.addResourcePermission((long)groupId, (long)companyId, (String)selResource, (int)scope, (String)String.valueOf(role.getCompanyId()), (long)roleId, (String)actionId);
        } else if (scope == 2) {
            if (role.getType() == 2 || role.getType() == 3) {
                ResourcePermissionServiceUtil.addResourcePermission((long)groupId, (long)companyId, (String)selResource, (int)3, (String)String.valueOf(0L), (long)roleId, (String)actionId);
            } else {
                String[] groupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("groupIds" + selResource + actionId)));
                if (groupIds.length == 0) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)"missingGroupIdsForAction");
                    return;
                }
                groupIds = ArrayUtil.distinct((String[])groupIds);
                ResourcePermissionServiceUtil.removeResourcePermissions((long)groupId, (long)companyId, (String)selResource, (int)2, (long)roleId, (String)actionId);
                for (String curGroupId : groupIds) {
                    ResourcePermissionServiceUtil.addResourcePermission((long)groupId, (long)companyId, (String)selResource, (int)2, (String)curGroupId, (long)roleId, (String)actionId);
                }
            }
        } else {
            ResourcePermissionServiceUtil.removeResourcePermissions((long)groupId, (long)companyId, (String)selResource, (int)1, (long)roleId, (String)actionId);
            ResourcePermissionServiceUtil.removeResourcePermissions((long)groupId, (long)companyId, (String)selResource, (int)3, (long)roleId, (String)actionId);
            ResourcePermissionServiceUtil.removeResourcePermissions((long)groupId, (long)companyId, (String)selResource, (int)2, (long)roleId, (String)actionId);
        }
    }

    protected void updateActions(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        Role role = RoleLocalServiceUtil.getRole((long)roleId);
        if (role.getName().equals("Administrator") || role.getName().equals("Owner") || role.getName().equals("Community Administrator") || role.getName().equals("Community Owner") || role.getName().equals("Organization Administrator") || role.getName().equals("Organization Owner")) {
            throw new RolePermissionsException(role.getName());
        }
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        String[] modelResources = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"modelResources"));
        HashMap<String, List<String>> resourceActionsMap = new HashMap<String, List<String>>();
        if (Validator.isNotNull((String)portletResource)) {
            resourceActionsMap.put(portletResource, ResourceActionsUtil.getResourceActions(portletResource, null));
        }
        for (String modelResource : modelResources) {
            resourceActionsMap.put(modelResource, ResourceActionsUtil.getResourceActions(null, modelResource));
        }
        for (Map.Entry entry : resourceActionsMap.entrySet()) {
            String selResource = (String)entry.getKey();
            List actions = (List)entry.getValue();
            actions = ListUtil.sort((List)actions, (Comparator)new ActionComparator(themeDisplay.getLocale()));
            for (String actionId : actions) {
                if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                    this.updateAction_6(actionRequest, role, themeDisplay.getScopeGroupId(), selResource, actionId);
                    continue;
                }
                this.updateAction_1to5(actionRequest, role, themeDisplay.getScopeGroupId(), selResource, actionId);
            }
        }
        SessionMessages.add((PortletRequest)actionRequest, (String)"permissionsUpdated");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect") + "&" + "cmd" + "=" + "view";
        actionResponse.sendRedirect(redirect);
    }
}

