/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.action;

import com.liferay.portal.AddressCityException;
import com.liferay.portal.AddressStreetException;
import com.liferay.portal.AddressZipException;
import com.liferay.portal.ContactFirstNameException;
import com.liferay.portal.ContactFullNameException;
import com.liferay.portal.ContactLastNameException;
import com.liferay.portal.DuplicateUserEmailAddressException;
import com.liferay.portal.DuplicateUserScreenNameException;
import com.liferay.portal.EmailAddressException;
import com.liferay.portal.NoSuchCountryException;
import com.liferay.portal.NoSuchListTypeException;
import com.liferay.portal.NoSuchRegionException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.PhoneNumberException;
import com.liferay.portal.RequiredUserException;
import com.liferay.portal.ReservedUserEmailAddressException;
import com.liferay.portal.ReservedUserScreenNameException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserIdException;
import com.liferay.portal.UserPasswordException;
import com.liferay.portal.UserReminderQueryException;
import com.liferay.portal.UserScreenNameException;
import com.liferay.portal.UserSmsException;
import com.liferay.portal.WebsiteURLException;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.InvokerPortletImpl;
import com.liferay.portlet.admin.util.AdminUtil;
import com.liferay.portlet.announcements.model.AnnouncementsDelivery;
import com.liferay.portlet.announcements.model.impl.AnnouncementsDeliveryImpl;
import com.liferay.portlet.announcements.model.impl.AnnouncementsEntryImpl;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditUserAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            User user = null;
            String oldScreenName = "";
            if (cmd.equals("add")) {
                user = this.addUser(actionRequest);
            } else if (cmd.equals("deactivate") || cmd.equals("delete") || cmd.equals("restore")) {
                this.deleteUsers(actionRequest);
            } else if (cmd.equals("deleteRole")) {
                this.deleteRole(actionRequest);
            } else if (cmd.equals("update")) {
                Object[] returnValue = this.updateUser(actionRequest);
                user = (User)returnValue[0];
                oldScreenName = (String)returnValue[1];
            } else if (cmd.equals("unlock")) {
                user = this.updateLockout(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (user != null) {
                if (Validator.isNotNull((String)oldScreenName)) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
                    Group group = user.getGroup();
                    if (group.getGroupId() == themeDisplay.getScopeGroupId()) {
                        Layout layout = themeDisplay.getLayout();
                        String friendlyURLPath = group.getPathFriendlyURL(layout.isPrivateLayout(), themeDisplay);
                        String oldPath = friendlyURLPath + "/" + oldScreenName;
                        String newPath = friendlyURLPath + "/" + user.getScreenName();
                        redirect = StringUtil.replace((String)redirect, (String)oldPath, (String)newPath);
                        redirect = StringUtil.replace((String)redirect, (String)HttpUtil.encodeURL((String)oldPath), (String)HttpUtil.encodeURL((String)newPath));
                    }
                }
                redirect = HttpUtil.setParameter((String)redirect, (String)(actionResponse.getNamespace() + "p_u_i_d"), (long)user.getUserId());
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            if (e instanceof NoSuchUserException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.enterprise_admin.error");
            }
            if (e instanceof AddressCityException || e instanceof AddressStreetException || e instanceof AddressZipException || e instanceof ContactFirstNameException || e instanceof ContactFullNameException || e instanceof ContactLastNameException || e instanceof DuplicateUserEmailAddressException || e instanceof DuplicateUserScreenNameException || e instanceof EmailAddressException || e instanceof NoSuchCountryException || e instanceof NoSuchListTypeException || e instanceof NoSuchRegionException || e instanceof PhoneNumberException || e instanceof RequiredUserException || e instanceof ReservedUserEmailAddressException || e instanceof ReservedUserScreenNameException || e instanceof UserEmailAddressException || e instanceof UserIdException || e instanceof UserPasswordException || e instanceof UserReminderQueryException || e instanceof UserScreenNameException || e instanceof UserSmsException || e instanceof WebsiteURLException) {
                if (e instanceof NoSuchListTypeException) {
                    NoSuchListTypeException nslte = (NoSuchListTypeException)((Object)e);
                    SessionErrors.add((PortletRequest)actionRequest, (String)(e.getClass().getName() + nslte.getType()));
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
                }
                if (e instanceof RequiredUserException) {
                    actionResponse.sendRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                }
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            PortalUtil.getSelectedUser((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.enterprise_admin.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.enterprise_admin.edit_user"));
    }

    protected User addUser(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        boolean autoPassword = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"autoPassword", (boolean)true);
        String password1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"password1");
        String password2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"password2");
        String reminderQueryQuestion = ParamUtil.getString((PortletRequest)actionRequest, (String)"reminderQueryQuestion");
        if (reminderQueryQuestion.equals("write-my-own-question")) {
            reminderQueryQuestion = ParamUtil.getString((PortletRequest)actionRequest, (String)"reminderQueryCustomQuestion");
        }
        String reminderQueryAnswer = ParamUtil.getString((PortletRequest)actionRequest, (String)"reminderQueryAnswer");
        boolean autoScreenName = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"autoScreenName");
        String screenName = ParamUtil.getString((PortletRequest)actionRequest, (String)"screenName");
        String emailAddress = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddress");
        String openId = ParamUtil.getString((PortletRequest)actionRequest, (String)"openId");
        String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
        String timeZoneId = ParamUtil.getString((PortletRequest)actionRequest, (String)"timeZoneId");
        String greeting = ParamUtil.getString((PortletRequest)actionRequest, (String)"greeting");
        String firstName = ParamUtil.getString((PortletRequest)actionRequest, (String)"firstName");
        String middleName = ParamUtil.getString((PortletRequest)actionRequest, (String)"middleName");
        String lastName = ParamUtil.getString((PortletRequest)actionRequest, (String)"lastName");
        int prefixId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"prefixId");
        int suffixId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"suffixId");
        boolean male = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"male", (boolean)true);
        int birthdayMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayMonth");
        int birthdayDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayDay");
        int birthdayYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayYear");
        String comments = ParamUtil.getString((PortletRequest)actionRequest, (String)"comments");
        String smsSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"smsSn");
        String aimSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"aimSn");
        String facebookSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"facebookSn");
        String icqSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"icqSn");
        String jabberSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"jabberSn");
        String msnSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"msnSn");
        String mySpaceSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"mySpaceSn");
        String skypeSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"skypeSn");
        String twitterSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"twitterSn");
        String ymSn = ParamUtil.getString((PortletRequest)actionRequest, (String)"ymSn");
        String jobTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"jobTitle");
        long[] groupIds = this.getLongArray((PortletRequest)actionRequest, "groupsSearchContainerPrimaryKeys");
        long[] organizationIds = this.getLongArray((PortletRequest)actionRequest, "organizationsSearchContainerPrimaryKeys");
        long[] roleIds = this.getLongArray((PortletRequest)actionRequest, "rolesSearchContainerPrimaryKeys");
        List<UserGroupRole> userGroupRoles = EnterpriseAdminUtil.getUserGroupRoles((PortletRequest)actionRequest);
        long[] userGroupIds = this.getLongArray((PortletRequest)actionRequest, "userGroupsSearchContainerPrimaryKeys");
        boolean sendEmail = true;
        List<Address> addresses = EnterpriseAdminUtil.getAddresses(actionRequest);
        List<EmailAddress> emailAddresses = EnterpriseAdminUtil.getEmailAddresses(actionRequest);
        List<Phone> phones = EnterpriseAdminUtil.getPhones(actionRequest);
        List<Website> websites = EnterpriseAdminUtil.getWebsites(actionRequest);
        List<AnnouncementsDelivery> announcementsDeliveries = this.getAnnouncementsDeliveries(actionRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        User user = null;
        user = UserServiceUtil.addUser((long)themeDisplay.getCompanyId(), (boolean)autoPassword, (String)password1, (String)password2, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (String)openId, (Locale)LocaleUtil.getDefault(), (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, (long[])groupIds, (long[])organizationIds, (long[])roleIds, (long[])userGroupIds, (boolean)sendEmail, addresses, emailAddresses, phones, websites, announcementsDeliveries, (ServiceContext)serviceContext);
        if (!userGroupRoles.isEmpty()) {
            for (UserGroupRole userGroupRole : userGroupRoles) {
                userGroupRole.setUserId(user.getUserId());
            }
            user = UserServiceUtil.updateUser((long)user.getUserId(), (String)"", (String)"", (String)"", (boolean)false, (String)reminderQueryQuestion, (String)reminderQueryAnswer, (String)screenName, (String)emailAddress, (String)openId, (String)languageId, (String)timeZoneId, (String)greeting, (String)comments, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)smsSn, (String)aimSn, (String)facebookSn, (String)icqSn, (String)jabberSn, (String)msnSn, (String)mySpaceSn, (String)skypeSn, (String)twitterSn, (String)ymSn, (String)jobTitle, (long[])groupIds, (long[])organizationIds, (long[])roleIds, userGroupRoles, (long[])userGroupIds, addresses, emailAddresses, phones, websites, announcementsDeliveries, (ServiceContext)serviceContext);
        }
        return user;
    }

    protected void deleteRole(ActionRequest actionRequest) throws Exception {
        User user = PortalUtil.getSelectedUser((PortletRequest)actionRequest);
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleId");
        UserServiceUtil.deleteRoleUser((long)roleId, (long)user.getUserId());
    }

    protected void deleteUsers(ActionRequest actionRequest) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long[] deleteUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteUserIds"), (long)0L);
        for (int i = 0; i < deleteUserIds.length; ++i) {
            if (cmd.equals("deactivate") || cmd.equals("restore")) {
                boolean active = !cmd.equals("deactivate");
                UserServiceUtil.updateActive((long)deleteUserIds[i], (boolean)active);
                continue;
            }
            UserServiceUtil.deleteUser((long)deleteUserIds[i]);
        }
    }

    protected List<AnnouncementsDelivery> getAnnouncementsDeliveries(ActionRequest actionRequest) {
        ArrayList<AnnouncementsDelivery> announcementsDeliveries = new ArrayList<AnnouncementsDelivery>();
        for (String type : AnnouncementsEntryImpl.TYPES) {
            boolean email = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("announcementsType" + type + "Email"));
            boolean sms = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("announcementsType" + type + "Sms"));
            boolean website = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("announcementsType" + type + "Website"));
            AnnouncementsDeliveryImpl announcementsDelivery = new AnnouncementsDeliveryImpl();
            announcementsDelivery.setType(type);
            announcementsDelivery.setEmail(email);
            announcementsDelivery.setSms(sms);
            announcementsDelivery.setWebsite(website);
            announcementsDeliveries.add(announcementsDelivery);
        }
        return announcementsDeliveries;
    }

    protected long[] getLongArray(PortletRequest portletRequest, String name) {
        String value = portletRequest.getParameter(name);
        if (value == null) {
            return null;
        }
        return StringUtil.split((String)GetterUtil.getString((String)value), (long)0L);
    }

    protected User updateLockout(ActionRequest actionRequest) throws Exception {
        User user = PortalUtil.getSelectedUser((PortletRequest)actionRequest);
        UserServiceUtil.updateLockout((long)user.getUserId(), (boolean)false);
        return user;
    }

    protected Object[] updateUser(ActionRequest actionRequest) throws Exception {
        boolean deletePortrait;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        User user = PortalUtil.getSelectedUser((PortletRequest)actionRequest);
        Contact contact = user.getContact();
        String oldPassword = AdminUtil.getUpdateUserPassword(actionRequest, user.getUserId());
        String newPassword1 = ParamUtil.getString((PortletRequest)actionRequest, (String)"password1");
        String newPassword2 = ParamUtil.getString((PortletRequest)actionRequest, (String)"password2");
        boolean passwordReset = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"passwordReset");
        String reminderQueryQuestion = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"reminderQueryQuestion");
        if (reminderQueryQuestion.equals("write-my-own-question")) {
            reminderQueryQuestion = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"reminderQueryCustomQuestion");
        }
        String reminderQueryAnswer = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"reminderQueryAnswer");
        String oldScreenName = user.getScreenName();
        String screenName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"screenName");
        String emailAddress = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"emailAddress");
        String openId = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"openId");
        String languageId = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"languageId");
        String timeZoneId = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"timeZoneId");
        String greeting = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"greeting");
        String firstName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"firstName");
        String middleName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"middleName");
        String lastName = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"lastName");
        int prefixId = BeanParamUtil.getInteger((Object)user, (PortletRequest)actionRequest, (String)"prefixId");
        int suffixId = BeanParamUtil.getInteger((Object)user, (PortletRequest)actionRequest, (String)"suffixId");
        boolean male = BeanParamUtil.getBoolean((Object)user, (PortletRequest)actionRequest, (String)"male", (boolean)true);
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(contact.getBirthday());
        int birthdayMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayMonth", (int)birthdayCal.get(2));
        int birthdayDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayDay", (int)birthdayCal.get(5));
        int birthdayYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"birthdayYear", (int)birthdayCal.get(1));
        String comments = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"comments");
        String smsSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"smsSn");
        String aimSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"aimSn");
        String facebookSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"facebookSn");
        String icqSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"icqSn");
        String jabberSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"jabberSn");
        String msnSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"msnSn");
        String mySpaceSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"mySpaceSn");
        String skypeSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"skypeSn");
        String twitterSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"twitterSn");
        String ymSn = BeanParamUtil.getString((Object)contact, (PortletRequest)actionRequest, (String)"ymSn");
        String jobTitle = BeanParamUtil.getString((Object)user, (PortletRequest)actionRequest, (String)"jobTitle");
        long[] groupIds = this.getLongArray((PortletRequest)actionRequest, "groupsSearchContainerPrimaryKeys");
        long[] organizationIds = this.getLongArray((PortletRequest)actionRequest, "organizationsSearchContainerPrimaryKeys");
        long[] roleIds = this.getLongArray((PortletRequest)actionRequest, "rolesSearchContainerPrimaryKeys");
        List<UserGroupRole> userGroupRoles = EnterpriseAdminUtil.getUserGroupRoles((PortletRequest)actionRequest);
        long[] userGroupIds = this.getLongArray((PortletRequest)actionRequest, "userGroupsSearchContainerPrimaryKeys");
        List<Address> addresses = EnterpriseAdminUtil.getAddresses(actionRequest);
        List<EmailAddress> emailAddresses = EnterpriseAdminUtil.getEmailAddresses(actionRequest);
        List<Phone> phones = EnterpriseAdminUtil.getPhones(actionRequest);
        List<Website> websites = EnterpriseAdminUtil.getWebsites(actionRequest);
        List<AnnouncementsDelivery> announcementsDeliveries = this.getAnnouncementsDeliveries(actionRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)User.class.getName(), (PortletRequest)actionRequest);
        user = UserServiceUtil.updateUser((long)user.getUserId(), (String)oldPassword, (String)newPassword1, (String)newPassword2, (boolean)passwordReset, (String)reminderQueryQuestion, (String)reminderQueryAnswer, (String)screenName, (String)emailAddress, (String)openId, (String)languageId, (String)timeZoneId, (String)greeting, (String)comments, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)smsSn, (String)aimSn, (String)facebookSn, (String)icqSn, (String)jabberSn, (String)msnSn, (String)mySpaceSn, (String)skypeSn, (String)twitterSn, (String)ymSn, (String)jobTitle, (long[])groupIds, (long[])organizationIds, (long[])roleIds, userGroupRoles, (long[])userGroupIds, addresses, emailAddresses, phones, websites, announcementsDeliveries, (ServiceContext)serviceContext);
        if (oldScreenName.equals(user.getScreenName())) {
            oldScreenName = "";
        }
        if (deletePortrait = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deletePortrait")) {
            UserServiceUtil.deletePortrait((long)user.getUserId());
        }
        if (user.getUserId() == themeDisplay.getUserId()) {
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            HttpSession session = request.getSession();
            session.removeAttribute("org.apache.struts.action.LOCALE");
            PortletSession portletSession = actionRequest.getPortletSession();
            InvokerPortletImpl.clearResponses(portletSession);
            if (Validator.isNotNull((String)newPassword1)) {
                portletSession.setAttribute("USER_PASSWORD", (Object)newPassword1, 1);
            }
        }
        return new Object[]{user, oldScreenName};
    }
}

