/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.action;

import com.liferay.portal.DuplicateUserGroupException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.RequiredUserGroupException;
import com.liferay.portal.UserGroupNameException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.UserGroupServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.enterpriseadmin.action.ActionUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditUserGroupAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateUserGroup(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteUserGroups(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.enterprise_admin.error");
            }
            if (e instanceof DuplicateUserGroupException || e instanceof NoSuchUserGroupException || e instanceof RequiredUserGroupException || e instanceof UserGroupNameException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                if (cmd.equals("delete")) {
                    actionResponse.sendRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                }
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getUserGroup(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchUserGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.enterprise_admin.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.enterprise_admin.edit_user_group"));
    }

    protected void deleteUserGroups(ActionRequest actionRequest) throws Exception {
        long[] deleteUserGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteUserGroupIds"), (long)0L);
        for (int i = 0; i < deleteUserGroupIds.length; ++i) {
            UserGroupServiceUtil.deleteUserGroup((long)deleteUserGroupIds[i]);
        }
    }

    protected void updateUserGroup(ActionRequest actionRequest) throws Exception {
        long userGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userGroupId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        if (userGroupId <= 0L) {
            UserGroupServiceUtil.addUserGroup((String)name, (String)description);
        } else {
            UserGroupServiceUtil.updateUserGroup((long)userGroupId, (String)name, (String)description);
        }
    }
}

