/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.action;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.model.User;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ExportUsersAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String csv = this.getUsersCSV(request);
            String fileName = "users.csv";
            byte[] bytes = csv.getBytes();
            ServletResponseUtil.sendFile((HttpServletResponse)response, (String)fileName, (byte[])bytes, (String)"text/csv; charset=UTF-8");
            return null;
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected String getUsersCSV(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (!RoleLocalServiceUtil.hasUserRole((long)themeDisplay.getUserId(), (long)themeDisplay.getCompanyId(), (String)"Administrator", (boolean)true)) {
            return "";
        }
        String exportProgressId = ParamUtil.getString((HttpServletRequest)request, (String)"exportProgressId");
        ProgressTracker progressTracker = new ProgressTracker(request, exportProgressId);
        progressTracker.start();
        List users = UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), null, (Boolean)Boolean.TRUE, null, (int)-1, (int)-1, (OrderByComparator)null);
        int percentage = 10;
        int total = users.size();
        progressTracker.updateProgress(percentage);
        StringBuilder sb = new StringBuilder(users.size() * 50);
        Iterator itr = users.iterator();
        int i = 0;
        while (itr.hasNext()) {
            User user = (User)itr.next();
            sb.append(user.getFullName());
            sb.append(",");
            sb.append(user.getEmailAddress());
            sb.append("\n");
            percentage = Math.min(10 + i * 90 / total, 99);
            progressTracker.updateProgress(percentage);
            ++i;
        }
        progressTracker.finish();
        return sb.toString();
    }
}

