/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.enterpriseadmin.search.GroupDisplayTerms;
import com.liferay.portlet.enterpriseadmin.search.GroupSearchTerms;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupSearch
extends SearchContainer<Group> {
    static List<String> headerNames = new ArrayList<String>();
    static Map<String, String> orderableHeaders = new HashMap<String, String>();
    public static final String EMPTY_RESULTS_MESSAGE = "no-communities-were-found";
    private static Log _log;

    public GroupSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new GroupDisplayTerms(portletRequest), (DisplayTerms)new GroupSearchTerms(portletRequest), "cur", 20, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        GroupDisplayTerms displayTerms = (GroupDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("name", displayTerms.getName());
        iteratorURL.setParameter("description", displayTerms.getDescription());
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue("79", "groups-order-by-col", orderByCol);
                preferences.setValue("79", "groups-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue("79", "groups-order-by-col", "name");
                orderByType = preferences.getValue("79", "groups-order-by-type", "asc");
            }
            OrderByComparator orderByComparator = EnterpriseAdminUtil.getGroupOrderByComparator(orderByCol, orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }

    static {
        headerNames.add("name");
        headerNames.add("type");
        orderableHeaders.put("name", "name");
        orderableHeaders.put("type", "type");
        _log = LogFactoryUtil.getLog(GroupSearch.class);
    }
}

