/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Role;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.enterpriseadmin.search.RoleDisplayTerms;
import com.liferay.portlet.enterpriseadmin.search.RoleSearchTerms;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleSearch
extends SearchContainer<Role> {
    static List<String> headerNames = new ArrayList<String>();
    static Map<String, String> orderableHeaders = new HashMap<String, String>();
    public static final String EMPTY_RESULTS_MESSAGE = "no-roles-were-found";
    private static Log _log;

    public RoleSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new RoleDisplayTerms(portletRequest), (DisplayTerms)new RoleSearchTerms(portletRequest), "cur", 20, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        RoleDisplayTerms displayTerms = (RoleDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("name", displayTerms.getName());
        iteratorURL.setParameter("description", displayTerms.getDescription());
        iteratorURL.setParameter("type", String.valueOf(displayTerms.getType()));
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue("79", "roles-order-by-col", orderByCol);
                preferences.setValue("79", "roles-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue("79", "roles-order-by-col", "name");
                orderByType = preferences.getValue("79", "roles-order-by-type", "asc");
            }
            OrderByComparator orderByComparator = EnterpriseAdminUtil.getRoleOrderByComparator(orderByCol, orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }

    static {
        headerNames.add("name");
        headerNames.add("type");
        if (PropsValues.ROLES_COMMUNITY_SUBTYPES.length > 0 || PropsValues.ROLES_ORGANIZATION_SUBTYPES.length > 0 || PropsValues.ROLES_REGULAR_SUBTYPES.length > 0) {
            headerNames.add("subtype");
        }
        headerNames.add("description");
        orderableHeaders.put("name", "name");
        orderableHeaders.put("type", "type");
        orderableHeaders.put("description", "description");
        _log = LogFactoryUtil.getLog(RoleSearch.class);
    }
}

