/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.enterpriseadmin.search.UserDisplayTerms;
import com.liferay.portlet.enterpriseadmin.search.UserSearchTerms;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSearch
extends SearchContainer<User> {
    static List<String> headerNames = new ArrayList<String>();
    static Map<String, String> orderableHeaders = new HashMap<String, String>();
    public static final String EMPTY_RESULTS_MESSAGE = "no-users-were-found";
    private static Log _log;

    public UserSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new UserDisplayTerms(portletRequest), (DisplayTerms)new UserSearchTerms(portletRequest), "cur", 20, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        PortletConfig portletConfig = (PortletConfig)portletRequest.getAttribute("javax.portlet.config");
        UserDisplayTerms displayTerms = (UserDisplayTerms)this.getDisplayTerms();
        UserSearchTerms searchTerms = (UserSearchTerms)this.getSearchTerms();
        String portletName = portletConfig.getPortletName();
        if (!(portletName.equals("79") || portletName.equals("125") || portletName.equals("126"))) {
            displayTerms.setActive(true);
            searchTerms.setActive(true);
        }
        iteratorURL.setParameter("firstName", displayTerms.getFirstName());
        iteratorURL.setParameter("middleName", displayTerms.getMiddleName());
        iteratorURL.setParameter("lastName", displayTerms.getLastName());
        iteratorURL.setParameter("screenName", displayTerms.getScreenName());
        iteratorURL.setParameter("emailAddress", displayTerms.getEmailAddress());
        if (displayTerms.hasActive()) {
            iteratorURL.setParameter("active", String.valueOf(displayTerms.isActive()));
        }
        iteratorURL.setParameter("organizationId", String.valueOf(displayTerms.getOrganizationId()));
        iteratorURL.setParameter("roleId", String.valueOf(displayTerms.getRoleId()));
        iteratorURL.setParameter("userGroupId", String.valueOf(displayTerms.getUserGroupId()));
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue("79", "users-order-by-col", orderByCol);
                preferences.setValue("79", "users-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue("79", "users-order-by-col", "last-name");
                orderByType = preferences.getValue("79", "users-order-by-type", "asc");
            }
            OrderByComparator orderByComparator = EnterpriseAdminUtil.getUserOrderByComparator(orderByCol, orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }

    static {
        headerNames.add("first-name");
        headerNames.add("last-name");
        headerNames.add("screen-name");
        headerNames.add("job-title");
        headerNames.add("organizations");
        orderableHeaders.put("first-name", "first-name");
        orderableHeaders.put("last-name", "last-name");
        orderableHeaders.put("screen-name", "screen-name");
        orderableHeaders.put("job-title", "job-title");
        _log = LogFactoryUtil.getLog(UserSearch.class);
    }
}

