/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.util;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.OrgLabor;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.model.Website;
import com.liferay.portal.model.impl.AddressImpl;
import com.liferay.portal.model.impl.EmailAddressImpl;
import com.liferay.portal.model.impl.OrgLaborImpl;
import com.liferay.portal.model.impl.PhoneImpl;
import com.liferay.portal.model.impl.UserGroupRoleImpl;
import com.liferay.portal.model.impl.WebsiteImpl;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.AddressServiceUtil;
import com.liferay.portal.service.EmailAddressServiceUtil;
import com.liferay.portal.service.OrgLaborServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.PhoneServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.WebsiteServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.RolePermissionUtil;
import com.liferay.portal.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.comparator.GroupNameComparator;
import com.liferay.portal.util.comparator.GroupTypeComparator;
import com.liferay.portal.util.comparator.OrganizationNameComparator;
import com.liferay.portal.util.comparator.OrganizationTypeComparator;
import com.liferay.portal.util.comparator.PasswordPolicyDescriptionComparator;
import com.liferay.portal.util.comparator.PasswordPolicyNameComparator;
import com.liferay.portal.util.comparator.RoleDescriptionComparator;
import com.liferay.portal.util.comparator.RoleNameComparator;
import com.liferay.portal.util.comparator.RoleTypeComparator;
import com.liferay.portal.util.comparator.UserEmailAddressComparator;
import com.liferay.portal.util.comparator.UserFirstNameComparator;
import com.liferay.portal.util.comparator.UserGroupDescriptionComparator;
import com.liferay.portal.util.comparator.UserGroupNameComparator;
import com.liferay.portal.util.comparator.UserJobTitleComparator;
import com.liferay.portal.util.comparator.UserLastNameComparator;
import com.liferay.portal.util.comparator.UserScreenNameComparator;
import com.liferay.util.UniqueList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseAdminUtil {
    public static final String CUSTOM_QUESTION = "write-my-own-question";

    public static String getCssClassName(Role role) {
        String cssClassName = "";
        String name = role.getName();
        int type = role.getType();
        if (name.equals("Guest")) {
            cssClassName = "lfr-role-guest";
        } else if (type == 1) {
            cssClassName = "lfr-role-regular";
        } else if (type == 2) {
            cssClassName = "lfr-role-community";
        } else if (type == 3) {
            cssClassName = "lfr-role-organization";
        }
        return "lfr-role " + cssClassName;
    }

    public static long[] addRequiredRoles(long userId, long[] roleIds) throws PortalException, SystemException {
        User user = UserLocalServiceUtil.getUser((long)userId);
        return EnterpriseAdminUtil.addRequiredRoles(user, roleIds);
    }

    public static long[] addRequiredRoles(User user, long[] roleIds) throws PortalException, SystemException {
        if (user.isDefaultUser()) {
            return EnterpriseAdminUtil.removeRequiredRoles(user, roleIds);
        }
        Role role = RoleLocalServiceUtil.getRole((long)user.getCompanyId(), (String)"User");
        if (!ArrayUtil.contains((long[])roleIds, (long)role.getRoleId())) {
            roleIds = ArrayUtil.append((long[])roleIds, (long)role.getRoleId());
        }
        return roleIds;
    }

    public static List<Group> filterGroups(PermissionChecker permissionChecker, List<Group> groups) throws PortalException, SystemException {
        if (permissionChecker.isCompanyAdmin()) {
            return groups;
        }
        List filteredGroups = ListUtil.copy(groups);
        Iterator itr = filteredGroups.iterator();
        while (itr.hasNext()) {
            Group group = (Group)itr.next();
            if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"ASSIGN_MEMBERS")) continue;
            itr.remove();
        }
        return filteredGroups;
    }

    public static List<Organization> filterOrganizations(PermissionChecker permissionChecker, List<Organization> organizations) throws PortalException, SystemException {
        if (permissionChecker.isCompanyAdmin()) {
            return organizations;
        }
        List filteredOrganizations = ListUtil.copy(organizations);
        Iterator itr = filteredOrganizations.iterator();
        while (itr.hasNext()) {
            Organization organization = (Organization)itr.next();
            if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organization.getOrganizationId(), (String)"ASSIGN_MEMBERS")) continue;
            itr.remove();
        }
        return filteredOrganizations;
    }

    public static List<Role> filterRoles(PermissionChecker permissionChecker, List<Role> roles) {
        Role role;
        List filteredRoles = ListUtil.copy(roles);
        Iterator itr = filteredRoles.iterator();
        while (itr.hasNext()) {
            role = (Role)itr.next();
            String name = role.getName();
            if (!name.equals("Community Member") && !name.equals("Guest") && !name.equals("Owner") && !name.equals("Organization Member") && !name.equals("User")) continue;
            itr.remove();
        }
        if (permissionChecker.isCompanyAdmin()) {
            return filteredRoles;
        }
        itr = filteredRoles.iterator();
        while (itr.hasNext()) {
            role = (Role)itr.next();
            if (RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)role.getRoleId(), (String)"ASSIGN_MEMBERS")) continue;
            itr.remove();
        }
        return filteredRoles;
    }

    public static List<UserGroupRole> filterUserGroupRoles(PermissionChecker permissionChecker, List<UserGroupRole> userGroupRoles) throws PortalException, SystemException {
        UserGroupRole userGroupRole;
        List filteredUserGroupRoles = ListUtil.copy(userGroupRoles);
        Iterator itr = filteredUserGroupRoles.iterator();
        while (itr.hasNext()) {
            userGroupRole = (UserGroupRole)itr.next();
            Role role = userGroupRole.getRole();
            String name = role.getName();
            if (!name.equals("Organization Member") && !name.equals("Community Member")) continue;
            itr.remove();
        }
        if (permissionChecker.isCompanyAdmin()) {
            return filteredUserGroupRoles;
        }
        itr = filteredUserGroupRoles.iterator();
        while (itr.hasNext()) {
            userGroupRole = (UserGroupRole)itr.next();
            if (RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)userGroupRole.getRoleId(), (String)"ASSIGN_MEMBERS")) continue;
            itr.remove();
        }
        return filteredUserGroupRoles;
    }

    public static List<UserGroup> filterUserGroups(PermissionChecker permissionChecker, List<UserGroup> userGroups) {
        if (permissionChecker.isCompanyAdmin()) {
            return userGroups;
        }
        List filteredUserGroups = ListUtil.copy(userGroups);
        Iterator itr = filteredUserGroups.iterator();
        while (itr.hasNext()) {
            UserGroup userGroup = (UserGroup)itr.next();
            if (UserGroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)userGroup.getUserGroupId(), (String)"ASSIGN_MEMBERS")) continue;
            itr.remove();
        }
        return filteredUserGroups;
    }

    public static List<Address> getAddresses(ActionRequest actionRequest) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        int[] addressesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"addressesIndexes"), (int)0);
        int addressPrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"addressPrimary");
        for (int addressesIndex : addressesIndexes) {
            long addressId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("addressId" + addressesIndex));
            String street1 = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressStreet1_" + addressesIndex));
            String street2 = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressStreet2_" + addressesIndex));
            String street3 = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressStreet3_" + addressesIndex));
            String city = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressCity" + addressesIndex));
            String zip = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressZip" + addressesIndex));
            if (Validator.isNull((String)street1) && Validator.isNull((String)street2) && Validator.isNull((String)street3) && Validator.isNull((String)city) && Validator.isNull((String)zip)) continue;
            long regionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("addressRegionId" + addressesIndex));
            long countryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("addressCountryId" + addressesIndex));
            int typeId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("addressTypeId" + addressesIndex));
            boolean mailing = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("addressMailing" + addressesIndex));
            boolean primary = false;
            if (addressesIndex == addressPrimary) {
                primary = true;
            }
            AddressImpl address = new AddressImpl();
            address.setAddressId(addressId);
            address.setStreet1(street1);
            address.setStreet2(street2);
            address.setStreet3(street3);
            address.setCity(city);
            address.setZip(zip);
            address.setRegionId(regionId);
            address.setCountryId(countryId);
            address.setTypeId(typeId);
            address.setMailing(mailing);
            address.setPrimary(primary);
            addresses.add(address);
        }
        return addresses;
    }

    public static List<EmailAddress> getEmailAddresses(ActionRequest actionRequest) {
        ArrayList<EmailAddress> emailAddresses = new ArrayList<EmailAddress>();
        int[] emailAddressesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"emailAddressesIndexes"), (int)0);
        int emailAddressPrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"emailAddressPrimary");
        for (int emailAddressesIndex : emailAddressesIndexes) {
            long emailAddressId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("emailAddressId" + emailAddressesIndex));
            String address = ParamUtil.getString((PortletRequest)actionRequest, (String)("emailAddressAddress" + emailAddressesIndex));
            if (Validator.isNull((String)address)) continue;
            int typeId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("emailAddressTypeId" + emailAddressesIndex));
            boolean primary = false;
            if (emailAddressesIndex == emailAddressPrimary) {
                primary = true;
            }
            EmailAddressImpl emailAddress = new EmailAddressImpl();
            emailAddress.setEmailAddressId(emailAddressId);
            emailAddress.setAddress(address);
            emailAddress.setTypeId(typeId);
            emailAddress.setPrimary(primary);
            emailAddresses.add(emailAddress);
        }
        return emailAddresses;
    }

    public static OrderByComparator getGroupOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? new GroupNameComparator(orderByAsc) : (orderByCol.equals("type") ? new GroupTypeComparator(orderByAsc) : new GroupNameComparator(orderByAsc));
        return orderByComparator;
    }

    public static Long[][] getLeftAndRightOrganizationIds(long organizationId) throws PortalException, SystemException {
        Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
        return EnterpriseAdminUtil.getLeftAndRightOrganizationIds(organization);
    }

    public static Long[][] getLeftAndRightOrganizationIds(Organization organization) {
        return new Long[][]{{organization.getLeftOrganizationId(), organization.getRightOrganizationId()}};
    }

    public static Long[][] getLeftAndRightOrganizationIds(List<Organization> organizations) {
        Long[][] leftAndRightOrganizationIds = new Long[organizations.size()][];
        for (int i = 0; i < organizations.size(); ++i) {
            Organization organization = organizations.get(i);
            leftAndRightOrganizationIds[i] = new Long[]{organization.getLeftOrganizationId(), organization.getRightOrganizationId()};
        }
        return leftAndRightOrganizationIds;
    }

    public static Long[] getOrganizationIds(List<Organization> organizations) {
        if (organizations == null || organizations.isEmpty()) {
            return new Long[0];
        }
        Long[] organizationIds = new Long[organizations.size()];
        for (int i = 0; i < organizations.size(); ++i) {
            Organization organization = organizations.get(i);
            organizationIds[i] = new Long(organization.getOrganizationId());
        }
        return organizationIds;
    }

    public static OrderByComparator getOrganizationOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? new OrganizationNameComparator(orderByAsc) : (orderByCol.equals("type") ? new OrganizationTypeComparator(orderByAsc) : new OrganizationNameComparator(orderByAsc));
        return orderByComparator;
    }

    public static List<OrgLabor> getOrgLabors(ActionRequest actionRequest) {
        int[] orgLaborsIndexes;
        ArrayList<OrgLabor> orgLabors = new ArrayList<OrgLabor>();
        for (int orgLaborsIndex : orgLaborsIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"orgLaborsIndexes"), (int)0)) {
            long orgLaborId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("orgLaborId" + orgLaborsIndex));
            int typeId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("orgLaborTypeId" + orgLaborsIndex), (int)-1);
            if (typeId == -1) continue;
            int sunOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("sunOpen" + orgLaborsIndex), (int)-1);
            int sunClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("sunClose" + orgLaborsIndex), (int)-1);
            int monOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("monOpen" + orgLaborsIndex), (int)-1);
            int monClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("monClose" + orgLaborsIndex), (int)-1);
            int tueOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("tueOpen" + orgLaborsIndex), (int)-1);
            int tueClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("tueClose" + orgLaborsIndex), (int)-1);
            int wedOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("wedOpen" + orgLaborsIndex), (int)-1);
            int wedClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("wedClose" + orgLaborsIndex), (int)-1);
            int thuOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("thuOpen" + orgLaborsIndex), (int)-1);
            int thuClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("thuClose" + orgLaborsIndex), (int)-1);
            int friOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("friOpen" + orgLaborsIndex), (int)-1);
            int friClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("friClose" + orgLaborsIndex), (int)-1);
            int satOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("satOpen" + orgLaborsIndex), (int)-1);
            int satClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("satClose" + orgLaborsIndex), (int)-1);
            OrgLaborImpl orgLabor = new OrgLaborImpl();
            orgLabor.setOrgLaborId(orgLaborId);
            orgLabor.setTypeId(typeId);
            orgLabor.setSunOpen(sunOpen);
            orgLabor.setSunClose(sunClose);
            orgLabor.setMonOpen(monOpen);
            orgLabor.setMonClose(monClose);
            orgLabor.setTueOpen(tueOpen);
            orgLabor.setTueClose(tueClose);
            orgLabor.setWedOpen(wedOpen);
            orgLabor.setWedClose(wedClose);
            orgLabor.setThuOpen(thuOpen);
            orgLabor.setThuClose(thuClose);
            orgLabor.setFriOpen(friOpen);
            orgLabor.setFriClose(friClose);
            orgLabor.setSatOpen(satOpen);
            orgLabor.setSatClose(satClose);
            orgLabors.add(orgLabor);
        }
        return orgLabors;
    }

    public static OrderByComparator getPasswordPolicyOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? new PasswordPolicyNameComparator(orderByAsc) : (orderByCol.equals("description") ? new PasswordPolicyDescriptionComparator(orderByAsc) : new PasswordPolicyNameComparator(orderByAsc));
        return orderByComparator;
    }

    public static List<Phone> getPhones(ActionRequest actionRequest) {
        ArrayList<Phone> phones = new ArrayList<Phone>();
        int[] phonesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"phonesIndexes"), (int)0);
        int phonePrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"phonePrimary");
        for (int phonesIndex : phonesIndexes) {
            long phoneId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("phoneId" + phonesIndex));
            String number = ParamUtil.getString((PortletRequest)actionRequest, (String)("phoneNumber" + phonesIndex));
            String extension = ParamUtil.getString((PortletRequest)actionRequest, (String)("phoneExtension" + phonesIndex));
            if (Validator.isNull((String)number) && Validator.isNull((String)extension)) continue;
            int typeId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("phoneTypeId" + phonesIndex));
            boolean primary = false;
            if (phonesIndex == phonePrimary) {
                primary = true;
            }
            PhoneImpl phone = new PhoneImpl();
            phone.setPhoneId(phoneId);
            phone.setNumber(number);
            phone.setExtension(extension);
            phone.setTypeId(typeId);
            phone.setPrimary(primary);
            phones.add(phone);
        }
        return phones;
    }

    public static OrderByComparator getRoleOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? new RoleNameComparator(orderByAsc) : (orderByCol.equals("description") ? new RoleDescriptionComparator(orderByAsc) : (orderByCol.equals("type") ? new RoleTypeComparator(orderByAsc) : new RoleNameComparator(orderByAsc)));
        return orderByComparator;
    }

    public static OrderByComparator getUserGroupOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? new UserGroupNameComparator(orderByAsc) : (orderByCol.equals("description") ? new UserGroupDescriptionComparator(orderByAsc) : new UserGroupNameComparator(orderByAsc));
        return orderByComparator;
    }

    public static List<UserGroupRole> getUserGroupRoles(PortletRequest portletRequest) throws SystemException, PortalException {
        UniqueList userGroupRoles = new UniqueList();
        long[] groupRolesRoleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)"groupRolesRoleIds"), (long)0L);
        long[] groupRolesGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)"groupRolesGroupIds"), (long)0L);
        if (groupRolesGroupIds.length != groupRolesRoleIds.length) {
            return userGroupRoles;
        }
        User user = PortalUtil.getSelectedUser((PortletRequest)portletRequest);
        long userId = 0L;
        if (user != null) {
            userId = user.getUserId();
        }
        for (int i = 0; i < groupRolesGroupIds.length; ++i) {
            if (groupRolesGroupIds[i] == 0L || groupRolesRoleIds[i] == 0L) continue;
            UserGroupRoleImpl userGroupRole = new UserGroupRoleImpl();
            userGroupRole.setUserId(userId);
            userGroupRole.setGroupId(groupRolesGroupIds[i]);
            userGroupRole.setRoleId(groupRolesRoleIds[i]);
            userGroupRoles.add(userGroupRole);
        }
        return userGroupRoles;
    }

    public static OrderByComparator getUserOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("email-address") ? new UserEmailAddressComparator(orderByAsc) : (orderByCol.equals("first-name") ? new UserFirstNameComparator(orderByAsc) : (orderByCol.equals("job-title") ? new UserJobTitleComparator(orderByAsc) : (orderByCol.equals("last-name") ? new UserLastNameComparator(orderByAsc) : (orderByCol.equals("screen-name") ? new UserScreenNameComparator(orderByAsc) : new UserLastNameComparator(orderByAsc)))));
        return orderByComparator;
    }

    public static List<Website> getWebsites(ActionRequest actionRequest) {
        ArrayList<Website> websites = new ArrayList<Website>();
        int[] websitesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"websitesIndexes"), (int)0);
        int websitePrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"websitePrimary");
        for (int websitesIndex : websitesIndexes) {
            long websiteId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("websiteId" + websitesIndex));
            String url = ParamUtil.getString((PortletRequest)actionRequest, (String)("websiteUrl" + websitesIndex));
            if (Validator.isNull((String)url)) continue;
            int typeId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("websiteTypeId" + websitesIndex));
            boolean primary = false;
            if (websitesIndex == websitePrimary) {
                primary = true;
            }
            WebsiteImpl website = new WebsiteImpl();
            website.setWebsiteId(websiteId);
            website.setUrl(url);
            website.setTypeId(typeId);
            website.setPrimary(primary);
            websites.add(website);
        }
        return websites;
    }

    public static long[] removeRequiredRoles(long userId, long[] roleIds) throws PortalException, SystemException {
        User user = UserLocalServiceUtil.getUser((long)userId);
        return EnterpriseAdminUtil.removeRequiredRoles(user, roleIds);
    }

    public static long[] removeRequiredRoles(User user, long[] roleIds) throws PortalException, SystemException {
        Role role = RoleLocalServiceUtil.getRole((long)user.getCompanyId(), (String)"User");
        roleIds = ArrayUtil.remove((long[])roleIds, (long)role.getRoleId());
        return roleIds;
    }

    public static void updateAddresses(String className, long classPK, List<Address> addresses) throws PortalException, SystemException {
        HashSet<Long> addressIds = new HashSet<Long>();
        for (Address address : addresses) {
            long addressId = address.getAddressId();
            String street1 = address.getStreet1();
            String street2 = address.getStreet2();
            String street3 = address.getStreet3();
            String city = address.getCity();
            String zip = address.getZip();
            long regionId = address.getRegionId();
            long countryId = address.getCountryId();
            int typeId = address.getTypeId();
            boolean mailing = address.isMailing();
            boolean primary = address.isPrimary();
            if (addressId <= 0L) {
                address = AddressServiceUtil.addAddress((String)className, (long)classPK, (String)street1, (String)street2, (String)street3, (String)city, (String)zip, (long)regionId, (long)countryId, (int)typeId, (boolean)mailing, (boolean)primary);
                addressId = address.getAddressId();
            } else {
                AddressServiceUtil.updateAddress((long)addressId, (String)street1, (String)street2, (String)street3, (String)city, (String)zip, (long)regionId, (long)countryId, (int)typeId, (boolean)mailing, (boolean)primary);
            }
            addressIds.add(addressId);
        }
        addresses = AddressServiceUtil.getAddresses((String)className, (long)classPK);
        for (Address address : addresses) {
            if (addressIds.contains(address.getAddressId())) continue;
            AddressServiceUtil.deleteAddress((long)address.getAddressId());
        }
    }

    public static void updateEmailAddresses(String className, long classPK, List<EmailAddress> emailAddresses) throws PortalException, SystemException {
        HashSet<Long> emailAddressIds = new HashSet<Long>();
        for (EmailAddress emailAddress : emailAddresses) {
            long emailAddressId = emailAddress.getEmailAddressId();
            String address = emailAddress.getAddress();
            int typeId = emailAddress.getTypeId();
            boolean primary = emailAddress.isPrimary();
            if (emailAddressId <= 0L) {
                emailAddress = EmailAddressServiceUtil.addEmailAddress((String)className, (long)classPK, (String)address, (int)typeId, (boolean)primary);
                emailAddressId = emailAddress.getEmailAddressId();
            } else {
                EmailAddressServiceUtil.updateEmailAddress((long)emailAddressId, (String)address, (int)typeId, (boolean)primary);
            }
            emailAddressIds.add(emailAddressId);
        }
        emailAddresses = EmailAddressServiceUtil.getEmailAddresses((String)className, (long)classPK);
        for (EmailAddress emailAddress : emailAddresses) {
            if (emailAddressIds.contains(emailAddress.getEmailAddressId())) continue;
            EmailAddressServiceUtil.deleteEmailAddress((long)emailAddress.getEmailAddressId());
        }
    }

    public static void updateOrgLabors(long classPK, List<OrgLabor> orgLabors) throws PortalException, SystemException {
        HashSet<Long> orgLaborsIds = new HashSet<Long>();
        for (OrgLabor orgLabor : orgLabors) {
            long orgLaborId = orgLabor.getOrgLaborId();
            int typeId = orgLabor.getTypeId();
            int sunOpen = orgLabor.getSunOpen();
            int sunClose = orgLabor.getSunClose();
            int monOpen = orgLabor.getMonOpen();
            int monClose = orgLabor.getMonClose();
            int tueOpen = orgLabor.getTueOpen();
            int tueClose = orgLabor.getTueClose();
            int wedOpen = orgLabor.getWedOpen();
            int wedClose = orgLabor.getWedClose();
            int thuOpen = orgLabor.getThuOpen();
            int thuClose = orgLabor.getThuClose();
            int friOpen = orgLabor.getFriOpen();
            int friClose = orgLabor.getFriClose();
            int satOpen = orgLabor.getSatOpen();
            int satClose = orgLabor.getSatClose();
            if (orgLaborId <= 0L) {
                orgLabor = OrgLaborServiceUtil.addOrgLabor((long)classPK, (int)typeId, (int)sunOpen, (int)sunClose, (int)monOpen, (int)monClose, (int)tueOpen, (int)tueClose, (int)wedOpen, (int)wedClose, (int)thuOpen, (int)thuClose, (int)friOpen, (int)friClose, (int)satOpen, (int)satClose);
                orgLaborId = orgLabor.getOrgLaborId();
            } else {
                OrgLaborServiceUtil.updateOrgLabor((long)orgLaborId, (int)typeId, (int)sunOpen, (int)sunClose, (int)monOpen, (int)monClose, (int)tueOpen, (int)tueClose, (int)wedOpen, (int)wedClose, (int)thuOpen, (int)thuClose, (int)friOpen, (int)friClose, (int)satOpen, (int)satClose);
            }
            orgLaborsIds.add(orgLaborId);
        }
        orgLabors = OrgLaborServiceUtil.getOrgLabors((long)classPK);
        for (OrgLabor orgLabor : orgLabors) {
            if (orgLaborsIds.contains(orgLabor.getOrgLaborId())) continue;
            OrgLaborServiceUtil.deleteOrgLabor((long)orgLabor.getOrgLaborId());
        }
    }

    public static void updatePhones(String className, long classPK, List<Phone> phones) throws PortalException, SystemException {
        HashSet<Long> phoneIds = new HashSet<Long>();
        for (Phone phone : phones) {
            long phoneId = phone.getPhoneId();
            String number = phone.getNumber();
            String extension = phone.getExtension();
            int typeId = phone.getTypeId();
            boolean primary = phone.isPrimary();
            if (phoneId <= 0L) {
                phone = PhoneServiceUtil.addPhone((String)className, (long)classPK, (String)number, (String)extension, (int)typeId, (boolean)primary);
                phoneId = phone.getPhoneId();
            } else {
                PhoneServiceUtil.updatePhone((long)phoneId, (String)number, (String)extension, (int)typeId, (boolean)primary);
            }
            phoneIds.add(phoneId);
        }
        phones = PhoneServiceUtil.getPhones((String)className, (long)classPK);
        for (Phone phone : phones) {
            if (phoneIds.contains(phone.getPhoneId())) continue;
            PhoneServiceUtil.deletePhone((long)phone.getPhoneId());
        }
    }

    public static void updateWebsites(String className, long classPK, List<Website> websites) throws PortalException, SystemException {
        HashSet<Long> websiteIds = new HashSet<Long>();
        for (Website website : websites) {
            long websiteId = website.getWebsiteId();
            String url = website.getUrl();
            int typeId = website.getTypeId();
            boolean primary = website.isPrimary();
            if (websiteId <= 0L) {
                website = WebsiteServiceUtil.addWebsite((String)className, (long)classPK, (String)url, (int)typeId, (boolean)primary);
                websiteId = website.getWebsiteId();
            } else {
                WebsiteServiceUtil.updateWebsite((long)websiteId, (String)url, (int)typeId, (boolean)primary);
            }
            websiteIds.add(websiteId);
        }
        websites = WebsiteServiceUtil.getWebsites((String)className, (long)classPK);
        for (Website website : websites) {
            if (websiteIds.contains(website.getWebsiteId())) continue;
            WebsiteServiceUtil.deleteWebsite((long)website.getWebsiteId());
        }
    }
}

