/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.DocumentSummary;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.model.ContactConstants;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.tags.service.TagsEntryLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserIndexer
implements Indexer {
    public static final String PORTLET_ID = "125";
    private static final String[] _CLASS_NAMES = new String[]{User.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(UserIndexer.class);

    public static void deleteUser(long companyId, long userId) throws SearchException {
        SearchEngineUtil.deleteDocument((long)companyId, (String)UserIndexer.getUserUID(userId));
    }

    public static Document getUserDocument(long companyId, long userId, String screenName, String emailAddress, String firstName, String middleName, String lastName, String jobTitle, boolean active, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, String[] tagsEntries, ExpandoBridge expandoBridge) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, String.valueOf(userId));
        doc.addModifiedDate();
        doc.addKeyword("companyId", companyId);
        doc.addKeyword("portletId", PORTLET_ID);
        doc.addKeyword("userId", userId);
        doc.addKeyword("screenName", screenName);
        doc.addKeyword("emailAddress", emailAddress);
        doc.addKeyword("firstName", firstName, true);
        doc.addKeyword("middleName", middleName, true);
        doc.addKeyword("lastName", lastName, true);
        doc.addKeyword("jobTitle", jobTitle);
        doc.addKeyword("active", active);
        doc.addKeyword("groupIds", groupIds);
        doc.addKeyword("organizationIds", organizationIds);
        doc.addKeyword("ancestorOrganizationIds", UserIndexer._getAncestorOrganizationIds(userId, organizationIds));
        doc.addKeyword("roleIds", roleIds);
        doc.addKeyword("userGroupIds", userGroupIds);
        doc.addKeyword("tagsEntries", tagsEntries);
        ExpandoBridgeIndexerUtil.addAttributes((Document)doc, (ExpandoBridge)expandoBridge);
        return doc;
    }

    public static String getUserUID(long userId) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, String.valueOf(userId));
        return doc.get("uid");
    }

    public static void updateUser(User user) throws SearchException {
        try {
            if (user.isDefaultUser()) {
                return;
            }
            String[] tagsEntries = TagsEntryLocalServiceUtil.getEntryNames((String)User.class.getName(), (long)user.getUserId());
            Document doc = UserIndexer.getUserDocument(user.getCompanyId(), user.getUserId(), user.getScreenName(), user.getEmailAddress(), user.getFirstName(), user.getMiddleName(), user.getLastName(), user.getJobTitle(), user.getActive(), user.getGroupIds(), user.getOrganizationIds(), user.getRoleIds(), user.getUserGroupIds(), tagsEntries, user.getExpandoBridge());
            SearchEngineUtil.updateDocument((long)user.getCompanyId(), (String)doc.get("uid"), (Document)doc);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public static void updateUsers(long[] userIds) throws SearchException {
        for (long userId : userIds) {
            try {
                User user = UserLocalServiceUtil.getUserById((long)userId);
                UserIndexer.updateUser(user);
            }
            catch (Exception e) {
                throw new SearchException((Throwable)e);
            }
        }
    }

    public static void updateUsers(List<User> users) throws SearchException {
        for (User user : users) {
            UserIndexer.updateUser(user);
        }
    }

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    public DocumentSummary getDocumentSummary(Document doc, String snippet, PortletURL portletURL) {
        String firstName = doc.get("firstName");
        String middleName = doc.get("middleName");
        String lastName = doc.get("lastName");
        String title = ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName);
        String content = null;
        String userId = doc.get("userId");
        portletURL.setParameter("struts_action", "/enterprise_admin/edit_user");
        portletURL.setParameter("p_u_i_d", userId);
        return new DocumentSummary(title, content, portletURL);
    }

    public void reIndex(String className, long classPK) throws SearchException {
        try {
            UserLocalServiceUtil.reIndex((long)classPK);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void reIndex(String[] ids) throws SearchException {
        try {
            UserLocalServiceUtil.reIndex((String[])ids);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    private static long[] _getAncestorOrganizationIds(long userId, long[] organizationIds) {
        ArrayList ancestorOrganizations = new ArrayList();
        for (long organizationId : organizationIds) {
            try {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                ancestorOrganizations.addAll(organization.getAncestors());
            }
            catch (Exception e) {
                _log.error((Object)("Error while indexing user " + userId), (Throwable)e);
            }
        }
        long[] ancestorOrganizationIds = new long[ancestorOrganizations.size()];
        for (int i = 0; i < ancestorOrganizations.size(); ++i) {
            Organization ancestorOrganization = (Organization)ancestorOrganizations.get(i);
            ancestorOrganizationIds[i] = ancestorOrganization.getOrganizationId();
        }
        return ancestorOrganizationIds;
    }
}

