/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.model.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.expando.NoSuchTableException;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoColumnServiceUtil;
import com.liferay.portlet.expando.service.ExpandoTableLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoValueServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandoBridgeImpl
implements ExpandoBridge {
    private static Log _log = LogFactoryUtil.getLog(ExpandoBridgeImpl.class);
    private String _className;
    private long _classPK;
    private boolean _indexEnabled;

    public ExpandoBridgeImpl(String className) {
        this(className, 0L);
    }

    public ExpandoBridgeImpl(String className, long classPK) {
        this._className = className;
        this._classPK = classPK;
        if (IndexerRegistryUtil.getIndexer((String)className) == null) {
            this.setIndexEnabled(true);
        }
    }

    public void addAttribute(String name) throws PortalException {
        this.addAttribute(name, 15, null);
    }

    public void addAttribute(String name, int type) throws PortalException {
        this.addAttribute(name, type, null);
    }

    public void addAttribute(String name, int type, Serializable defaultValue) throws PortalException {
        try {
            ExpandoTable table = null;
            try {
                table = ExpandoTableLocalServiceUtil.getDefaultTable((String)this._className);
            }
            catch (NoSuchTableException nste) {
                table = ExpandoTableLocalServiceUtil.addDefaultTable((String)this._className);
            }
            ExpandoColumnServiceUtil.addColumn((long)table.getTableId(), (String)name, (int)type, (Object)defaultValue);
        }
        catch (Exception e) {
            if (e instanceof PortalException) {
                throw (PortalException)((Object)e);
            }
            _log.error((Object)e, (Throwable)e);
        }
    }

    public Serializable getAttribute(String name) {
        Serializable data;
        block2: {
            data = null;
            try {
                data = ExpandoValueServiceUtil.getData((String)this._className, (String)"DEFAULT_TABLE", (String)name, (long)this._classPK);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return data;
    }

    public Serializable getAttributeDefault(String name) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((String)this._className, (String)name);
            return column.getDefaultValue();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public Enumeration<String> getAttributeNames() {
        List columns;
        block3: {
            columns = new ArrayList();
            try {
                columns = ExpandoColumnLocalServiceUtil.getDefaultTableColumns((String)this._className);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ExpandoColumn column : columns) {
            columnNames.add(column.getName());
        }
        return Collections.enumeration(columnNames);
    }

    public UnicodeProperties getAttributeProperties(String name) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((String)this._className, (String)name);
            return column.getTypeSettingsProperties();
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Properties for " + name), (Throwable)e);
            }
            return new UnicodeProperties(true);
        }
    }

    public Map<String, Serializable> getAttributes() {
        List columns;
        HashMap<String, Serializable> attributes;
        block3: {
            attributes = new HashMap<String, Serializable>();
            columns = new ArrayList();
            try {
                columns = ExpandoColumnLocalServiceUtil.getDefaultTableColumns((String)this._className);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        for (ExpandoColumn column : columns) {
            attributes.put(column.getName(), this.getAttribute(column.getName()));
        }
        return attributes;
    }

    public int getAttributeType(String name) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((String)this._className, (String)name);
            return column.getType();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return 0;
        }
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public boolean hasAttribute(String name) {
        ExpandoColumn column = null;
        try {
            column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((String)this._className, (String)name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return column != null;
    }

    public boolean isIndexEnabled() {
        return this._indexEnabled && this._classPK > 0L;
    }

    public void reIndex() {
        if (!this.isIndexEnabled()) {
            return;
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)this._className);
        if (indexer != null) {
            try {
                indexer.reIndex(this._className, this._classPK);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    public void setAttribute(String name, Serializable value) {
        if (this._classPK <= 0L) {
            throw new UnsupportedOperationException();
        }
        try {
            ExpandoValueServiceUtil.addValue((String)this._className, (String)"DEFAULT_TABLE", (String)name, (long)this._classPK, (Object)value);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void setAttributeDefault(String name, Serializable defaultValue) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((String)this._className, (String)name);
            ExpandoColumnServiceUtil.updateColumn((long)column.getColumnId(), (String)column.getName(), (int)column.getType(), (Object)defaultValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void setAttributeProperties(String name, UnicodeProperties properties) {
        try {
            ExpandoColumn column = ExpandoColumnLocalServiceUtil.getDefaultTableColumn((String)this._className, (String)name);
            ExpandoColumnServiceUtil.updateTypeSettings((long)column.getColumnId(), (String)properties.toString());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void setAttributes(Map<String, Serializable> attributes) {
        if (attributes == null) {
            return;
        }
        for (Map.Entry<String, Serializable> entry : attributes.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public void setAttributes(ServiceContext serviceContext) {
        if (serviceContext == null) {
            return;
        }
        this.setAttributes(serviceContext.getExpandoBridgeAttributes());
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setIndexEnabled(boolean indexEnabled) {
        this._indexEnabled = indexEnabled;
    }
}

