/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoRow;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.service.base.ExpandoRowLocalServiceBaseImpl;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandoRowLocalServiceImpl
extends ExpandoRowLocalServiceBaseImpl {
    public ExpandoRow addRow(long tableId, long classPK) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        long rowId = this.counterLocalService.increment();
        ExpandoRow row = this.expandoRowPersistence.create(rowId);
        row.setCompanyId(table.getCompanyId());
        row.setTableId(tableId);
        row.setClassPK(classPK);
        this.expandoRowPersistence.update((BaseModel)row, false);
        return row;
    }

    public void deleteRow(long rowId) throws PortalException, SystemException {
        this.expandoRowPersistence.remove(rowId);
        this.expandoValueLocalService.deleteRowValues(rowId);
    }

    public void deleteRow(long tableId, long classPK) throws PortalException, SystemException {
        ExpandoRow row = this.expandoRowPersistence.findByT_C(tableId, classPK);
        this.deleteRow(row.getRowId());
    }

    public void deleteRow(long classNameId, String tableName, long classPK) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(classNameId, tableName);
        this.deleteRow(table.getTableId(), classPK);
    }

    public void deleteRow(String className, String tableName, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.deleteRow(classNameId, tableName, classPK);
    }

    public List<ExpandoRow> getDefaultTableRows(long classNameId, int start, int end) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, "DEFAULT_TABLE");
        if (table == null) {
            return Collections.EMPTY_LIST;
        }
        return this.expandoRowPersistence.findByTableId(table.getTableId(), start, end);
    }

    public List<ExpandoRow> getDefaultTableRows(String className, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getDefaultTableRows(classNameId, start, end);
    }

    public int getDefaultTableRowsCount(long classNameId) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, "DEFAULT_TABLE");
        if (table == null) {
            return 0;
        }
        return this.expandoRowPersistence.countByTableId(table.getTableId());
    }

    public int getDefaultTableRowsCount(String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getDefaultTableRowsCount(classNameId);
    }

    public ExpandoRow getRow(long rowId) throws PortalException, SystemException {
        return this.expandoRowPersistence.findByPrimaryKey(rowId);
    }

    public ExpandoRow getRow(long tableId, long classPK) throws PortalException, SystemException {
        return this.expandoRowPersistence.findByT_C(tableId, classPK);
    }

    public ExpandoRow getRow(long classNameId, String tableName, long classPK) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return null;
        }
        return this.expandoRowPersistence.fetchByT_C(table.getTableId(), classPK);
    }

    public ExpandoRow getRow(String className, String tableName, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getRow(classNameId, tableName, classPK);
    }

    public List<ExpandoRow> getRows(long tableId, int start, int end) throws SystemException {
        return this.expandoRowPersistence.findByTableId(tableId, start, end);
    }

    public List<ExpandoRow> getRows(long classNameId, String tableName, int start, int end) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.EMPTY_LIST;
        }
        return this.expandoRowPersistence.findByTableId(table.getTableId(), start, end);
    }

    public List<ExpandoRow> getRows(String className, String tableName, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getRows(classNameId, tableName, start, end);
    }

    public int getRowsCount(long tableId) throws SystemException {
        return this.expandoRowPersistence.countByTableId(tableId);
    }

    public int getRowsCount(long classNameId, String tableName) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        return this.expandoRowPersistence.countByTableId(table.getTableId());
    }

    public int getRowsCount(String className, String tableName) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getRowsCount(classNameId, tableName);
    }
}

