/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.DuplicateTableNameException;
import com.liferay.portlet.expando.TableNameException;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.service.base.ExpandoTableLocalServiceBaseImpl;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandoTableLocalServiceImpl
extends ExpandoTableLocalServiceBaseImpl {
    public ExpandoTable addDefaultTable(long classNameId) throws PortalException, SystemException {
        return this.addTable(classNameId, "DEFAULT_TABLE");
    }

    public ExpandoTable addDefaultTable(String className) throws PortalException, SystemException {
        return this.addTable(className, "DEFAULT_TABLE");
    }

    public ExpandoTable addTable(long classNameId, String name) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        this.validate(companyId, 0L, classNameId, name);
        long tableId = this.counterLocalService.increment();
        ExpandoTable table = this.expandoTablePersistence.create(tableId);
        table.setCompanyId(companyId);
        table.setClassNameId(classNameId);
        table.setName(name);
        this.expandoTablePersistence.update((BaseModel)table, false);
        return table;
    }

    public ExpandoTable addTable(String className, String name) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.addTable(classNameId, name);
    }

    public void deleteTable(ExpandoTable table) throws SystemException {
        this.expandoTablePersistence.remove((BaseModel)table);
        this.runSQL("delete from ExpandoColumn where tableId = " + table.getTableId());
        this.expandoColumnPersistence.clearCache();
        this.runSQL("delete from ExpandoRow where tableId = " + table.getTableId());
        this.expandoRowPersistence.clearCache();
        this.runSQL("delete from ExpandoValue where tableId = " + table.getTableId());
        this.expandoValuePersistence.clearCache();
    }

    public void deleteTable(long tableId) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        this.deleteTable(table);
    }

    public void deleteTable(long classNameId, String name) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.findByC_C_N(companyId, classNameId, name);
        this.deleteTable(table);
    }

    public void deleteTable(String className, String name) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.deleteTable(classNameId, name);
    }

    public void deleteTables(long classNameId) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        List tables = this.expandoTablePersistence.findByC_C(companyId, classNameId);
        for (ExpandoTable table : tables) {
            this.deleteTable(table);
        }
    }

    public void deleteTables(String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.deleteTables(classNameId);
    }

    public ExpandoTable getDefaultTable(long classNameId) throws PortalException, SystemException {
        return this.getTable(classNameId, "DEFAULT_TABLE");
    }

    public ExpandoTable getDefaultTable(String className) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getTable(classNameId, "DEFAULT_TABLE");
    }

    public ExpandoTable getTable(long tableId) throws PortalException, SystemException {
        return this.expandoTablePersistence.findByPrimaryKey(tableId);
    }

    public ExpandoTable getTable(long classNameId, String name) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoTablePersistence.findByC_C_N(companyId, classNameId, name);
    }

    public ExpandoTable getTable(String className, String name) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getTable(classNameId, name);
    }

    public List<ExpandoTable> getTables(long classNameId) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.expandoTablePersistence.findByC_C(companyId, classNameId);
    }

    public List<ExpandoTable> getTables(String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getTables(classNameId);
    }

    public ExpandoTable updateTable(long tableId, String name) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        if (table.getName().equals("DEFAULT_TABLE")) {
            throw new TableNameException("Cannot rename DEFAULT_TABLE");
        }
        this.validate(table.getCompanyId(), tableId, table.getClassNameId(), name);
        table.setName(name);
        return (ExpandoTable)this.expandoTablePersistence.update((BaseModel)table, false);
    }

    protected void validate(long companyId, long tableId, long classNameId, String name) throws PortalException, SystemException {
        if (Validator.isNull((String)name)) {
            throw new TableNameException();
        }
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, name);
        if (table != null && table.getTableId() != tableId) {
            throw new DuplicateTableNameException();
        }
    }
}

