/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoRow;
import com.liferay.portlet.expando.model.ExpandoTable;
import com.liferay.portlet.expando.model.ExpandoValue;
import com.liferay.portlet.expando.model.impl.ExpandoValueImpl;
import com.liferay.portlet.expando.service.base.ExpandoValueLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandoValueLocalServiceImpl
extends ExpandoValueLocalServiceBaseImpl {
    public ExpandoValue addValue(long classNameId, long tableId, long columnId, long classPK, String data) throws SystemException {
        ExpandoValue value;
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoRow row = this.expandoRowPersistence.fetchByT_C(tableId, classPK);
        if (row == null) {
            long rowId = this.counterLocalService.increment();
            row = this.expandoRowPersistence.create(rowId);
            row.setCompanyId(companyId);
            row.setTableId(tableId);
            row.setClassPK(classPK);
            this.expandoRowPersistence.update((BaseModel)row, false);
        }
        if ((value = this.expandoValuePersistence.fetchByC_R(columnId, row.getRowId())) == null) {
            long valueId = this.counterLocalService.increment();
            value = this.expandoValuePersistence.create(valueId);
            value.setCompanyId(companyId);
            value.setTableId(tableId);
            value.setColumnId(columnId);
            value.setRowId(row.getRowId());
            value.setClassNameId(classNameId);
            value.setClassPK(classPK);
        }
        value.setData(data);
        this.expandoValuePersistence.update((BaseModel)value, false);
        return value;
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, boolean data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setBoolean(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, boolean[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setBooleanArray(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, Date data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDate(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, Date[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDateArray(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, double data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDouble(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, double[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDoubleArray(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, float data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setFloat(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, float[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setFloatArray(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, int data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setInteger(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, int[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setIntegerArray(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, long data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setLong(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, long[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setLongArray(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, Object data) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(className, tableName, columnName);
        int type = column.getType();
        if (type == 1) {
            return this.addValue(className, tableName, columnName, classPK, (Boolean)data);
        }
        if (type == 2) {
            return this.addValue(className, tableName, columnName, classPK, (boolean[])data);
        }
        if (type == 3) {
            return this.addValue(className, tableName, columnName, classPK, (Date)data);
        }
        if (type == 4) {
            return this.addValue(className, tableName, columnName, classPK, (Date[])data);
        }
        if (type == 5) {
            return this.addValue(className, tableName, columnName, classPK, (Double)data);
        }
        if (type == 6) {
            return this.addValue(className, tableName, columnName, classPK, (double[])data);
        }
        if (type == 7) {
            return this.addValue(className, tableName, columnName, classPK, ((Float)data).floatValue());
        }
        if (type == 8) {
            return this.addValue(className, tableName, columnName, classPK, (float[])data);
        }
        if (type == 9) {
            return this.addValue(className, tableName, columnName, classPK, (Integer)data);
        }
        if (type == 10) {
            return this.addValue(className, tableName, columnName, classPK, (int[])data);
        }
        if (type == 11) {
            return this.addValue(className, tableName, columnName, classPK, (Long)data);
        }
        if (type == 12) {
            return this.addValue(className, tableName, columnName, classPK, (long[])data);
        }
        if (type == 13) {
            return this.addValue(className, tableName, columnName, classPK, (Short)data);
        }
        if (type == 14) {
            return this.addValue(className, tableName, columnName, classPK, (short[])data);
        }
        if (type == 16) {
            return this.addValue(className, tableName, columnName, classPK, (String[])data);
        }
        return this.addValue(className, tableName, columnName, classPK, (String)data);
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, short data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setShort(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, short[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setShortArray(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, String data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setString(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(String className, String tableName, String columnName, long classPK, String[] data) throws PortalException, SystemException {
        ExpandoTable table = this.expandoTableLocalService.getTable(className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setStringArray(data);
        return this.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public void addValues(long classNameId, long tableId, List<ExpandoColumn> columns, long classPK, Map<String, String> data) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoRow row = this.expandoRowPersistence.fetchByT_C(tableId, classPK);
        if (row == null) {
            long rowId = this.counterLocalService.increment();
            row = this.expandoRowPersistence.create(rowId);
            row.setCompanyId(companyId);
            row.setTableId(tableId);
            row.setClassPK(classPK);
            this.expandoRowPersistence.update((BaseModel)row, false);
        }
        for (ExpandoColumn column : columns) {
            if (!data.containsKey(column.getName())) continue;
            ExpandoValue value = this.expandoValuePersistence.fetchByC_R(column.getColumnId(), row.getRowId());
            if (value == null) {
                long valueId = this.counterLocalService.increment();
                value = this.expandoValuePersistence.create(valueId);
                value.setCompanyId(companyId);
                value.setTableId(tableId);
                value.setColumnId(column.getColumnId());
                value.setRowId(row.getRowId());
                value.setClassNameId(classNameId);
                value.setClassPK(classPK);
            }
            value.setData(data.get(column.getName()));
            this.expandoValuePersistence.update((BaseModel)value, false);
        }
    }

    public void deleteColumnValues(long columnId) throws SystemException {
        this.expandoValuePersistence.removeByColumnId(columnId);
    }

    public void deleteRowValues(long rowId) throws SystemException {
        this.expandoValuePersistence.removeByRowId(rowId);
    }

    public void deleteTableValues(long tableId) throws SystemException {
        this.expandoValuePersistence.removeByTableId(tableId);
    }

    public void deleteValue(long valueId) throws PortalException, SystemException {
        this.expandoValuePersistence.remove(valueId);
    }

    public void deleteValue(long columnId, long rowId) throws PortalException, SystemException {
        this.expandoValuePersistence.removeByC_R(columnId, rowId);
    }

    public void deleteValue(long classNameId, String tableName, String columnName, long classPK) throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return;
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(table.getTableId(), columnName);
        if (column == null) {
            return;
        }
        ExpandoValue value = this.expandoValuePersistence.fetchByT_C_C(table.getTableId(), column.getColumnId(), classPK);
        if (value != null) {
            this.deleteValue(value.getValueId());
        }
    }

    public void deleteValue(String className, String tableName, String columnName, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.deleteValue(classNameId, tableName, columnName, classPK);
    }

    public void deleteValues(long classNameId, long classPK) throws SystemException {
        this.expandoValuePersistence.removeByC_C(classNameId, classPK);
    }

    public void deleteValues(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.deleteValues(classNameId, classPK);
    }

    public List<ExpandoValue> getColumnValues(long columnId, int start, int end) throws SystemException {
        return this.expandoValuePersistence.findByColumnId(columnId, start, end);
    }

    public List<ExpandoValue> getColumnValues(long classNameId, String tableName, String columnName, int start, int end) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.EMPTY_LIST;
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(table.getTableId(), columnName);
        if (column == null) {
            return Collections.EMPTY_LIST;
        }
        return this.expandoValuePersistence.findByT_C(table.getTableId(), column.getColumnId(), start, end);
    }

    public List<ExpandoValue> getColumnValues(long classNameId, String tableName, String columnName, String data, int start, int end) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.EMPTY_LIST;
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(table.getTableId(), columnName);
        if (column == null) {
            return Collections.EMPTY_LIST;
        }
        return this.expandoValuePersistence.findByT_C_D(table.getTableId(), column.getColumnId(), data, start, end);
    }

    public List<ExpandoValue> getColumnValues(String className, String tableName, String columnName, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getColumnValues(classNameId, tableName, columnName, start, end);
    }

    public List<ExpandoValue> getColumnValues(String className, String tableName, String columnName, String data, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getColumnValues(classNameId, tableName, columnName, data, start, end);
    }

    public int getColumnValuesCount(long columnId) throws SystemException {
        return this.expandoValuePersistence.countByColumnId(columnId);
    }

    public int getColumnValuesCount(long classNameId, String tableName, String columnName) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(table.getTableId(), columnName);
        if (column == null) {
            return 0;
        }
        return this.expandoValuePersistence.countByT_C(table.getTableId(), column.getColumnId());
    }

    public int getColumnValuesCount(long classNameId, String tableName, String columnName, String data) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(table.getTableId(), columnName);
        if (column == null) {
            return 0;
        }
        return this.expandoValuePersistence.countByT_C_D(table.getTableId(), column.getColumnId(), data);
    }

    public int getColumnValuesCount(String className, String tableName, String columnName) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getColumnValuesCount(classNameId, tableName, columnName);
    }

    public int getColumnValuesCount(String className, String tableName, String columnName, String data) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getColumnValuesCount(classNameId, tableName, columnName, data);
    }

    public Serializable getData(String className, String tableName, String columnName, long classPK) throws PortalException, SystemException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(className, tableName, columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setColumnId(column.getColumnId());
        value.setData(column.getDefaultData());
        int type = column.getType();
        if (type == 1) {
            return Boolean.valueOf(this.getData(className, tableName, columnName, classPK, value.getBoolean()));
        }
        if (type == 2) {
            return this.getData(className, tableName, columnName, classPK, value.getBooleanArray());
        }
        if (type == 3) {
            return this.getData(className, tableName, columnName, classPK, value.getDate());
        }
        if (type == 4) {
            return this.getData(className, tableName, columnName, classPK, value.getDateArray());
        }
        if (type == 5) {
            return Double.valueOf(this.getData(className, tableName, columnName, classPK, value.getDouble()));
        }
        if (type == 6) {
            return this.getData(className, tableName, columnName, classPK, value.getDoubleArray());
        }
        if (type == 7) {
            return Float.valueOf(this.getData(className, tableName, columnName, classPK, value.getFloat()));
        }
        if (type == 8) {
            return this.getData(className, tableName, columnName, classPK, value.getFloatArray());
        }
        if (type == 9) {
            return Integer.valueOf(this.getData(className, tableName, columnName, classPK, value.getInteger()));
        }
        if (type == 10) {
            return this.getData(className, tableName, columnName, classPK, value.getIntegerArray());
        }
        if (type == 11) {
            return Long.valueOf(this.getData(className, tableName, columnName, classPK, value.getLong()));
        }
        if (type == 12) {
            return this.getData(className, tableName, columnName, classPK, value.getLongArray());
        }
        if (type == 13) {
            return Short.valueOf(this.getData(className, tableName, columnName, classPK, value.getShort()));
        }
        if (type == 14) {
            return this.getData(className, tableName, columnName, classPK, value.getShortArray());
        }
        if (type == 16) {
            return this.getData(className, tableName, columnName, classPK, value.getStringArray());
        }
        return this.getData(className, tableName, columnName, classPK, value.getString());
    }

    public boolean getData(String className, String tableName, String columnName, long classPK, boolean defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getBoolean();
    }

    public boolean[] getData(String className, String tableName, String columnName, long classPK, boolean[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getBooleanArray();
    }

    public Date getData(String className, String tableName, String columnName, long classPK, Date defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDate();
    }

    public Date[] getData(String className, String tableName, String columnName, long classPK, Date[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDateArray();
    }

    public double getData(String className, String tableName, String columnName, long classPK, double defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDouble();
    }

    public double[] getData(String className, String tableName, String columnName, long classPK, double[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDoubleArray();
    }

    public float getData(String className, String tableName, String columnName, long classPK, float defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getFloat();
    }

    public float[] getData(String className, String tableName, String columnName, long classPK, float[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getFloatArray();
    }

    public int getData(String className, String tableName, String columnName, long classPK, int defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getInteger();
    }

    public int[] getData(String className, String tableName, String columnName, long classPK, int[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getIntegerArray();
    }

    public long getData(String className, String tableName, String columnName, long classPK, long defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getLong();
    }

    public long[] getData(String className, String tableName, String columnName, long classPK, long[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getLongArray();
    }

    public short getData(String className, String tableName, String columnName, long classPK, short defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getShort();
    }

    public short[] getData(String className, String tableName, String columnName, long classPK, short[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getShortArray();
    }

    public String getData(String className, String tableName, String columnName, long classPK, String defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getString();
    }

    public String[] getData(String className, String tableName, String columnName, long classPK, String[] defaultData) throws PortalException, SystemException {
        ExpandoValue value = this.getValue(className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getStringArray();
    }

    public List<ExpandoValue> getDefaultTableColumnValues(long classNameId, String columnName, int start, int end) throws SystemException {
        return this.getColumnValues(classNameId, "DEFAULT_TABLE", columnName, start, end);
    }

    public List<ExpandoValue> getDefaultTableColumnValues(String className, String columnName, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getDefaultTableColumnValues(classNameId, columnName, start, end);
    }

    public int getDefaultTableColumnValuesCount(long classNameId, String columnName) throws SystemException {
        return this.getColumnValuesCount(classNameId, "DEFAULT_TABLE", columnName);
    }

    public int getDefaultTableColumnValuesCount(String className, String columnName) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getDefaultTableColumnValuesCount(classNameId, columnName);
    }

    public List<ExpandoValue> getRowValues(long rowId) throws SystemException {
        return this.expandoValuePersistence.findByRowId(rowId);
    }

    public List<ExpandoValue> getRowValues(long rowId, int start, int end) throws SystemException {
        return this.expandoValuePersistence.findByRowId(rowId, start, end);
    }

    public List<ExpandoValue> getRowValues(long classNameId, String tableName, long classPK, int start, int end) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.EMPTY_LIST;
        }
        return this.expandoValuePersistence.findByT_CPK(table.getTableId(), classPK, start, end);
    }

    public List<ExpandoValue> getRowValues(String className, String tableName, long classPK, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getRowValues(classNameId, tableName, classPK, start, end);
    }

    public int getRowValuesCount(long rowId) throws SystemException {
        return this.expandoValuePersistence.countByRowId(rowId);
    }

    public int getRowValuesCount(long classNameId, String tableName, long classPK) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        return this.expandoValuePersistence.countByT_CPK(table.getTableId(), classPK);
    }

    public int getRowValuesCount(String className, String tableName, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getRowValuesCount(classNameId, tableName, classPK);
    }

    public ExpandoValue getValue(long valueId) throws PortalException, SystemException {
        return this.expandoValuePersistence.findByPrimaryKey(valueId);
    }

    public ExpandoValue getValue(long columnId, long rowId) throws PortalException, SystemException {
        return this.expandoValuePersistence.findByC_R(columnId, rowId);
    }

    public ExpandoValue getValue(long tableId, long columnId, long classPK) throws SystemException {
        return this.expandoValuePersistence.fetchByT_C_C(tableId, columnId, classPK);
    }

    public ExpandoValue getValue(long classNameId, String tableName, String columnName, long classPK) throws SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return null;
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(table.getTableId(), columnName);
        if (column == null) {
            return null;
        }
        return this.expandoValuePersistence.fetchByT_C_C(table.getTableId(), column.getColumnId(), classPK);
    }

    public ExpandoValue getValue(String className, String tableName, String columnName, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getValue(classNameId, tableName, columnName, classPK);
    }
}

