/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.util;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.model.ExpandoValue;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexer;
import java.util.ArrayList;
import java.util.List;

public class ExpandoBridgeIndexerImpl
implements ExpandoBridgeIndexer {
    private static Log _log = LogFactoryUtil.getLog(ExpandoBridgeIndexerImpl.class);

    public void addAttributes(Document doc, ExpandoBridge expandoBridge) {
        if (expandoBridge == null) {
            return;
        }
        try {
            this.doAddAttributes(doc, expandoBridge);
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
        }
    }

    protected void doAddAttributes(Document doc, ExpandoBridge expandoBridge) throws SystemException {
        List expandoColumns = ExpandoColumnLocalServiceUtil.getDefaultTableColumns((String)expandoBridge.getClassName());
        if (expandoColumns == null || expandoColumns.isEmpty()) {
            return;
        }
        ArrayList<ExpandoColumn> indexedColumns = new ArrayList<ExpandoColumn>();
        for (ExpandoColumn expandoColumn : expandoColumns) {
            UnicodeProperties properties = expandoColumn.getTypeSettingsProperties();
            boolean indexable = GetterUtil.getBoolean((String)((String)properties.get((Object)"indexable")));
            if (!indexable) continue;
            indexedColumns.add(expandoColumn);
        }
        if (indexedColumns.isEmpty()) {
            return;
        }
        List expandoValues = ExpandoValueLocalServiceUtil.getRowValues((String)expandoBridge.getClassName(), (String)"DEFAULT_TABLE", (long)expandoBridge.getClassPK(), (int)-1, (int)-1);
        for (ExpandoColumn expandoColumn : indexedColumns) {
            try {
                String value = expandoColumn.getDefaultData();
                for (ExpandoValue expandoValue : expandoValues) {
                    if (expandoValue.getColumnId() != expandoColumn.getColumnId()) continue;
                    value = expandoValue.getData();
                    break;
                }
                doc.addText(expandoColumn.getName(), value);
            }
            catch (Exception e) {
                _log.error((Object)("Indexing " + expandoColumn.getName()), (Throwable)e);
            }
        }
    }
}

