/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.flags.messaging;

import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portlet.flags.messaging.FlagsRequest;
import com.liferay.util.UniqueList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlagsRequestMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(FlagsRequestMessageListener.class);

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process message " + message), (Throwable)e);
        }
    }

    protected void doReceive(Message message) throws Exception {
        FlagsRequest flagsRequest = (FlagsRequest)message.getPayload();
        ServiceContext serviceContext = flagsRequest.getServiceContext();
        long companyId = serviceContext.getCompanyId();
        Company company = CompanyLocalServiceUtil.getCompany((long)serviceContext.getCompanyId());
        Layout layout = LayoutLocalServiceUtil.getLayout((long)serviceContext.getPlid());
        Group group = layout.getGroup();
        String groupName = group.getDescriptiveName();
        String reporterUserName = null;
        String reporterEmailAddress = null;
        User reporterUser = UserLocalServiceUtil.getUserById((long)serviceContext.getUserId());
        Locale locale = LocaleUtil.getDefault();
        if (reporterUser.isDefaultUser()) {
            reporterUserName = LanguageUtil.get((Locale)locale, (String)"anonymous");
        } else {
            reporterUserName = reporterUser.getFullName();
            reporterEmailAddress = reporterUser.getEmailAddress();
        }
        String reportedUserName = "";
        String reportedEmailAddress = "";
        String reportedURL = "";
        User reportedUser = UserLocalServiceUtil.getUserById((long)flagsRequest.getReportedUserId());
        if (reportedUser.isDefaultUser()) {
            reportedUserName = group.getDescriptiveName();
        } else {
            reportedUserName = reportedUser.getFullName();
            reportedEmailAddress = reportedUser.getEmailAddress();
            reportedURL = reportedUser.getDisplayURL(serviceContext.getPortalURL(), serviceContext.getPathMain());
        }
        String contentType = LanguageUtil.get((Locale)locale, (String)("model.resource." + flagsRequest.getClassName()));
        String reason = LanguageUtil.get((Locale)locale, (String)flagsRequest.getReason());
        String fromName = PrefsPropsUtil.getString(companyId, "flags.email.from.name");
        String fromAddress = PrefsPropsUtil.getString(companyId, "flags.email.from.address");
        String subject = PrefsPropsUtil.getContent(companyId, "flags.email.subject");
        String body = PrefsPropsUtil.getContent(companyId, "flags.email.body");
        List<User> recipients = this.getRecipients(companyId, serviceContext.getScopeGroupId());
        for (User recipient : recipients) {
            try {
                this.notify(company, groupName, reporterEmailAddress, reporterUserName, reportedEmailAddress, reportedUserName, reportedURL, flagsRequest.getClassPK(), flagsRequest.getContentTitle(), contentType, flagsRequest.getContentURL(), reason, fromName, fromAddress, recipient.getFullName(), recipient.getEmailAddress(), subject, body, serviceContext);
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)ioe);
            }
        }
    }

    protected List<User> getRecipients(long companyId, long groupId) throws PortalException, SystemException {
        UniqueList recipients = new UniqueList();
        ArrayList<String> roleNames = new ArrayList<String>();
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isCommunity()) {
            roleNames.add("Community Administrator");
            roleNames.add("Community Owner");
        } else if (group.isOrganization()) {
            roleNames.add("Organization Administrator");
            roleNames.add("Organization Owner");
        }
        for (String roleName : roleNames) {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)roleName);
            List userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroupAndRole((long)groupId, (long)role.getRoleId());
            for (UserGroupRole userGroupRole : userGroupRoles) {
                recipients.add(userGroupRole.getUser());
            }
        }
        if (recipients.isEmpty()) {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Administrator");
            recipients.addAll(UserLocalServiceUtil.getRoleUsers((long)role.getRoleId()));
        }
        return recipients;
    }

    protected void notify(Company company, String groupName, String reporterEmailAddress, String reporterUserName, String reportedEmailAddress, String reportedUserName, String reportedUserURL, long contentId, String contentTitle, String contentType, String contentURL, String reason, String fromName, String fromAddress, String toName, String toAddress, String subject, String body, ServiceContext serviceContext) throws IOException {
        Date now = new Date();
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$COMMUNITY_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$CONTENT_ID$]", "[$CONTENT_TITLE$]", "[$CONTENT_TYPE$]", "[$CONTENT_URL$]", "[$DATE$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$REASON$]", "[$REPORTED_USER_ADDRESS$]", "[$REPORTED_USER_NAME$]", "[$REPORTED_USER_URL$]", "[$REPORTER_USER_ADDRESS$]", "[$REPORTER_USER_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{groupName, String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), String.valueOf(contentId), contentTitle, contentType, contentURL, now.toString(), fromAddress, fromName, serviceContext.getPortalURL(), reason, reportedEmailAddress, reportedUserName, reportedUserURL, reporterEmailAddress, reporterUserName, toAddress, toName});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$COMMUNITY_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$CONTENT_ID$]", "[$CONTENT_TITLE$]", "[$CONTENT_TYPE$]", "[$CONTENT_URL$]", "[$DATE$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$PORTAL_URL$]", "[$REASON$]", "[$REPORTED_USER_ADDRESS$]", "[$REPORTED_USER_NAME$]", "[$REPORTED_USER_URL$]", "[$REPORTER_USER_ADDRESS$]", "[$REPORTER_USER_NAME$]", "[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{groupName, String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), String.valueOf(contentId), contentTitle, contentType, contentURL, now.toString(), fromAddress, fromName, serviceContext.getPortalURL(), reason, reportedEmailAddress, reportedUserName, reportedUserURL, reporterEmailAddress, reporterUserName, toAddress, toName});
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        InternetAddress to = new InternetAddress(toAddress, toName);
        MailMessage message = new MailMessage(from, to, subject, body, true);
        MailServiceUtil.sendEmail((MailMessage)message);
    }
}

