/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.iframe.action;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.iframe.util.IFrameUtil;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ViewAction
extends PortletAction {
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        String src = this.transformSrc(renderRequest, renderResponse);
        if (Validator.isNull((String)src)) {
            return mapping.findForward("/portal/portlet_not_setup");
        }
        renderRequest.setAttribute("IFRAME_SRC", (Object)src);
        return mapping.findForward("portlet.iframe.view");
    }

    protected String getSrc(RenderRequest renderRequest, RenderResponse renderResponse) {
        PortletPreferences preferences = renderRequest.getPreferences();
        String src = preferences.getValue("src", "");
        src = ParamUtil.getString((PortletRequest)renderRequest, (String)"src", (String)src);
        return src;
    }

    protected String getUserName(RenderRequest renderRequest, RenderResponse renderResponse) throws PortalException, SystemException {
        PortletPreferences preferences = renderRequest.getPreferences();
        String userName = preferences.getValue("user-name", "");
        return IFrameUtil.getUserName((PortletRequest)renderRequest, userName);
    }

    protected String getPassword(RenderRequest renderRequest, RenderResponse renderResponse) {
        PortletPreferences preferences = renderRequest.getPreferences();
        String password = preferences.getValue("password", "");
        return IFrameUtil.getPassword((PortletRequest)renderRequest, password);
    }

    protected String transformSrc(RenderRequest renderRequest, RenderResponse renderResponse) throws PortalException, SystemException {
        PortletPreferences preferences = renderRequest.getPreferences();
        String src = this.getSrc(renderRequest, renderResponse);
        boolean auth = GetterUtil.getBoolean((String)preferences.getValue("auth", ""));
        String authType = preferences.getValue("auth-type", "");
        String userName = this.getUserName(renderRequest, renderResponse);
        String password = this.getPassword(renderRequest, renderResponse);
        if (auth) {
            if (authType.equals("basic")) {
                int pos = src.indexOf("://");
                String protocol = src.substring(0, pos + 3);
                String url = src.substring(pos + 3, src.length());
                src = protocol + userName + ":" + password + "@" + url;
            } else {
                ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
                String portletId = PortalUtil.getPortletId((PortletRequest)renderRequest);
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
                src = themeDisplay.getPathMain() + "/" + portlet.getStrutsPath() + "/proxy?p_l_id=" + themeDisplay.getPlid() + "&p_p_id=" + portletId;
            }
        }
        return src;
    }
}

